// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.ec2.inputs.AmiCopyEbsBlockDeviceArgs;
import com.pulumi.aws.ec2.inputs.AmiCopyEphemeralBlockDeviceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AmiCopyArgs extends com.pulumi.resources.ResourceArgs {

    public static final AmiCopyArgs Empty = new AmiCopyArgs();

    /**
     * Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     * 
     */
    @Import(name="deprecationTime")
    private @Nullable Output<String> deprecationTime;

    /**
     * @return Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     * 
     */
    public Optional<Output<String>> deprecationTime() {
        return Optional.ofNullable(this.deprecationTime);
    }

    /**
     * Longer, human-readable description for the AMI.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Longer, human-readable description for the AMI.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * ARN of the Outpost to which to copy the AMI.
     * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
     * 
     */
    @Import(name="destinationOutpostArn")
    private @Nullable Output<String> destinationOutpostArn;

    /**
     * @return ARN of the Outpost to which to copy the AMI.
     * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
     * 
     */
    public Optional<Output<String>> destinationOutpostArn() {
        return Optional.ofNullable(this.destinationOutpostArn);
    }

    /**
     * Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     * 
     */
    @Import(name="ebsBlockDevices")
    private @Nullable Output<List<AmiCopyEbsBlockDeviceArgs>> ebsBlockDevices;

    /**
     * @return Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     * 
     */
    public Optional<Output<List<AmiCopyEbsBlockDeviceArgs>>> ebsBlockDevices() {
        return Optional.ofNullable(this.ebsBlockDevices);
    }

    /**
     * Boolean controlling whether the created EBS volumes will be encrypted. Can&#39;t be used with `snapshot_id`.
     * 
     */
    @Import(name="encrypted")
    private @Nullable Output<Boolean> encrypted;

    /**
     * @return Boolean controlling whether the created EBS volumes will be encrypted. Can&#39;t be used with `snapshot_id`.
     * 
     */
    public Optional<Output<Boolean>> encrypted() {
        return Optional.ofNullable(this.encrypted);
    }

    /**
     * Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     * 
     */
    @Import(name="ephemeralBlockDevices")
    private @Nullable Output<List<AmiCopyEphemeralBlockDeviceArgs>> ephemeralBlockDevices;

    /**
     * @return Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     * 
     */
    public Optional<Output<List<AmiCopyEphemeralBlockDeviceArgs>>> ephemeralBlockDevices() {
        return Optional.ofNullable(this.ephemeralBlockDevices);
    }

    /**
     * Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Region-unique name for the AMI.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Region-unique name for the AMI.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Id of the AMI to copy. This id must be valid in the region
     * given by `source_ami_region`.
     * 
     */
    @Import(name="sourceAmiId", required=true)
    private Output<String> sourceAmiId;

    /**
     * @return Id of the AMI to copy. This id must be valid in the region
     * given by `source_ami_region`.
     * 
     */
    public Output<String> sourceAmiId() {
        return this.sourceAmiId;
    }

    /**
     * Region from which the AMI will be copied. This may be the
     * same as the AWS provider region in order to create a copy within the same region.
     * 
     */
    @Import(name="sourceAmiRegion", required=true)
    private Output<String> sourceAmiRegion;

    /**
     * @return Region from which the AMI will be copied. This may be the
     * same as the AWS provider region in order to create a copy within the same region.
     * 
     */
    public Output<String> sourceAmiRegion() {
        return this.sourceAmiRegion;
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private AmiCopyArgs() {}

    private AmiCopyArgs(AmiCopyArgs $) {
        this.deprecationTime = $.deprecationTime;
        this.description = $.description;
        this.destinationOutpostArn = $.destinationOutpostArn;
        this.ebsBlockDevices = $.ebsBlockDevices;
        this.encrypted = $.encrypted;
        this.ephemeralBlockDevices = $.ephemeralBlockDevices;
        this.kmsKeyId = $.kmsKeyId;
        this.name = $.name;
        this.sourceAmiId = $.sourceAmiId;
        this.sourceAmiRegion = $.sourceAmiRegion;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AmiCopyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AmiCopyArgs $;

        public Builder() {
            $ = new AmiCopyArgs();
        }

        public Builder(AmiCopyArgs defaults) {
            $ = new AmiCopyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
         * 
         * @return builder
         * 
         */
        public Builder deprecationTime(@Nullable Output<String> deprecationTime) {
            $.deprecationTime = deprecationTime;
            return this;
        }

        /**
         * @param deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
         * 
         * @return builder
         * 
         */
        public Builder deprecationTime(String deprecationTime) {
            return deprecationTime(Output.of(deprecationTime));
        }

        /**
         * @param description Longer, human-readable description for the AMI.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Longer, human-readable description for the AMI.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param destinationOutpostArn ARN of the Outpost to which to copy the AMI.
         * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
         * 
         * @return builder
         * 
         */
        public Builder destinationOutpostArn(@Nullable Output<String> destinationOutpostArn) {
            $.destinationOutpostArn = destinationOutpostArn;
            return this;
        }

        /**
         * @param destinationOutpostArn ARN of the Outpost to which to copy the AMI.
         * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
         * 
         * @return builder
         * 
         */
        public Builder destinationOutpostArn(String destinationOutpostArn) {
            return destinationOutpostArn(Output.of(destinationOutpostArn));
        }

        /**
         * @param ebsBlockDevices Nested block describing an EBS block device that should be
         * attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(@Nullable Output<List<AmiCopyEbsBlockDeviceArgs>> ebsBlockDevices) {
            $.ebsBlockDevices = ebsBlockDevices;
            return this;
        }

        /**
         * @param ebsBlockDevices Nested block describing an EBS block device that should be
         * attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(List<AmiCopyEbsBlockDeviceArgs> ebsBlockDevices) {
            return ebsBlockDevices(Output.of(ebsBlockDevices));
        }

        /**
         * @param ebsBlockDevices Nested block describing an EBS block device that should be
         * attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(AmiCopyEbsBlockDeviceArgs... ebsBlockDevices) {
            return ebsBlockDevices(List.of(ebsBlockDevices));
        }

        /**
         * @param encrypted Boolean controlling whether the created EBS volumes will be encrypted. Can&#39;t be used with `snapshot_id`.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(@Nullable Output<Boolean> encrypted) {
            $.encrypted = encrypted;
            return this;
        }

        /**
         * @param encrypted Boolean controlling whether the created EBS volumes will be encrypted. Can&#39;t be used with `snapshot_id`.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(Boolean encrypted) {
            return encrypted(Output.of(encrypted));
        }

        /**
         * @param ephemeralBlockDevices Nested block describing an ephemeral block device that
         * should be attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(@Nullable Output<List<AmiCopyEphemeralBlockDeviceArgs>> ephemeralBlockDevices) {
            $.ephemeralBlockDevices = ephemeralBlockDevices;
            return this;
        }

        /**
         * @param ephemeralBlockDevices Nested block describing an ephemeral block device that
         * should be attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(List<AmiCopyEphemeralBlockDeviceArgs> ephemeralBlockDevices) {
            return ephemeralBlockDevices(Output.of(ephemeralBlockDevices));
        }

        /**
         * @param ephemeralBlockDevices Nested block describing an ephemeral block device that
         * should be attached to created instances. The structure of this block is described below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(AmiCopyEphemeralBlockDeviceArgs... ephemeralBlockDevices) {
            return ephemeralBlockDevices(List.of(ephemeralBlockDevices));
        }

        /**
         * @param kmsKeyId Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param name Region-unique name for the AMI.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Region-unique name for the AMI.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param sourceAmiId Id of the AMI to copy. This id must be valid in the region
         * given by `source_ami_region`.
         * 
         * @return builder
         * 
         */
        public Builder sourceAmiId(Output<String> sourceAmiId) {
            $.sourceAmiId = sourceAmiId;
            return this;
        }

        /**
         * @param sourceAmiId Id of the AMI to copy. This id must be valid in the region
         * given by `source_ami_region`.
         * 
         * @return builder
         * 
         */
        public Builder sourceAmiId(String sourceAmiId) {
            return sourceAmiId(Output.of(sourceAmiId));
        }

        /**
         * @param sourceAmiRegion Region from which the AMI will be copied. This may be the
         * same as the AWS provider region in order to create a copy within the same region.
         * 
         * @return builder
         * 
         */
        public Builder sourceAmiRegion(Output<String> sourceAmiRegion) {
            $.sourceAmiRegion = sourceAmiRegion;
            return this;
        }

        /**
         * @param sourceAmiRegion Region from which the AMI will be copied. This may be the
         * same as the AWS provider region in order to create a copy within the same region.
         * 
         * @return builder
         * 
         */
        public Builder sourceAmiRegion(String sourceAmiRegion) {
            return sourceAmiRegion(Output.of(sourceAmiRegion));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public AmiCopyArgs build() {
            $.sourceAmiId = Objects.requireNonNull($.sourceAmiId, "expected parameter 'sourceAmiId' to be non-null");
            $.sourceAmiRegion = Objects.requireNonNull($.sourceAmiRegion, "expected parameter 'sourceAmiRegion' to be non-null");
            return $;
        }
    }

}
