// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ebs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SnapshotCopyArgs extends com.pulumi.resources.ResourceArgs {

    public static final SnapshotCopyArgs Empty = new SnapshotCopyArgs();

    /**
     * A description of what the snapshot is.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of what the snapshot is.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Whether the snapshot is encrypted.
     * 
     */
    @Import(name="encrypted")
    private @Nullable Output<Boolean> encrypted;

    /**
     * @return Whether the snapshot is encrypted.
     * 
     */
    public Optional<Output<Boolean>> encrypted() {
        return Optional.ofNullable(this.encrypted);
    }

    /**
     * The ARN for the KMS encryption key.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The ARN for the KMS encryption key.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Indicates whether to permanently restore an archived snapshot.
     * 
     */
    @Import(name="permanentRestore")
    private @Nullable Output<Boolean> permanentRestore;

    /**
     * @return Indicates whether to permanently restore an archived snapshot.
     * 
     */
    public Optional<Output<Boolean>> permanentRestore() {
        return Optional.ofNullable(this.permanentRestore);
    }

    /**
     * The region of the source snapshot.
     * 
     */
    @Import(name="sourceRegion", required=true)
    private Output<String> sourceRegion;

    /**
     * @return The region of the source snapshot.
     * 
     */
    public Output<String> sourceRegion() {
        return this.sourceRegion;
    }

    /**
     * The ARN for the snapshot to be copied.
     * 
     */
    @Import(name="sourceSnapshotId", required=true)
    private Output<String> sourceSnapshotId;

    /**
     * @return The ARN for the snapshot to be copied.
     * 
     */
    public Output<String> sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    /**
     * The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     * 
     */
    @Import(name="storageTier")
    private @Nullable Output<String> storageTier;

    /**
     * @return The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     * 
     */
    public Optional<Output<String>> storageTier() {
        return Optional.ofNullable(this.storageTier);
    }

    /**
     * A map of tags for the snapshot.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags for the snapshot.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     * 
     */
    @Import(name="temporaryRestoreDays")
    private @Nullable Output<Integer> temporaryRestoreDays;

    /**
     * @return Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     * 
     */
    public Optional<Output<Integer>> temporaryRestoreDays() {
        return Optional.ofNullable(this.temporaryRestoreDays);
    }

    private SnapshotCopyArgs() {}

    private SnapshotCopyArgs(SnapshotCopyArgs $) {
        this.description = $.description;
        this.encrypted = $.encrypted;
        this.kmsKeyId = $.kmsKeyId;
        this.permanentRestore = $.permanentRestore;
        this.sourceRegion = $.sourceRegion;
        this.sourceSnapshotId = $.sourceSnapshotId;
        this.storageTier = $.storageTier;
        this.tags = $.tags;
        this.temporaryRestoreDays = $.temporaryRestoreDays;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SnapshotCopyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SnapshotCopyArgs $;

        public Builder() {
            $ = new SnapshotCopyArgs();
        }

        public Builder(SnapshotCopyArgs defaults) {
            $ = new SnapshotCopyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A description of what the snapshot is.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of what the snapshot is.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param encrypted Whether the snapshot is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(@Nullable Output<Boolean> encrypted) {
            $.encrypted = encrypted;
            return this;
        }

        /**
         * @param encrypted Whether the snapshot is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(Boolean encrypted) {
            return encrypted(Output.of(encrypted));
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param permanentRestore Indicates whether to permanently restore an archived snapshot.
         * 
         * @return builder
         * 
         */
        public Builder permanentRestore(@Nullable Output<Boolean> permanentRestore) {
            $.permanentRestore = permanentRestore;
            return this;
        }

        /**
         * @param permanentRestore Indicates whether to permanently restore an archived snapshot.
         * 
         * @return builder
         * 
         */
        public Builder permanentRestore(Boolean permanentRestore) {
            return permanentRestore(Output.of(permanentRestore));
        }

        /**
         * @param sourceRegion The region of the source snapshot.
         * 
         * @return builder
         * 
         */
        public Builder sourceRegion(Output<String> sourceRegion) {
            $.sourceRegion = sourceRegion;
            return this;
        }

        /**
         * @param sourceRegion The region of the source snapshot.
         * 
         * @return builder
         * 
         */
        public Builder sourceRegion(String sourceRegion) {
            return sourceRegion(Output.of(sourceRegion));
        }

        /**
         * @param sourceSnapshotId The ARN for the snapshot to be copied.
         * 
         * @return builder
         * 
         */
        public Builder sourceSnapshotId(Output<String> sourceSnapshotId) {
            $.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        /**
         * @param sourceSnapshotId The ARN for the snapshot to be copied.
         * 
         * @return builder
         * 
         */
        public Builder sourceSnapshotId(String sourceSnapshotId) {
            return sourceSnapshotId(Output.of(sourceSnapshotId));
        }

        /**
         * @param storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
         * 
         * @return builder
         * 
         */
        public Builder storageTier(@Nullable Output<String> storageTier) {
            $.storageTier = storageTier;
            return this;
        }

        /**
         * @param storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
         * 
         * @return builder
         * 
         */
        public Builder storageTier(String storageTier) {
            return storageTier(Output.of(storageTier));
        }

        /**
         * @param tags A map of tags for the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags for the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
         * 
         * @return builder
         * 
         */
        public Builder temporaryRestoreDays(@Nullable Output<Integer> temporaryRestoreDays) {
            $.temporaryRestoreDays = temporaryRestoreDays;
            return this;
        }

        /**
         * @param temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
         * 
         * @return builder
         * 
         */
        public Builder temporaryRestoreDays(Integer temporaryRestoreDays) {
            return temporaryRestoreDays(Output.of(temporaryRestoreDays));
        }

        public SnapshotCopyArgs build() {
            $.sourceRegion = Objects.requireNonNull($.sourceRegion, "expected parameter 'sourceRegion' to be non-null");
            $.sourceSnapshotId = Objects.requireNonNull($.sourceSnapshotId, "expected parameter 'sourceSnapshotId' to be non-null");
            return $;
        }
    }

}
