// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ebs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SnapshotArgs extends com.pulumi.resources.ResourceArgs {

    public static final SnapshotArgs Empty = new SnapshotArgs();

    /**
     * A description of what the snapshot is.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of what the snapshot is.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * 
     */
    @Import(name="outpostArn")
    private @Nullable Output<String> outpostArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     * 
     */
    public Optional<Output<String>> outpostArn() {
        return Optional.ofNullable(this.outpostArn);
    }

    /**
     * Indicates whether to permanently restore an archived snapshot.
     * 
     */
    @Import(name="permanentRestore")
    private @Nullable Output<Boolean> permanentRestore;

    /**
     * @return Indicates whether to permanently restore an archived snapshot.
     * 
     */
    public Optional<Output<Boolean>> permanentRestore() {
        return Optional.ofNullable(this.permanentRestore);
    }

    /**
     * The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     * 
     */
    @Import(name="storageTier")
    private @Nullable Output<String> storageTier;

    /**
     * @return The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     * 
     */
    public Optional<Output<String>> storageTier() {
        return Optional.ofNullable(this.storageTier);
    }

    /**
     * A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     * 
     */
    @Import(name="temporaryRestoreDays")
    private @Nullable Output<Integer> temporaryRestoreDays;

    /**
     * @return Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     * 
     */
    public Optional<Output<Integer>> temporaryRestoreDays() {
        return Optional.ofNullable(this.temporaryRestoreDays);
    }

    /**
     * The Volume ID of which to make a snapshot.
     * 
     */
    @Import(name="volumeId", required=true)
    private Output<String> volumeId;

    /**
     * @return The Volume ID of which to make a snapshot.
     * 
     */
    public Output<String> volumeId() {
        return this.volumeId;
    }

    private SnapshotArgs() {}

    private SnapshotArgs(SnapshotArgs $) {
        this.description = $.description;
        this.outpostArn = $.outpostArn;
        this.permanentRestore = $.permanentRestore;
        this.storageTier = $.storageTier;
        this.tags = $.tags;
        this.temporaryRestoreDays = $.temporaryRestoreDays;
        this.volumeId = $.volumeId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SnapshotArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SnapshotArgs $;

        public Builder() {
            $ = new SnapshotArgs();
        }

        public Builder(SnapshotArgs defaults) {
            $ = new SnapshotArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A description of what the snapshot is.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of what the snapshot is.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
         * 
         * @return builder
         * 
         */
        public Builder outpostArn(@Nullable Output<String> outpostArn) {
            $.outpostArn = outpostArn;
            return this;
        }

        /**
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
         * 
         * @return builder
         * 
         */
        public Builder outpostArn(String outpostArn) {
            return outpostArn(Output.of(outpostArn));
        }

        /**
         * @param permanentRestore Indicates whether to permanently restore an archived snapshot.
         * 
         * @return builder
         * 
         */
        public Builder permanentRestore(@Nullable Output<Boolean> permanentRestore) {
            $.permanentRestore = permanentRestore;
            return this;
        }

        /**
         * @param permanentRestore Indicates whether to permanently restore an archived snapshot.
         * 
         * @return builder
         * 
         */
        public Builder permanentRestore(Boolean permanentRestore) {
            return permanentRestore(Output.of(permanentRestore));
        }

        /**
         * @param storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
         * 
         * @return builder
         * 
         */
        public Builder storageTier(@Nullable Output<String> storageTier) {
            $.storageTier = storageTier;
            return this;
        }

        /**
         * @param storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
         * 
         * @return builder
         * 
         */
        public Builder storageTier(String storageTier) {
            return storageTier(Output.of(storageTier));
        }

        /**
         * @param tags A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
         * 
         * @return builder
         * 
         */
        public Builder temporaryRestoreDays(@Nullable Output<Integer> temporaryRestoreDays) {
            $.temporaryRestoreDays = temporaryRestoreDays;
            return this;
        }

        /**
         * @param temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
         * 
         * @return builder
         * 
         */
        public Builder temporaryRestoreDays(Integer temporaryRestoreDays) {
            return temporaryRestoreDays(Output.of(temporaryRestoreDays));
        }

        /**
         * @param volumeId The Volume ID of which to make a snapshot.
         * 
         * @return builder
         * 
         */
        public Builder volumeId(Output<String> volumeId) {
            $.volumeId = volumeId;
            return this;
        }

        /**
         * @param volumeId The Volume ID of which to make a snapshot.
         * 
         * @return builder
         * 
         */
        public Builder volumeId(String volumeId) {
            return volumeId(Output.of(volumeId));
        }

        public SnapshotArgs build() {
            $.volumeId = Objects.requireNonNull($.volumeId, "expected parameter 'volumeId' to be non-null");
            return $;
        }
    }

}
