// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dynamodb;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TableItemArgs extends com.pulumi.resources.ResourceArgs {

    public static final TableItemArgs Empty = new TableItemArgs();

    /**
     * Hash key to use for lookups and identification of the item
     * 
     */
    @Import(name="hashKey", required=true)
    private Output<String> hashKey;

    /**
     * @return Hash key to use for lookups and identification of the item
     * 
     */
    public Output<String> hashKey() {
        return this.hashKey;
    }

    /**
     * JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
     * 
     */
    @Import(name="item", required=true)
    private Output<String> item;

    /**
     * @return JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
     * 
     */
    public Output<String> item() {
        return this.item;
    }

    /**
     * Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
     * 
     */
    @Import(name="rangeKey")
    private @Nullable Output<String> rangeKey;

    /**
     * @return Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
     * 
     */
    public Optional<Output<String>> rangeKey() {
        return Optional.ofNullable(this.rangeKey);
    }

    /**
     * Name of the table to contain the item.
     * 
     */
    @Import(name="tableName", required=true)
    private Output<String> tableName;

    /**
     * @return Name of the table to contain the item.
     * 
     */
    public Output<String> tableName() {
        return this.tableName;
    }

    private TableItemArgs() {}

    private TableItemArgs(TableItemArgs $) {
        this.hashKey = $.hashKey;
        this.item = $.item;
        this.rangeKey = $.rangeKey;
        this.tableName = $.tableName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TableItemArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TableItemArgs $;

        public Builder() {
            $ = new TableItemArgs();
        }

        public Builder(TableItemArgs defaults) {
            $ = new TableItemArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param hashKey Hash key to use for lookups and identification of the item
         * 
         * @return builder
         * 
         */
        public Builder hashKey(Output<String> hashKey) {
            $.hashKey = hashKey;
            return this;
        }

        /**
         * @param hashKey Hash key to use for lookups and identification of the item
         * 
         * @return builder
         * 
         */
        public Builder hashKey(String hashKey) {
            return hashKey(Output.of(hashKey));
        }

        /**
         * @param item JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
         * 
         * @return builder
         * 
         */
        public Builder item(Output<String> item) {
            $.item = item;
            return this;
        }

        /**
         * @param item JSON representation of a map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.
         * 
         * @return builder
         * 
         */
        public Builder item(String item) {
            return item(Output.of(item));
        }

        /**
         * @param rangeKey Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
         * 
         * @return builder
         * 
         */
        public Builder rangeKey(@Nullable Output<String> rangeKey) {
            $.rangeKey = rangeKey;
            return this;
        }

        /**
         * @param rangeKey Range key to use for lookups and identification of the item. Required if there is range key defined in the table.
         * 
         * @return builder
         * 
         */
        public Builder rangeKey(String rangeKey) {
            return rangeKey(Output.of(rangeKey));
        }

        /**
         * @param tableName Name of the table to contain the item.
         * 
         * @return builder
         * 
         */
        public Builder tableName(Output<String> tableName) {
            $.tableName = tableName;
            return this;
        }

        /**
         * @param tableName Name of the table to contain the item.
         * 
         * @return builder
         * 
         */
        public Builder tableName(String tableName) {
            return tableName(Output.of(tableName));
        }

        public TableItemArgs build() {
            $.hashKey = Objects.requireNonNull($.hashKey, "expected parameter 'hashKey' to be non-null");
            $.item = Objects.requireNonNull($.item, "expected parameter 'item' to be non-null");
            $.tableName = Objects.requireNonNull($.tableName, "expected parameter 'tableName' to be non-null");
            return $;
        }
    }

}
