// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dynamodb;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs;
import com.pulumi.aws.dynamodb.inputs.KinesisStreamingDestinationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Enables a [Kinesis streaming destination](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/kds.html) for data replication of a DynamoDB table.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dynamodb.Table;
 * import com.pulumi.aws.dynamodb.TableArgs;
 * import com.pulumi.aws.dynamodb.inputs.TableAttributeArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestination;
 * import com.pulumi.aws.dynamodb.KinesisStreamingDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleTable = new Table(&#34;exampleTable&#34;, TableArgs.builder()        
 *             .hashKey(&#34;id&#34;)
 *             .attributes(TableAttributeArgs.builder()
 *                 .name(&#34;id&#34;)
 *                 .type(&#34;S&#34;)
 *                 .build())
 *             .build());
 * 
 *         var exampleStream = new Stream(&#34;exampleStream&#34;, StreamArgs.builder()        
 *             .shardCount(1)
 *             .build());
 * 
 *         var exampleKinesisStreamingDestination = new KinesisStreamingDestination(&#34;exampleKinesisStreamingDestination&#34;, KinesisStreamingDestinationArgs.builder()        
 *             .streamArn(exampleStream.arn())
 *             .tableName(exampleTable.name())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import DynamoDB Kinesis Streaming Destinations using the `table_name` and `stream_arn` separated by `,`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination example example,arn:aws:kinesis:us-east-1:111122223333:exampleStreamName
 * ```
 * 
 */
@ResourceType(type="aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination")
public class KinesisStreamingDestination extends com.pulumi.resources.CustomResource {
    /**
     * The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
     * 
     */
    @Export(name="streamArn", refs={String.class}, tree="[0]")
    private Output<String> streamArn;

    /**
     * @return The ARN for a Kinesis data stream. This must exist in the same account and region as the DynamoDB table.
     * 
     */
    public Output<String> streamArn() {
        return this.streamArn;
    }
    /**
     * The name of the DynamoDB table. There
     * can only be one Kinesis streaming destination for a given DynamoDB table.
     * 
     */
    @Export(name="tableName", refs={String.class}, tree="[0]")
    private Output<String> tableName;

    /**
     * @return The name of the DynamoDB table. There
     * can only be one Kinesis streaming destination for a given DynamoDB table.
     * 
     */
    public Output<String> tableName() {
        return this.tableName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public KinesisStreamingDestination(String name) {
        this(name, KinesisStreamingDestinationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public KinesisStreamingDestination(String name, KinesisStreamingDestinationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public KinesisStreamingDestination(String name, KinesisStreamingDestinationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination", name, args == null ? KinesisStreamingDestinationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private KinesisStreamingDestination(String name, Output<String> id, @Nullable KinesisStreamingDestinationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:dynamodb/kinesisStreamingDestination:KinesisStreamingDestination", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static KinesisStreamingDestination get(String name, Output<String> id, @Nullable KinesisStreamingDestinationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new KinesisStreamingDestination(name, id, state, options);
    }
}
