// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.docdb;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterArgs Empty = new ClusterArgs();

    /**
     * Specifies whether any cluster modifications
     * are applied immediately, or during the next maintenance window. Default is
     * `false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any cluster modifications
     * are applied immediately, or during the next maintenance window. Default is
     * `false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     * 
     */
    @Import(name="availabilityZones")
    private @Nullable Output<List<String>> availabilityZones;

    /**
     * @return A list of EC2 Availability Zones that
     * instances in the DB cluster can be created in.
     * 
     */
    public Optional<Output<List<String>>> availabilityZones() {
        return Optional.ofNullable(this.availabilityZones);
    }

    /**
     * The days to retain backups for. Default `1`
     * 
     */
    @Import(name="backupRetentionPeriod")
    private @Nullable Output<Integer> backupRetentionPeriod;

    /**
     * @return The days to retain backups for. Default `1`
     * 
     */
    public Optional<Output<Integer>> backupRetentionPeriod() {
        return Optional.ofNullable(this.backupRetentionPeriod);
    }

    /**
     * The cluster identifier. If omitted, the provider will assign a random, unique identifier.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier. If omitted, the provider will assign a random, unique identifier.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     * 
     */
    @Import(name="clusterIdentifierPrefix")
    private @Nullable Output<String> clusterIdentifierPrefix;

    /**
     * @return Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     * 
     */
    public Optional<Output<String>> clusterIdentifierPrefix() {
        return Optional.ofNullable(this.clusterIdentifierPrefix);
    }

    /**
     * List of DocumentDB Instances that are a part of this cluster
     * 
     */
    @Import(name="clusterMembers")
    private @Nullable Output<List<String>> clusterMembers;

    /**
     * @return List of DocumentDB Instances that are a part of this cluster
     * 
     */
    public Optional<Output<List<String>>> clusterMembers() {
        return Optional.ofNullable(this.clusterMembers);
    }

    /**
     * A cluster parameter group to associate with the cluster.
     * 
     */
    @Import(name="dbClusterParameterGroupName")
    private @Nullable Output<String> dbClusterParameterGroupName;

    /**
     * @return A cluster parameter group to associate with the cluster.
     * 
     */
    public Optional<Output<String>> dbClusterParameterGroupName() {
        return Optional.ofNullable(this.dbClusterParameterGroupName);
    }

    /**
     * A DB subnet group to associate with this DB instance.
     * 
     */
    @Import(name="dbSubnetGroupName")
    private @Nullable Output<String> dbSubnetGroupName;

    /**
     * @return A DB subnet group to associate with this DB instance.
     * 
     */
    public Optional<Output<String>> dbSubnetGroupName() {
        return Optional.ofNullable(this.dbSubnetGroupName);
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can&#39;t be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * 
     */
    @Import(name="deletionProtection")
    private @Nullable Output<Boolean> deletionProtection;

    /**
     * @return A value that indicates whether the DB cluster has deletion protection enabled. The database can&#39;t be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * 
     */
    public Optional<Output<Boolean>> deletionProtection() {
        return Optional.ofNullable(this.deletionProtection);
    }

    /**
     * List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     * 
     */
    @Import(name="enabledCloudwatchLogsExports")
    private @Nullable Output<List<String>> enabledCloudwatchLogsExports;

    /**
     * @return List of log types to export to cloudwatch. If omitted, no logs will be exported.
     * The following log types are supported: `audit`, `profiler`.
     * 
     */
    public Optional<Output<List<String>>> enabledCloudwatchLogsExports() {
        return Optional.ofNullable(this.enabledCloudwatchLogsExports);
    }

    /**
     * The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid Values: `docdb`
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid Values: `docdb`
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * The database engine version. Updating this argument results in an outage.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return The database engine version. Updating this argument results in an outage.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * The name of your final DB snapshot
     * when this DB cluster is deleted. If omitted, no final snapshot will be
     * made.
     * 
     */
    @Import(name="finalSnapshotIdentifier")
    private @Nullable Output<String> finalSnapshotIdentifier;

    /**
     * @return The name of your final DB snapshot
     * when this DB cluster is deleted. If omitted, no final snapshot will be
     * made.
     * 
     */
    public Optional<Output<String>> finalSnapshotIdentifier() {
        return Optional.ofNullable(this.finalSnapshotIdentifier);
    }

    /**
     * The global cluster identifier specified on `aws.docdb.GlobalCluster`.
     * 
     */
    @Import(name="globalClusterIdentifier")
    private @Nullable Output<String> globalClusterIdentifier;

    /**
     * @return The global cluster identifier specified on `aws.docdb.GlobalCluster`.
     * 
     */
    public Optional<Output<String>> globalClusterIdentifier() {
        return Optional.ofNullable(this.globalClusterIdentifier);
    }

    /**
     * The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Password for the master DB user. Note that this may
     * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
     * 
     */
    @Import(name="masterPassword")
    private @Nullable Output<String> masterPassword;

    /**
     * @return Password for the master DB user. Note that this may
     * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
     * 
     */
    public Optional<Output<String>> masterPassword() {
        return Optional.ofNullable(this.masterPassword);
    }

    /**
     * Username for the master DB user.
     * 
     */
    @Import(name="masterUsername")
    private @Nullable Output<String> masterUsername;

    /**
     * @return Username for the master DB user.
     * 
     */
    public Optional<Output<String>> masterUsername() {
        return Optional.ofNullable(this.masterUsername);
    }

    /**
     * The port on which the DB accepts connections
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port on which the DB accepts connections
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
     * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
     * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     * 
     */
    @Import(name="skipFinalSnapshot")
    private @Nullable Output<Boolean> skipFinalSnapshot;

    /**
     * @return Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> skipFinalSnapshot() {
        return Optional.ofNullable(this.skipFinalSnapshot);
    }

    /**
     * Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     * 
     */
    @Import(name="snapshotIdentifier")
    private @Nullable Output<String> snapshotIdentifier;

    /**
     * @return Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
     * 
     */
    public Optional<Output<String>> snapshotIdentifier() {
        return Optional.ofNullable(this.snapshotIdentifier);
    }

    /**
     * Specifies whether the DB cluster is encrypted. The default is `false`.
     * 
     */
    @Import(name="storageEncrypted")
    private @Nullable Output<Boolean> storageEncrypted;

    /**
     * @return Specifies whether the DB cluster is encrypted. The default is `false`.
     * 
     */
    public Optional<Output<Boolean>> storageEncrypted() {
        return Optional.ofNullable(this.storageEncrypted);
    }

    /**
     * A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * List of VPC security groups to associate
     * with the Cluster
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return List of VPC security groups to associate
     * with the Cluster
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private ClusterArgs() {}

    private ClusterArgs(ClusterArgs $) {
        this.applyImmediately = $.applyImmediately;
        this.availabilityZones = $.availabilityZones;
        this.backupRetentionPeriod = $.backupRetentionPeriod;
        this.clusterIdentifier = $.clusterIdentifier;
        this.clusterIdentifierPrefix = $.clusterIdentifierPrefix;
        this.clusterMembers = $.clusterMembers;
        this.dbClusterParameterGroupName = $.dbClusterParameterGroupName;
        this.dbSubnetGroupName = $.dbSubnetGroupName;
        this.deletionProtection = $.deletionProtection;
        this.enabledCloudwatchLogsExports = $.enabledCloudwatchLogsExports;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.finalSnapshotIdentifier = $.finalSnapshotIdentifier;
        this.globalClusterIdentifier = $.globalClusterIdentifier;
        this.kmsKeyId = $.kmsKeyId;
        this.masterPassword = $.masterPassword;
        this.masterUsername = $.masterUsername;
        this.port = $.port;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.skipFinalSnapshot = $.skipFinalSnapshot;
        this.snapshotIdentifier = $.snapshotIdentifier;
        this.storageEncrypted = $.storageEncrypted;
        this.tags = $.tags;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterArgs $;

        public Builder() {
            $ = new ClusterArgs();
        }

        public Builder(ClusterArgs defaults) {
            $ = new ClusterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications
         * are applied immediately, or during the next maintenance window. Default is
         * `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications
         * are applied immediately, or during the next maintenance window. Default is
         * `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param availabilityZones A list of EC2 Availability Zones that
         * instances in the DB cluster can be created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(@Nullable Output<List<String>> availabilityZones) {
            $.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * @param availabilityZones A list of EC2 Availability Zones that
         * instances in the DB cluster can be created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(List<String> availabilityZones) {
            return availabilityZones(Output.of(availabilityZones));
        }

        /**
         * @param availabilityZones A list of EC2 Availability Zones that
         * instances in the DB cluster can be created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(String... availabilityZones) {
            return availabilityZones(List.of(availabilityZones));
        }

        /**
         * @param backupRetentionPeriod The days to retain backups for. Default `1`
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionPeriod(@Nullable Output<Integer> backupRetentionPeriod) {
            $.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * @param backupRetentionPeriod The days to retain backups for. Default `1`
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            return backupRetentionPeriod(Output.of(backupRetentionPeriod));
        }

        /**
         * @param clusterIdentifier The cluster identifier. If omitted, the provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The cluster identifier. If omitted, the provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifierPrefix(@Nullable Output<String> clusterIdentifierPrefix) {
            $.clusterIdentifierPrefix = clusterIdentifierPrefix;
            return this;
        }

        /**
         * @param clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifierPrefix(String clusterIdentifierPrefix) {
            return clusterIdentifierPrefix(Output.of(clusterIdentifierPrefix));
        }

        /**
         * @param clusterMembers List of DocumentDB Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(@Nullable Output<List<String>> clusterMembers) {
            $.clusterMembers = clusterMembers;
            return this;
        }

        /**
         * @param clusterMembers List of DocumentDB Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(List<String> clusterMembers) {
            return clusterMembers(Output.of(clusterMembers));
        }

        /**
         * @param clusterMembers List of DocumentDB Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(String... clusterMembers) {
            return clusterMembers(List.of(clusterMembers));
        }

        /**
         * @param dbClusterParameterGroupName A cluster parameter group to associate with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterParameterGroupName(@Nullable Output<String> dbClusterParameterGroupName) {
            $.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        /**
         * @param dbClusterParameterGroupName A cluster parameter group to associate with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            return dbClusterParameterGroupName(Output.of(dbClusterParameterGroupName));
        }

        /**
         * @param dbSubnetGroupName A DB subnet group to associate with this DB instance.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(@Nullable Output<String> dbSubnetGroupName) {
            $.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * @param dbSubnetGroupName A DB subnet group to associate with this DB instance.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            return dbSubnetGroupName(Output.of(dbSubnetGroupName));
        }

        /**
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. The database can&#39;t be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * 
         * @return builder
         * 
         */
        public Builder deletionProtection(@Nullable Output<Boolean> deletionProtection) {
            $.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. The database can&#39;t be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * 
         * @return builder
         * 
         */
        public Builder deletionProtection(Boolean deletionProtection) {
            return deletionProtection(Output.of(deletionProtection));
        }

        /**
         * @param enabledCloudwatchLogsExports List of log types to export to cloudwatch. If omitted, no logs will be exported.
         * The following log types are supported: `audit`, `profiler`.
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(@Nullable Output<List<String>> enabledCloudwatchLogsExports) {
            $.enabledCloudwatchLogsExports = enabledCloudwatchLogsExports;
            return this;
        }

        /**
         * @param enabledCloudwatchLogsExports List of log types to export to cloudwatch. If omitted, no logs will be exported.
         * The following log types are supported: `audit`, `profiler`.
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(List<String> enabledCloudwatchLogsExports) {
            return enabledCloudwatchLogsExports(Output.of(enabledCloudwatchLogsExports));
        }

        /**
         * @param enabledCloudwatchLogsExports List of log types to export to cloudwatch. If omitted, no logs will be exported.
         * The following log types are supported: `audit`, `profiler`.
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            return enabledCloudwatchLogsExports(List.of(enabledCloudwatchLogsExports));
        }

        /**
         * @param engine The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid Values: `docdb`
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine The name of the database engine to be used for this DB cluster. Defaults to `docdb`. Valid Values: `docdb`
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion The database engine version. Updating this argument results in an outage.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion The database engine version. Updating this argument results in an outage.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param finalSnapshotIdentifier The name of your final DB snapshot
         * when this DB cluster is deleted. If omitted, no final snapshot will be
         * made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(@Nullable Output<String> finalSnapshotIdentifier) {
            $.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        /**
         * @param finalSnapshotIdentifier The name of your final DB snapshot
         * when this DB cluster is deleted. If omitted, no final snapshot will be
         * made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            return finalSnapshotIdentifier(Output.of(finalSnapshotIdentifier));
        }

        /**
         * @param globalClusterIdentifier The global cluster identifier specified on `aws.docdb.GlobalCluster`.
         * 
         * @return builder
         * 
         */
        public Builder globalClusterIdentifier(@Nullable Output<String> globalClusterIdentifier) {
            $.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        /**
         * @param globalClusterIdentifier The global cluster identifier specified on `aws.docdb.GlobalCluster`.
         * 
         * @return builder
         * 
         */
        public Builder globalClusterIdentifier(String globalClusterIdentifier) {
            return globalClusterIdentifier(Output.of(globalClusterIdentifier));
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param masterPassword Password for the master DB user. Note that this may
         * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(@Nullable Output<String> masterPassword) {
            $.masterPassword = masterPassword;
            return this;
        }

        /**
         * @param masterPassword Password for the master DB user. Note that this may
         * show up in logs, and it will be stored in the state file. Please refer to the DocumentDB Naming Constraints.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(String masterPassword) {
            return masterPassword(Output.of(masterPassword));
        }

        /**
         * @param masterUsername Username for the master DB user.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(@Nullable Output<String> masterUsername) {
            $.masterUsername = masterUsername;
            return this;
        }

        /**
         * @param masterUsername Username for the master DB user.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(String masterUsername) {
            return masterUsername(Output.of(masterUsername));
        }

        /**
         * @param port The port on which the DB accepts connections
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port on which the DB accepts connections
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
         * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC
         * Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param skipFinalSnapshot Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(@Nullable Output<Boolean> skipFinalSnapshot) {
            $.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        /**
         * @param skipFinalSnapshot Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            return skipFinalSnapshot(Output.of(skipFinalSnapshot));
        }

        /**
         * @param snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(@Nullable Output<String> snapshotIdentifier) {
            $.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * @param snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Automated snapshots **should not** be used for this attribute, unless from a different cluster. Automated snapshots are deleted as part of cluster destruction when the resource is replaced.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(String snapshotIdentifier) {
            return snapshotIdentifier(Output.of(snapshotIdentifier));
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(@Nullable Output<Boolean> storageEncrypted) {
            $.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(Boolean storageEncrypted) {
            return storageEncrypted(Output.of(storageEncrypted));
        }

        /**
         * @param tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate
         * with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate
         * with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate
         * with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public ClusterArgs build() {
            return $;
        }
    }

}
