// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dms.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointS3SettingsArgs extends com.pulumi.resources.ResourceArgs {

    public static final EndpointS3SettingsArgs Empty = new EndpointS3SettingsArgs();

    /**
     * Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    @Import(name="addColumnName")
    private @Nullable Output<Boolean> addColumnName;

    /**
     * @return Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> addColumnName() {
        return Optional.ofNullable(this.addColumnName);
    }

    /**
     * Custom S3 Bucket Object prefix for intermediate storage.
     * 
     */
    @Import(name="bucketFolder")
    private @Nullable Output<String> bucketFolder;

    /**
     * @return Custom S3 Bucket Object prefix for intermediate storage.
     * 
     */
    public Optional<Output<String>> bucketFolder() {
        return Optional.ofNullable(this.bucketFolder);
    }

    /**
     * Custom S3 Bucket name for intermediate storage.
     * 
     */
    @Import(name="bucketName")
    private @Nullable Output<String> bucketName;

    /**
     * @return Custom S3 Bucket name for intermediate storage.
     * 
     */
    public Optional<Output<String>> bucketName() {
        return Optional.ofNullable(this.bucketName);
    }

    /**
     * Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    @Import(name="cannedAclForObjects")
    private @Nullable Output<String> cannedAclForObjects;

    /**
     * @return Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    public Optional<Output<String>> cannedAclForObjects() {
        return Optional.ofNullable(this.cannedAclForObjects);
    }

    /**
     * Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Import(name="cdcInsertsAndUpdates")
    private @Nullable Output<Boolean> cdcInsertsAndUpdates;

    /**
     * @return Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> cdcInsertsAndUpdates() {
        return Optional.ofNullable(this.cdcInsertsAndUpdates);
    }

    /**
     * Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Import(name="cdcInsertsOnly")
    private @Nullable Output<Boolean> cdcInsertsOnly;

    /**
     * @return Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> cdcInsertsOnly() {
        return Optional.ofNullable(this.cdcInsertsOnly);
    }

    /**
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
     * 
     */
    @Import(name="cdcMaxBatchInterval")
    private @Nullable Output<Integer> cdcMaxBatchInterval;

    /**
     * @return Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
     * 
     */
    public Optional<Output<Integer>> cdcMaxBatchInterval() {
        return Optional.ofNullable(this.cdcMaxBatchInterval);
    }

    /**
     * Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
     * 
     */
    @Import(name="cdcMinFileSize")
    private @Nullable Output<Integer> cdcMinFileSize;

    /**
     * @return Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
     * 
     */
    public Optional<Output<Integer>> cdcMinFileSize() {
        return Optional.ofNullable(this.cdcMinFileSize);
    }

    /**
     * Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it&#39;s optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    @Import(name="cdcPath")
    private @Nullable Output<String> cdcPath;

    /**
     * @return Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it&#39;s optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    public Optional<Output<String>> cdcPath() {
        return Optional.ofNullable(this.cdcPath);
    }

    /**
     * Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
     * 
     */
    @Import(name="compressionType")
    private @Nullable Output<String> compressionType;

    /**
     * @return Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
     * 
     */
    public Optional<Output<String>> compressionType() {
        return Optional.ofNullable(this.compressionType);
    }

    /**
     * Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    @Import(name="csvDelimiter")
    private @Nullable Output<String> csvDelimiter;

    /**
     * @return Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    public Optional<Output<String>> csvDelimiter() {
        return Optional.ofNullable(this.csvDelimiter);
    }

    /**
     * String to use for all columns not included in the supplemental log.
     * 
     */
    @Import(name="csvNoSupValue")
    private @Nullable Output<String> csvNoSupValue;

    /**
     * @return String to use for all columns not included in the supplemental log.
     * 
     */
    public Optional<Output<String>> csvNoSupValue() {
        return Optional.ofNullable(this.csvNoSupValue);
    }

    /**
     * String to as null when writing to the target.
     * 
     */
    @Import(name="csvNullValue")
    private @Nullable Output<String> csvNullValue;

    /**
     * @return String to as null when writing to the target.
     * 
     */
    public Optional<Output<String>> csvNullValue() {
        return Optional.ofNullable(this.csvNullValue);
    }

    /**
     * Delimiter used to separate rows in the source files. Default is `\n`.
     * 
     */
    @Import(name="csvRowDelimiter")
    private @Nullable Output<String> csvRowDelimiter;

    /**
     * @return Delimiter used to separate rows in the source files. Default is `\n`.
     * 
     */
    public Optional<Output<String>> csvRowDelimiter() {
        return Optional.ofNullable(this.csvRowDelimiter);
    }

    /**
     * Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
     * 
     */
    @Import(name="dataFormat")
    private @Nullable Output<String> dataFormat;

    /**
     * @return Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
     * 
     */
    public Optional<Output<String>> dataFormat() {
        return Optional.ofNullable(this.dataFormat);
    }

    /**
     * Size of one data page in bytes. Default is `1048576` (1 MiB).
     * 
     */
    @Import(name="dataPageSize")
    private @Nullable Output<Integer> dataPageSize;

    /**
     * @return Size of one data page in bytes. Default is `1048576` (1 MiB).
     * 
     */
    public Optional<Output<Integer>> dataPageSize() {
        return Optional.ofNullable(this.dataPageSize);
    }

    /**
     * Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
     * 
     */
    @Import(name="datePartitionDelimiter")
    private @Nullable Output<String> datePartitionDelimiter;

    /**
     * @return Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
     * 
     */
    public Optional<Output<String>> datePartitionDelimiter() {
        return Optional.ofNullable(this.datePartitionDelimiter);
    }

    /**
     * Partition S3 bucket folders based on transaction commit dates. Default is `false`.
     * 
     */
    @Import(name="datePartitionEnabled")
    private @Nullable Output<Boolean> datePartitionEnabled;

    /**
     * @return Partition S3 bucket folders based on transaction commit dates. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> datePartitionEnabled() {
        return Optional.ofNullable(this.datePartitionEnabled);
    }

    /**
     * Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
     * 
     */
    @Import(name="datePartitionSequence")
    private @Nullable Output<String> datePartitionSequence;

    /**
     * @return Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
     * 
     */
    public Optional<Output<String>> datePartitionSequence() {
        return Optional.ofNullable(this.datePartitionSequence);
    }

    /**
     * Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
     * 
     */
    @Import(name="dictPageSizeLimit")
    private @Nullable Output<Integer> dictPageSizeLimit;

    /**
     * @return Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
     * 
     */
    public Optional<Output<Integer>> dictPageSizeLimit() {
        return Optional.ofNullable(this.dictPageSizeLimit);
    }

    /**
     * Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    @Import(name="enableStatistics")
    private @Nullable Output<Boolean> enableStatistics;

    /**
     * @return Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> enableStatistics() {
        return Optional.ofNullable(this.enableStatistics);
    }

    /**
     * Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
     * 
     */
    @Import(name="encodingType")
    private @Nullable Output<String> encodingType;

    /**
     * @return Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
     * 
     */
    public Optional<Output<String>> encodingType() {
        return Optional.ofNullable(this.encodingType);
    }

    /**
     * The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
     * 
     */
    @Import(name="encryptionMode")
    private @Nullable Output<String> encryptionMode;

    /**
     * @return The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
     * 
     */
    public Optional<Output<String>> encryptionMode() {
        return Optional.ofNullable(this.encryptionMode);
    }

    /**
     * JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    @Import(name="externalTableDefinition")
    private @Nullable Output<String> externalTableDefinition;

    /**
     * @return JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    public Optional<Output<String>> externalTableDefinition() {
        return Optional.ofNullable(this.externalTableDefinition);
    }

    /**
     * When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
     * 
     */
    @Import(name="ignoreHeaderRows")
    private @Nullable Output<Integer> ignoreHeaderRows;

    /**
     * @return When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
     * 
     */
    public Optional<Output<Integer>> ignoreHeaderRows() {
        return Optional.ofNullable(this.ignoreHeaderRows);
    }

    /**
     * Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    @Import(name="includeOpForFullLoad")
    private @Nullable Output<Boolean> includeOpForFullLoad;

    /**
     * @return Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> includeOpForFullLoad() {
        return Optional.ofNullable(this.includeOpForFullLoad);
    }

    /**
     * Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
     * 
     */
    @Import(name="maxFileSize")
    private @Nullable Output<Integer> maxFileSize;

    /**
     * @return Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
     * 
     */
    public Optional<Output<Integer>> maxFileSize() {
        return Optional.ofNullable(this.maxFileSize);
    }

    /**
     * Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
     * 
     */
    @Import(name="parquetTimestampInMillisecond")
    private @Nullable Output<Boolean> parquetTimestampInMillisecond;

    /**
     * @return Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> parquetTimestampInMillisecond() {
        return Optional.ofNullable(this.parquetTimestampInMillisecond);
    }

    /**
     * Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
     * 
     */
    @Import(name="parquetVersion")
    private @Nullable Output<String> parquetVersion;

    /**
     * @return Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
     * 
     */
    public Optional<Output<String>> parquetVersion() {
        return Optional.ofNullable(this.parquetVersion);
    }

    /**
     * Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
     * 
     */
    @Import(name="preserveTransactions")
    private @Nullable Output<Boolean> preserveTransactions;

    /**
     * @return Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> preserveTransactions() {
        return Optional.ofNullable(this.preserveTransactions);
    }

    /**
     * For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    @Import(name="rfc4180")
    private @Nullable Output<Boolean> rfc4180;

    /**
     * @return For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> rfc4180() {
        return Optional.ofNullable(this.rfc4180);
    }

    /**
     * Number of rows in a row group. Default is `10000`.
     * 
     */
    @Import(name="rowGroupLength")
    private @Nullable Output<Integer> rowGroupLength;

    /**
     * @return Number of rows in a row group. Default is `10000`.
     * 
     */
    public Optional<Output<Integer>> rowGroupLength() {
        return Optional.ofNullable(this.rowGroupLength);
    }

    /**
     * ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     * 
     */
    @Import(name="serverSideEncryptionKmsKeyId")
    private @Nullable Output<String> serverSideEncryptionKmsKeyId;

    /**
     * @return ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
     * 
     */
    public Optional<Output<String>> serverSideEncryptionKmsKeyId() {
        return Optional.ofNullable(this.serverSideEncryptionKmsKeyId);
    }

    /**
     * ARN of the IAM Role with permissions to write to the OpenSearch cluster.
     * 
     */
    @Import(name="serviceAccessRoleArn")
    private @Nullable Output<String> serviceAccessRoleArn;

    /**
     * @return ARN of the IAM Role with permissions to write to the OpenSearch cluster.
     * 
     */
    public Optional<Output<String>> serviceAccessRoleArn() {
        return Optional.ofNullable(this.serviceAccessRoleArn);
    }

    /**
     * Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    @Import(name="timestampColumnName")
    private @Nullable Output<String> timestampColumnName;

    /**
     * @return Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    public Optional<Output<String>> timestampColumnName() {
        return Optional.ofNullable(this.timestampColumnName);
    }

    /**
     * Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
     * 
     */
    @Import(name="useCsvNoSupValue")
    private @Nullable Output<Boolean> useCsvNoSupValue;

    /**
     * @return Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
     * 
     */
    public Optional<Output<Boolean>> useCsvNoSupValue() {
        return Optional.ofNullable(this.useCsvNoSupValue);
    }

    /**
     * When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    @Import(name="useTaskStartTimeForFullLoadTimestamp")
    private @Nullable Output<Boolean> useTaskStartTimeForFullLoadTimestamp;

    /**
     * @return When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> useTaskStartTimeForFullLoadTimestamp() {
        return Optional.ofNullable(this.useTaskStartTimeForFullLoadTimestamp);
    }

    private EndpointS3SettingsArgs() {}

    private EndpointS3SettingsArgs(EndpointS3SettingsArgs $) {
        this.addColumnName = $.addColumnName;
        this.bucketFolder = $.bucketFolder;
        this.bucketName = $.bucketName;
        this.cannedAclForObjects = $.cannedAclForObjects;
        this.cdcInsertsAndUpdates = $.cdcInsertsAndUpdates;
        this.cdcInsertsOnly = $.cdcInsertsOnly;
        this.cdcMaxBatchInterval = $.cdcMaxBatchInterval;
        this.cdcMinFileSize = $.cdcMinFileSize;
        this.cdcPath = $.cdcPath;
        this.compressionType = $.compressionType;
        this.csvDelimiter = $.csvDelimiter;
        this.csvNoSupValue = $.csvNoSupValue;
        this.csvNullValue = $.csvNullValue;
        this.csvRowDelimiter = $.csvRowDelimiter;
        this.dataFormat = $.dataFormat;
        this.dataPageSize = $.dataPageSize;
        this.datePartitionDelimiter = $.datePartitionDelimiter;
        this.datePartitionEnabled = $.datePartitionEnabled;
        this.datePartitionSequence = $.datePartitionSequence;
        this.dictPageSizeLimit = $.dictPageSizeLimit;
        this.enableStatistics = $.enableStatistics;
        this.encodingType = $.encodingType;
        this.encryptionMode = $.encryptionMode;
        this.externalTableDefinition = $.externalTableDefinition;
        this.ignoreHeaderRows = $.ignoreHeaderRows;
        this.includeOpForFullLoad = $.includeOpForFullLoad;
        this.maxFileSize = $.maxFileSize;
        this.parquetTimestampInMillisecond = $.parquetTimestampInMillisecond;
        this.parquetVersion = $.parquetVersion;
        this.preserveTransactions = $.preserveTransactions;
        this.rfc4180 = $.rfc4180;
        this.rowGroupLength = $.rowGroupLength;
        this.serverSideEncryptionKmsKeyId = $.serverSideEncryptionKmsKeyId;
        this.serviceAccessRoleArn = $.serviceAccessRoleArn;
        this.timestampColumnName = $.timestampColumnName;
        this.useCsvNoSupValue = $.useCsvNoSupValue;
        this.useTaskStartTimeForFullLoadTimestamp = $.useTaskStartTimeForFullLoadTimestamp;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointS3SettingsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointS3SettingsArgs $;

        public Builder() {
            $ = new EndpointS3SettingsArgs();
        }

        public Builder(EndpointS3SettingsArgs defaults) {
            $ = new EndpointS3SettingsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param addColumnName Whether to add column name information to the .csv output file. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder addColumnName(@Nullable Output<Boolean> addColumnName) {
            $.addColumnName = addColumnName;
            return this;
        }

        /**
         * @param addColumnName Whether to add column name information to the .csv output file. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder addColumnName(Boolean addColumnName) {
            return addColumnName(Output.of(addColumnName));
        }

        /**
         * @param bucketFolder Custom S3 Bucket Object prefix for intermediate storage.
         * 
         * @return builder
         * 
         */
        public Builder bucketFolder(@Nullable Output<String> bucketFolder) {
            $.bucketFolder = bucketFolder;
            return this;
        }

        /**
         * @param bucketFolder Custom S3 Bucket Object prefix for intermediate storage.
         * 
         * @return builder
         * 
         */
        public Builder bucketFolder(String bucketFolder) {
            return bucketFolder(Output.of(bucketFolder));
        }

        /**
         * @param bucketName Custom S3 Bucket name for intermediate storage.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(@Nullable Output<String> bucketName) {
            $.bucketName = bucketName;
            return this;
        }

        /**
         * @param bucketName Custom S3 Bucket name for intermediate storage.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(String bucketName) {
            return bucketName(Output.of(bucketName));
        }

        /**
         * @param cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
         * 
         * @return builder
         * 
         */
        public Builder cannedAclForObjects(@Nullable Output<String> cannedAclForObjects) {
            $.cannedAclForObjects = cannedAclForObjects;
            return this;
        }

        /**
         * @param cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
         * 
         * @return builder
         * 
         */
        public Builder cannedAclForObjects(String cannedAclForObjects) {
            return cannedAclForObjects(Output.of(cannedAclForObjects));
        }

        /**
         * @param cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsAndUpdates(@Nullable Output<Boolean> cdcInsertsAndUpdates) {
            $.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        /**
         * @param cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            return cdcInsertsAndUpdates(Output.of(cdcInsertsAndUpdates));
        }

        /**
         * @param cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsOnly(@Nullable Output<Boolean> cdcInsertsOnly) {
            $.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        /**
         * @param cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            return cdcInsertsOnly(Output.of(cdcInsertsOnly));
        }

        /**
         * @param cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
         * 
         * @return builder
         * 
         */
        public Builder cdcMaxBatchInterval(@Nullable Output<Integer> cdcMaxBatchInterval) {
            $.cdcMaxBatchInterval = cdcMaxBatchInterval;
            return this;
        }

        /**
         * @param cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. Default is `60`.
         * 
         * @return builder
         * 
         */
        public Builder cdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            return cdcMaxBatchInterval(Output.of(cdcMaxBatchInterval));
        }

        /**
         * @param cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
         * 
         * @return builder
         * 
         */
        public Builder cdcMinFileSize(@Nullable Output<Integer> cdcMinFileSize) {
            $.cdcMinFileSize = cdcMinFileSize;
            return this;
        }

        /**
         * @param cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. Default is `32000`. **NOTE:** Previously, this setting was measured in megabytes but now represents kilobytes. Update configurations accordingly.
         * 
         * @return builder
         * 
         */
        public Builder cdcMinFileSize(Integer cdcMinFileSize) {
            return cdcMinFileSize(Output.of(cdcMinFileSize));
        }

        /**
         * @param cdcPath Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it&#39;s optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
         * 
         * @return builder
         * 
         */
        public Builder cdcPath(@Nullable Output<String> cdcPath) {
            $.cdcPath = cdcPath;
            return this;
        }

        /**
         * @param cdcPath Folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it&#39;s optional. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
         * 
         * @return builder
         * 
         */
        public Builder cdcPath(String cdcPath) {
            return cdcPath(Output.of(cdcPath));
        }

        /**
         * @param compressionType Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
         * 
         * @return builder
         * 
         */
        public Builder compressionType(@Nullable Output<String> compressionType) {
            $.compressionType = compressionType;
            return this;
        }

        /**
         * @param compressionType Set to compress target files. Default is `NONE`. Valid values are `GZIP` and `NONE`.
         * 
         * @return builder
         * 
         */
        public Builder compressionType(String compressionType) {
            return compressionType(Output.of(compressionType));
        }

        /**
         * @param csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
         * 
         * @return builder
         * 
         */
        public Builder csvDelimiter(@Nullable Output<String> csvDelimiter) {
            $.csvDelimiter = csvDelimiter;
            return this;
        }

        /**
         * @param csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
         * 
         * @return builder
         * 
         */
        public Builder csvDelimiter(String csvDelimiter) {
            return csvDelimiter(Output.of(csvDelimiter));
        }

        /**
         * @param csvNoSupValue String to use for all columns not included in the supplemental log.
         * 
         * @return builder
         * 
         */
        public Builder csvNoSupValue(@Nullable Output<String> csvNoSupValue) {
            $.csvNoSupValue = csvNoSupValue;
            return this;
        }

        /**
         * @param csvNoSupValue String to use for all columns not included in the supplemental log.
         * 
         * @return builder
         * 
         */
        public Builder csvNoSupValue(String csvNoSupValue) {
            return csvNoSupValue(Output.of(csvNoSupValue));
        }

        /**
         * @param csvNullValue String to as null when writing to the target.
         * 
         * @return builder
         * 
         */
        public Builder csvNullValue(@Nullable Output<String> csvNullValue) {
            $.csvNullValue = csvNullValue;
            return this;
        }

        /**
         * @param csvNullValue String to as null when writing to the target.
         * 
         * @return builder
         * 
         */
        public Builder csvNullValue(String csvNullValue) {
            return csvNullValue(Output.of(csvNullValue));
        }

        /**
         * @param csvRowDelimiter Delimiter used to separate rows in the source files. Default is `\n`.
         * 
         * @return builder
         * 
         */
        public Builder csvRowDelimiter(@Nullable Output<String> csvRowDelimiter) {
            $.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        /**
         * @param csvRowDelimiter Delimiter used to separate rows in the source files. Default is `\n`.
         * 
         * @return builder
         * 
         */
        public Builder csvRowDelimiter(String csvRowDelimiter) {
            return csvRowDelimiter(Output.of(csvRowDelimiter));
        }

        /**
         * @param dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
         * 
         * @return builder
         * 
         */
        public Builder dataFormat(@Nullable Output<String> dataFormat) {
            $.dataFormat = dataFormat;
            return this;
        }

        /**
         * @param dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`. Default is `csv`.
         * 
         * @return builder
         * 
         */
        public Builder dataFormat(String dataFormat) {
            return dataFormat(Output.of(dataFormat));
        }

        /**
         * @param dataPageSize Size of one data page in bytes. Default is `1048576` (1 MiB).
         * 
         * @return builder
         * 
         */
        public Builder dataPageSize(@Nullable Output<Integer> dataPageSize) {
            $.dataPageSize = dataPageSize;
            return this;
        }

        /**
         * @param dataPageSize Size of one data page in bytes. Default is `1048576` (1 MiB).
         * 
         * @return builder
         * 
         */
        public Builder dataPageSize(Integer dataPageSize) {
            return dataPageSize(Output.of(dataPageSize));
        }

        /**
         * @param datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionDelimiter(@Nullable Output<String> datePartitionDelimiter) {
            $.datePartitionDelimiter = datePartitionDelimiter;
            return this;
        }

        /**
         * @param datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. Default is `SLASH`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionDelimiter(String datePartitionDelimiter) {
            return datePartitionDelimiter(Output.of(datePartitionDelimiter));
        }

        /**
         * @param datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionEnabled(@Nullable Output<Boolean> datePartitionEnabled) {
            $.datePartitionEnabled = datePartitionEnabled;
            return this;
        }

        /**
         * @param datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionEnabled(Boolean datePartitionEnabled) {
            return datePartitionEnabled(Output.of(datePartitionEnabled));
        }

        /**
         * @param datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionSequence(@Nullable Output<String> datePartitionSequence) {
            $.datePartitionSequence = datePartitionSequence;
            return this;
        }

        /**
         * @param datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. Default is `YYYYMMDD`.
         * 
         * @return builder
         * 
         */
        public Builder datePartitionSequence(String datePartitionSequence) {
            return datePartitionSequence(Output.of(datePartitionSequence));
        }

        /**
         * @param dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
         * 
         * @return builder
         * 
         */
        public Builder dictPageSizeLimit(@Nullable Output<Integer> dictPageSizeLimit) {
            $.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        /**
         * @param dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. Default is `1048576` (1 MiB).
         * 
         * @return builder
         * 
         */
        public Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            return dictPageSizeLimit(Output.of(dictPageSizeLimit));
        }

        /**
         * @param enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder enableStatistics(@Nullable Output<Boolean> enableStatistics) {
            $.enableStatistics = enableStatistics;
            return this;
        }

        /**
         * @param enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder enableStatistics(Boolean enableStatistics) {
            return enableStatistics(Output.of(enableStatistics));
        }

        /**
         * @param encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
         * 
         * @return builder
         * 
         */
        public Builder encodingType(@Nullable Output<String> encodingType) {
            $.encodingType = encodingType;
            return this;
        }

        /**
         * @param encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. Default is `rle_dictionary`.
         * 
         * @return builder
         * 
         */
        public Builder encodingType(String encodingType) {
            return encodingType(Output.of(encodingType));
        }

        /**
         * @param encryptionMode The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(@Nullable Output<String> encryptionMode) {
            $.encryptionMode = encryptionMode;
            return this;
        }

        /**
         * @param encryptionMode The server-side encryption mode that you want to encrypt your intermediate .csv object files copied to S3. Defaults to `SSE_S3`. Valid values are `SSE_S3` and `SSE_KMS`.
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(String encryptionMode) {
            return encryptionMode(Output.of(encryptionMode));
        }

        /**
         * @param externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
         * 
         * @return builder
         * 
         */
        public Builder externalTableDefinition(@Nullable Output<String> externalTableDefinition) {
            $.externalTableDefinition = externalTableDefinition;
            return this;
        }

        /**
         * @param externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
         * 
         * @return builder
         * 
         */
        public Builder externalTableDefinition(String externalTableDefinition) {
            return externalTableDefinition(Output.of(externalTableDefinition));
        }

        /**
         * @param ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreHeaderRows(@Nullable Output<Integer> ignoreHeaderRows) {
            $.ignoreHeaderRows = ignoreHeaderRows;
            return this;
        }

        /**
         * @param ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. Default is `0`.
         * 
         * @return builder
         * 
         */
        public Builder ignoreHeaderRows(Integer ignoreHeaderRows) {
            return ignoreHeaderRows(Output.of(ignoreHeaderRows));
        }

        /**
         * @param includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder includeOpForFullLoad(@Nullable Output<Boolean> includeOpForFullLoad) {
            $.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        /**
         * @param includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            return includeOpForFullLoad(Output.of(includeOpForFullLoad));
        }

        /**
         * @param maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
         * 
         * @return builder
         * 
         */
        public Builder maxFileSize(@Nullable Output<Integer> maxFileSize) {
            $.maxFileSize = maxFileSize;
            return this;
        }

        /**
         * @param maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. Default is `1048576` (1 GB).
         * 
         * @return builder
         * 
         */
        public Builder maxFileSize(Integer maxFileSize) {
            return maxFileSize(Output.of(maxFileSize));
        }

        /**
         * @param parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder parquetTimestampInMillisecond(@Nullable Output<Boolean> parquetTimestampInMillisecond) {
            $.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
            return this;
        }

        /**
         * @param parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            return parquetTimestampInMillisecond(Output.of(parquetTimestampInMillisecond));
        }

        /**
         * @param parquetVersion Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
         * 
         * @return builder
         * 
         */
        public Builder parquetVersion(@Nullable Output<String> parquetVersion) {
            $.parquetVersion = parquetVersion;
            return this;
        }

        /**
         * @param parquetVersion Version of the .parquet file format. Default is `parquet-1-0`. Valid values are `parquet-1-0` and `parquet-2-0`.
         * 
         * @return builder
         * 
         */
        public Builder parquetVersion(String parquetVersion) {
            return parquetVersion(Output.of(parquetVersion));
        }

        /**
         * @param preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder preserveTransactions(@Nullable Output<Boolean> preserveTransactions) {
            $.preserveTransactions = preserveTransactions;
            return this;
        }

        /**
         * @param preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder preserveTransactions(Boolean preserveTransactions) {
            return preserveTransactions(Output.of(preserveTransactions));
        }

        /**
         * @param rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder rfc4180(@Nullable Output<Boolean> rfc4180) {
            $.rfc4180 = rfc4180;
            return this;
        }

        /**
         * @param rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder rfc4180(Boolean rfc4180) {
            return rfc4180(Output.of(rfc4180));
        }

        /**
         * @param rowGroupLength Number of rows in a row group. Default is `10000`.
         * 
         * @return builder
         * 
         */
        public Builder rowGroupLength(@Nullable Output<Integer> rowGroupLength) {
            $.rowGroupLength = rowGroupLength;
            return this;
        }

        /**
         * @param rowGroupLength Number of rows in a row group. Default is `10000`.
         * 
         * @return builder
         * 
         */
        public Builder rowGroupLength(Integer rowGroupLength) {
            return rowGroupLength(Output.of(rowGroupLength));
        }

        /**
         * @param serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionKmsKeyId(@Nullable Output<String> serverSideEncryptionKmsKeyId) {
            $.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        /**
         * @param serverSideEncryptionKmsKeyId ARN or Id of KMS Key to use when `encryption_mode` is `SSE_KMS`.
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            return serverSideEncryptionKmsKeyId(Output.of(serverSideEncryptionKmsKeyId));
        }

        /**
         * @param serviceAccessRoleArn ARN of the IAM Role with permissions to write to the OpenSearch cluster.
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessRoleArn(@Nullable Output<String> serviceAccessRoleArn) {
            $.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        /**
         * @param serviceAccessRoleArn ARN of the IAM Role with permissions to write to the OpenSearch cluster.
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            return serviceAccessRoleArn(Output.of(serviceAccessRoleArn));
        }

        /**
         * @param timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
         * 
         * @return builder
         * 
         */
        public Builder timestampColumnName(@Nullable Output<String> timestampColumnName) {
            $.timestampColumnName = timestampColumnName;
            return this;
        }

        /**
         * @param timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
         * 
         * @return builder
         * 
         */
        public Builder timestampColumnName(String timestampColumnName) {
            return timestampColumnName(Output.of(timestampColumnName));
        }

        /**
         * @param useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
         * 
         * @return builder
         * 
         */
        public Builder useCsvNoSupValue(@Nullable Output<Boolean> useCsvNoSupValue) {
            $.useCsvNoSupValue = useCsvNoSupValue;
            return this;
        }

        /**
         * @param useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log.
         * 
         * @return builder
         * 
         */
        public Builder useCsvNoSupValue(Boolean useCsvNoSupValue) {
            return useCsvNoSupValue(Output.of(useCsvNoSupValue));
        }

        /**
         * @param useTaskStartTimeForFullLoadTimestamp When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder useTaskStartTimeForFullLoadTimestamp(@Nullable Output<Boolean> useTaskStartTimeForFullLoadTimestamp) {
            $.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
            return this;
        }

        /**
         * @param useTaskStartTimeForFullLoadTimestamp When set to true, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to true, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time. When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder useTaskStartTimeForFullLoadTimestamp(Boolean useTaskStartTimeForFullLoadTimestamp) {
            return useTaskStartTimeForFullLoadTimestamp(Output.of(useTaskStartTimeForFullLoadTimestamp));
        }

        public EndpointS3SettingsArgs build() {
            return $;
        }
    }

}
