// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dms.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointRedisSettingsArgs extends com.pulumi.resources.ResourceArgs {

    public static final EndpointRedisSettingsArgs Empty = new EndpointRedisSettingsArgs();

    /**
     * The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
     * 
     */
    @Import(name="authPassword")
    private @Nullable Output<String> authPassword;

    /**
     * @return The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
     * 
     */
    public Optional<Output<String>> authPassword() {
        return Optional.ofNullable(this.authPassword);
    }

    /**
     * The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
     * 
     */
    @Import(name="authType", required=true)
    private Output<String> authType;

    /**
     * @return The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
     * 
     */
    public Output<String> authType() {
        return this.authType;
    }

    /**
     * The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
     * 
     */
    @Import(name="authUserName")
    private @Nullable Output<String> authUserName;

    /**
     * @return The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
     * 
     */
    public Optional<Output<String>> authUserName() {
        return Optional.ofNullable(this.authUserName);
    }

    /**
     * Transmission Control Protocol (TCP) port for the endpoint.
     * 
     */
    @Import(name="port", required=true)
    private Output<Integer> port;

    /**
     * @return Transmission Control Protocol (TCP) port for the endpoint.
     * 
     */
    public Output<Integer> port() {
        return this.port;
    }

    /**
     * Fully qualified domain name of the endpoint.
     * 
     */
    @Import(name="serverName", required=true)
    private Output<String> serverName;

    /**
     * @return Fully qualified domain name of the endpoint.
     * 
     */
    public Output<String> serverName() {
        return this.serverName;
    }

    /**
     * The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
     * 
     */
    @Import(name="sslCaCertificateArn")
    private @Nullable Output<String> sslCaCertificateArn;

    /**
     * @return The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
     * 
     */
    public Optional<Output<String>> sslCaCertificateArn() {
        return Optional.ofNullable(this.sslCaCertificateArn);
    }

    /**
     * The plaintext option doesn&#39;t provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
     * 
     */
    @Import(name="sslSecurityProtocol")
    private @Nullable Output<String> sslSecurityProtocol;

    /**
     * @return The plaintext option doesn&#39;t provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
     * 
     */
    public Optional<Output<String>> sslSecurityProtocol() {
        return Optional.ofNullable(this.sslSecurityProtocol);
    }

    private EndpointRedisSettingsArgs() {}

    private EndpointRedisSettingsArgs(EndpointRedisSettingsArgs $) {
        this.authPassword = $.authPassword;
        this.authType = $.authType;
        this.authUserName = $.authUserName;
        this.port = $.port;
        this.serverName = $.serverName;
        this.sslCaCertificateArn = $.sslCaCertificateArn;
        this.sslSecurityProtocol = $.sslSecurityProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointRedisSettingsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointRedisSettingsArgs $;

        public Builder() {
            $ = new EndpointRedisSettingsArgs();
        }

        public Builder(EndpointRedisSettingsArgs defaults) {
            $ = new EndpointRedisSettingsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param authPassword The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder authPassword(@Nullable Output<String> authPassword) {
            $.authPassword = authPassword;
            return this;
        }

        /**
         * @param authPassword The password provided with the auth-role and auth-token options of the AuthType setting for a Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder authPassword(String authPassword) {
            return authPassword(Output.of(authPassword));
        }

        /**
         * @param authType The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
         * 
         * @return builder
         * 
         */
        public Builder authType(Output<String> authType) {
            $.authType = authType;
            return this;
        }

        /**
         * @param authType The type of authentication to perform when connecting to a Redis target. Options include `none`, `auth-token`, and `auth-role`. The `auth-token` option requires an `auth_password` value to be provided. The `auth-role` option requires `auth_user_name` and `auth_password` values to be provided.
         * 
         * @return builder
         * 
         */
        public Builder authType(String authType) {
            return authType(Output.of(authType));
        }

        /**
         * @param authUserName The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder authUserName(@Nullable Output<String> authUserName) {
            $.authUserName = authUserName;
            return this;
        }

        /**
         * @param authUserName The username provided with the `auth-role` option of the AuthType setting for a Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder authUserName(String authUserName) {
            return authUserName(Output.of(authUserName));
        }

        /**
         * @param port Transmission Control Protocol (TCP) port for the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder port(Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Transmission Control Protocol (TCP) port for the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param serverName Fully qualified domain name of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder serverName(Output<String> serverName) {
            $.serverName = serverName;
            return this;
        }

        /**
         * @param serverName Fully qualified domain name of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder serverName(String serverName) {
            return serverName(Output.of(serverName));
        }

        /**
         * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder sslCaCertificateArn(@Nullable Output<String> sslCaCertificateArn) {
            $.sslCaCertificateArn = sslCaCertificateArn;
            return this;
        }

        /**
         * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
         * 
         * @return builder
         * 
         */
        public Builder sslCaCertificateArn(String sslCaCertificateArn) {
            return sslCaCertificateArn(Output.of(sslCaCertificateArn));
        }

        /**
         * @param sslSecurityProtocol The plaintext option doesn&#39;t provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
         * 
         * @return builder
         * 
         */
        public Builder sslSecurityProtocol(@Nullable Output<String> sslSecurityProtocol) {
            $.sslSecurityProtocol = sslSecurityProtocol;
            return this;
        }

        /**
         * @param sslSecurityProtocol The plaintext option doesn&#39;t provide Transport Layer Security (TLS) encryption for traffic between endpoint and database. Options include `plaintext`, `ssl-encryption`. The default is `ssl-encryption`.
         * 
         * @return builder
         * 
         */
        public Builder sslSecurityProtocol(String sslSecurityProtocol) {
            return sslSecurityProtocol(Output.of(sslSecurityProtocol));
        }

        public EndpointRedisSettingsArgs build() {
            $.authType = Objects.requireNonNull($.authType, "expected parameter 'authType' to be non-null");
            $.port = Objects.requireNonNull($.port, "expected parameter 'port' to be non-null");
            $.serverName = Objects.requireNonNull($.serverName, "expected parameter 'serverName' to be non-null");
            return $;
        }
    }

}
