// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dms;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class S3EndpointArgs extends com.pulumi.resources.ResourceArgs {

    public static final S3EndpointArgs Empty = new S3EndpointArgs();

    /**
     * Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    @Import(name="addColumnName")
    private @Nullable Output<Boolean> addColumnName;

    /**
     * @return Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> addColumnName() {
        return Optional.ofNullable(this.addColumnName);
    }

    /**
     * Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="addTrailingPaddingCharacter")
    private @Nullable Output<Boolean> addTrailingPaddingCharacter;

    /**
     * @return Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<Boolean>> addTrailingPaddingCharacter() {
        return Optional.ofNullable(this.addTrailingPaddingCharacter);
    }

    /**
     * S3 object prefix.
     * 
     */
    @Import(name="bucketFolder")
    private @Nullable Output<String> bucketFolder;

    /**
     * @return S3 object prefix.
     * 
     */
    public Optional<Output<String>> bucketFolder() {
        return Optional.ofNullable(this.bucketFolder);
    }

    /**
     * S3 bucket name.
     * 
     */
    @Import(name="bucketName", required=true)
    private Output<String> bucketName;

    /**
     * @return S3 bucket name.
     * 
     */
    public Output<String> bucketName() {
        return this.bucketName;
    }

    /**
     * Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    @Import(name="cannedAclForObjects")
    private @Nullable Output<String> cannedAclForObjects;

    /**
     * @return Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    public Optional<Output<String>> cannedAclForObjects() {
        return Optional.ofNullable(this.cannedAclForObjects);
    }

    /**
     * Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Import(name="cdcInsertsAndUpdates")
    private @Nullable Output<Boolean> cdcInsertsAndUpdates;

    /**
     * @return Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> cdcInsertsAndUpdates() {
        return Optional.ofNullable(this.cdcInsertsAndUpdates);
    }

    /**
     * Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Import(name="cdcInsertsOnly")
    private @Nullable Output<Boolean> cdcInsertsOnly;

    /**
     * @return Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> cdcInsertsOnly() {
        return Optional.ofNullable(this.cdcInsertsOnly);
    }

    /**
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     * 
     */
    @Import(name="cdcMaxBatchInterval")
    private @Nullable Output<Integer> cdcMaxBatchInterval;

    /**
     * @return Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     * 
     */
    public Optional<Output<Integer>> cdcMaxBatchInterval() {
        return Optional.ofNullable(this.cdcMaxBatchInterval);
    }

    /**
     * Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     * 
     */
    @Import(name="cdcMinFileSize")
    private @Nullable Output<Integer> cdcMinFileSize;

    /**
     * @return Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     * 
     */
    public Optional<Output<Integer>> cdcMinFileSize() {
        return Optional.ofNullable(this.cdcMinFileSize);
    }

    /**
     * Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    @Import(name="cdcPath")
    private @Nullable Output<String> cdcPath;

    /**
     * @return Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    public Optional<Output<String>> cdcPath() {
        return Optional.ofNullable(this.cdcPath);
    }

    /**
     * ARN for the certificate.
     * 
     */
    @Import(name="certificateArn")
    private @Nullable Output<String> certificateArn;

    /**
     * @return ARN for the certificate.
     * 
     */
    public Optional<Output<String>> certificateArn() {
        return Optional.ofNullable(this.certificateArn);
    }

    /**
     * Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="compressionType")
    private @Nullable Output<String> compressionType;

    /**
     * @return Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> compressionType() {
        return Optional.ofNullable(this.compressionType);
    }

    /**
     * Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    @Import(name="csvDelimiter")
    private @Nullable Output<String> csvDelimiter;

    /**
     * @return Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    public Optional<Output<String>> csvDelimiter() {
        return Optional.ofNullable(this.csvDelimiter);
    }

    /**
     * Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="csvNoSupValue")
    private @Nullable Output<String> csvNoSupValue;

    /**
     * @return Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> csvNoSupValue() {
        return Optional.ofNullable(this.csvNoSupValue);
    }

    /**
     * String to as null when writing to the target. (AWS default is `NULL`.)
     * 
     */
    @Import(name="csvNullValue")
    private @Nullable Output<String> csvNullValue;

    /**
     * @return String to as null when writing to the target. (AWS default is `NULL`.)
     * 
     */
    public Optional<Output<String>> csvNullValue() {
        return Optional.ofNullable(this.csvNullValue);
    }

    /**
     * Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     * 
     */
    @Import(name="csvRowDelimiter")
    private @Nullable Output<String> csvRowDelimiter;

    /**
     * @return Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     * 
     */
    public Optional<Output<String>> csvRowDelimiter() {
        return Optional.ofNullable(this.csvRowDelimiter);
    }

    /**
     * Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     * 
     */
    @Import(name="dataFormat")
    private @Nullable Output<String> dataFormat;

    /**
     * @return Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     * 
     */
    public Optional<Output<String>> dataFormat() {
        return Optional.ofNullable(this.dataFormat);
    }

    /**
     * Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    @Import(name="dataPageSize")
    private @Nullable Output<Integer> dataPageSize;

    /**
     * @return Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    public Optional<Output<Integer>> dataPageSize() {
        return Optional.ofNullable(this.dataPageSize);
    }

    /**
     * Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     * 
     */
    @Import(name="datePartitionDelimiter")
    private @Nullable Output<String> datePartitionDelimiter;

    /**
     * @return Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> datePartitionDelimiter() {
        return Optional.ofNullable(this.datePartitionDelimiter);
    }

    /**
     * Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="datePartitionEnabled")
    private @Nullable Output<Boolean> datePartitionEnabled;

    /**
     * @return Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<Boolean>> datePartitionEnabled() {
        return Optional.ofNullable(this.datePartitionEnabled);
    }

    /**
     * Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     * 
     */
    @Import(name="datePartitionSequence")
    private @Nullable Output<String> datePartitionSequence;

    /**
     * @return Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> datePartitionSequence() {
        return Optional.ofNullable(this.datePartitionSequence);
    }

    /**
     * Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="datePartitionTimezone")
    private @Nullable Output<String> datePartitionTimezone;

    /**
     * @return Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> datePartitionTimezone() {
        return Optional.ofNullable(this.datePartitionTimezone);
    }

    /**
     * Undocumented argument for use as directed by AWS Support.
     * 
     */
    @Import(name="detachTargetOnLobLookupFailureParquet")
    private @Nullable Output<Boolean> detachTargetOnLobLookupFailureParquet;

    /**
     * @return Undocumented argument for use as directed by AWS Support.
     * 
     */
    public Optional<Output<Boolean>> detachTargetOnLobLookupFailureParquet() {
        return Optional.ofNullable(this.detachTargetOnLobLookupFailureParquet);
    }

    /**
     * Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    @Import(name="dictPageSizeLimit")
    private @Nullable Output<Integer> dictPageSizeLimit;

    /**
     * @return Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    public Optional<Output<Integer>> dictPageSizeLimit() {
        return Optional.ofNullable(this.dictPageSizeLimit);
    }

    /**
     * Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    @Import(name="enableStatistics")
    private @Nullable Output<Boolean> enableStatistics;

    /**
     * @return Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> enableStatistics() {
        return Optional.ofNullable(this.enableStatistics);
    }

    /**
     * Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     * 
     */
    @Import(name="encodingType")
    private @Nullable Output<String> encodingType;

    /**
     * @return Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     * 
     */
    public Optional<Output<String>> encodingType() {
        return Optional.ofNullable(this.encodingType);
    }

    /**
     * Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     * 
     */
    @Import(name="encryptionMode")
    private @Nullable Output<String> encryptionMode;

    /**
     * @return Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     * 
     */
    public Optional<Output<String>> encryptionMode() {
        return Optional.ofNullable(this.encryptionMode);
    }

    /**
     * Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     * 
     */
    @Import(name="endpointId", required=true)
    private Output<String> endpointId;

    /**
     * @return Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     * 
     */
    public Output<String> endpointId() {
        return this.endpointId;
    }

    /**
     * Type of endpoint. Valid values are `source`, `target`.
     * 
     */
    @Import(name="endpointType", required=true)
    private Output<String> endpointType;

    /**
     * @return Type of endpoint. Valid values are `source`, `target`.
     * 
     */
    public Output<String> endpointType() {
        return this.endpointType;
    }

    /**
     * Bucket owner to prevent sniping. Value is an AWS account ID.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Bucket owner to prevent sniping. Value is an AWS account ID.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    @Import(name="externalTableDefinition")
    private @Nullable Output<String> externalTableDefinition;

    /**
     * @return JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    public Optional<Output<String>> externalTableDefinition() {
        return Optional.ofNullable(this.externalTableDefinition);
    }

    /**
     * When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     * 
     */
    @Import(name="ignoreHeaderRows")
    private @Nullable Output<Integer> ignoreHeaderRows;

    /**
     * @return When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     * 
     */
    public Optional<Output<Integer>> ignoreHeaderRows() {
        return Optional.ofNullable(this.ignoreHeaderRows);
    }

    /**
     * Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    @Import(name="includeOpForFullLoad")
    private @Nullable Output<Boolean> includeOpForFullLoad;

    /**
     * @return Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> includeOpForFullLoad() {
        return Optional.ofNullable(this.includeOpForFullLoad);
    }

    /**
     * ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     * 
     */
    @Import(name="kmsKeyArn")
    private @Nullable Output<String> kmsKeyArn;

    /**
     * @return ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     * 
     */
    public Optional<Output<String>> kmsKeyArn() {
        return Optional.ofNullable(this.kmsKeyArn);
    }

    /**
     * Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     * 
     */
    @Import(name="maxFileSize")
    private @Nullable Output<Integer> maxFileSize;

    /**
     * @return Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     * 
     */
    public Optional<Output<Integer>> maxFileSize() {
        return Optional.ofNullable(this.maxFileSize);
    }

    /**
     * Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="parquetTimestampInMillisecond")
    private @Nullable Output<Boolean> parquetTimestampInMillisecond;

    /**
     * @return Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<Boolean>> parquetTimestampInMillisecond() {
        return Optional.ofNullable(this.parquetTimestampInMillisecond);
    }

    /**
     * Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     * 
     */
    @Import(name="parquetVersion")
    private @Nullable Output<String> parquetVersion;

    /**
     * @return Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<String>> parquetVersion() {
        return Optional.ofNullable(this.parquetVersion);
    }

    /**
     * Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Import(name="preserveTransactions")
    private @Nullable Output<Boolean> preserveTransactions;

    /**
     * @return Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<Boolean>> preserveTransactions() {
        return Optional.ofNullable(this.preserveTransactions);
    }

    /**
     * For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    @Import(name="rfc4180")
    private @Nullable Output<Boolean> rfc4180;

    /**
     * @return For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> rfc4180() {
        return Optional.ofNullable(this.rfc4180);
    }

    /**
     * Number of rows in a row group. (AWS default is `10000`.)
     * 
     */
    @Import(name="rowGroupLength")
    private @Nullable Output<Integer> rowGroupLength;

    /**
     * @return Number of rows in a row group. (AWS default is `10000`.)
     * 
     */
    public Optional<Output<Integer>> rowGroupLength() {
        return Optional.ofNullable(this.rowGroupLength);
    }

    /**
     * When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     * 
     */
    @Import(name="serverSideEncryptionKmsKeyId")
    private @Nullable Output<String> serverSideEncryptionKmsKeyId;

    /**
     * @return When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     * 
     */
    public Optional<Output<String>> serverSideEncryptionKmsKeyId() {
        return Optional.ofNullable(this.serverSideEncryptionKmsKeyId);
    }

    /**
     * ARN of the IAM role with permissions to the S3 Bucket.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="serviceAccessRoleArn", required=true)
    private Output<String> serviceAccessRoleArn;

    /**
     * @return ARN of the IAM role with permissions to the S3 Bucket.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    /**
     * SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     * 
     */
    @Import(name="sslMode")
    private @Nullable Output<String> sslMode;

    /**
     * @return SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     * 
     */
    public Optional<Output<String>> sslMode() {
        return Optional.ofNullable(this.sslMode);
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    @Import(name="timestampColumnName")
    private @Nullable Output<String> timestampColumnName;

    /**
     * @return Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    public Optional<Output<String>> timestampColumnName() {
        return Optional.ofNullable(this.timestampColumnName);
    }

    /**
     * Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     * 
     */
    @Import(name="useCsvNoSupValue")
    private @Nullable Output<Boolean> useCsvNoSupValue;

    /**
     * @return Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     * 
     */
    public Optional<Output<Boolean>> useCsvNoSupValue() {
        return Optional.ofNullable(this.useCsvNoSupValue);
    }

    /**
     * When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    @Import(name="useTaskStartTimeForFullLoadTimestamp")
    private @Nullable Output<Boolean> useTaskStartTimeForFullLoadTimestamp;

    /**
     * @return When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> useTaskStartTimeForFullLoadTimestamp() {
        return Optional.ofNullable(this.useTaskStartTimeForFullLoadTimestamp);
    }

    private S3EndpointArgs() {}

    private S3EndpointArgs(S3EndpointArgs $) {
        this.addColumnName = $.addColumnName;
        this.addTrailingPaddingCharacter = $.addTrailingPaddingCharacter;
        this.bucketFolder = $.bucketFolder;
        this.bucketName = $.bucketName;
        this.cannedAclForObjects = $.cannedAclForObjects;
        this.cdcInsertsAndUpdates = $.cdcInsertsAndUpdates;
        this.cdcInsertsOnly = $.cdcInsertsOnly;
        this.cdcMaxBatchInterval = $.cdcMaxBatchInterval;
        this.cdcMinFileSize = $.cdcMinFileSize;
        this.cdcPath = $.cdcPath;
        this.certificateArn = $.certificateArn;
        this.compressionType = $.compressionType;
        this.csvDelimiter = $.csvDelimiter;
        this.csvNoSupValue = $.csvNoSupValue;
        this.csvNullValue = $.csvNullValue;
        this.csvRowDelimiter = $.csvRowDelimiter;
        this.dataFormat = $.dataFormat;
        this.dataPageSize = $.dataPageSize;
        this.datePartitionDelimiter = $.datePartitionDelimiter;
        this.datePartitionEnabled = $.datePartitionEnabled;
        this.datePartitionSequence = $.datePartitionSequence;
        this.datePartitionTimezone = $.datePartitionTimezone;
        this.detachTargetOnLobLookupFailureParquet = $.detachTargetOnLobLookupFailureParquet;
        this.dictPageSizeLimit = $.dictPageSizeLimit;
        this.enableStatistics = $.enableStatistics;
        this.encodingType = $.encodingType;
        this.encryptionMode = $.encryptionMode;
        this.endpointId = $.endpointId;
        this.endpointType = $.endpointType;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.externalTableDefinition = $.externalTableDefinition;
        this.ignoreHeaderRows = $.ignoreHeaderRows;
        this.includeOpForFullLoad = $.includeOpForFullLoad;
        this.kmsKeyArn = $.kmsKeyArn;
        this.maxFileSize = $.maxFileSize;
        this.parquetTimestampInMillisecond = $.parquetTimestampInMillisecond;
        this.parquetVersion = $.parquetVersion;
        this.preserveTransactions = $.preserveTransactions;
        this.rfc4180 = $.rfc4180;
        this.rowGroupLength = $.rowGroupLength;
        this.serverSideEncryptionKmsKeyId = $.serverSideEncryptionKmsKeyId;
        this.serviceAccessRoleArn = $.serviceAccessRoleArn;
        this.sslMode = $.sslMode;
        this.tags = $.tags;
        this.timestampColumnName = $.timestampColumnName;
        this.useCsvNoSupValue = $.useCsvNoSupValue;
        this.useTaskStartTimeForFullLoadTimestamp = $.useTaskStartTimeForFullLoadTimestamp;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(S3EndpointArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private S3EndpointArgs $;

        public Builder() {
            $ = new S3EndpointArgs();
        }

        public Builder(S3EndpointArgs defaults) {
            $ = new S3EndpointArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param addColumnName Whether to add column name information to the .csv output file. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder addColumnName(@Nullable Output<Boolean> addColumnName) {
            $.addColumnName = addColumnName;
            return this;
        }

        /**
         * @param addColumnName Whether to add column name information to the .csv output file. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder addColumnName(Boolean addColumnName) {
            return addColumnName(Output.of(addColumnName));
        }

        /**
         * @param addTrailingPaddingCharacter Whether to add padding. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder addTrailingPaddingCharacter(@Nullable Output<Boolean> addTrailingPaddingCharacter) {
            $.addTrailingPaddingCharacter = addTrailingPaddingCharacter;
            return this;
        }

        /**
         * @param addTrailingPaddingCharacter Whether to add padding. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder addTrailingPaddingCharacter(Boolean addTrailingPaddingCharacter) {
            return addTrailingPaddingCharacter(Output.of(addTrailingPaddingCharacter));
        }

        /**
         * @param bucketFolder S3 object prefix.
         * 
         * @return builder
         * 
         */
        public Builder bucketFolder(@Nullable Output<String> bucketFolder) {
            $.bucketFolder = bucketFolder;
            return this;
        }

        /**
         * @param bucketFolder S3 object prefix.
         * 
         * @return builder
         * 
         */
        public Builder bucketFolder(String bucketFolder) {
            return bucketFolder(Output.of(bucketFolder));
        }

        /**
         * @param bucketName S3 bucket name.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(Output<String> bucketName) {
            $.bucketName = bucketName;
            return this;
        }

        /**
         * @param bucketName S3 bucket name.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(String bucketName) {
            return bucketName(Output.of(bucketName));
        }

        /**
         * @param cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
         * 
         * @return builder
         * 
         */
        public Builder cannedAclForObjects(@Nullable Output<String> cannedAclForObjects) {
            $.cannedAclForObjects = cannedAclForObjects;
            return this;
        }

        /**
         * @param cannedAclForObjects Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
         * 
         * @return builder
         * 
         */
        public Builder cannedAclForObjects(String cannedAclForObjects) {
            return cannedAclForObjects(Output.of(cannedAclForObjects));
        }

        /**
         * @param cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsAndUpdates(@Nullable Output<Boolean> cdcInsertsAndUpdates) {
            $.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        /**
         * @param cdcInsertsAndUpdates Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            return cdcInsertsAndUpdates(Output.of(cdcInsertsAndUpdates));
        }

        /**
         * @param cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsOnly(@Nullable Output<Boolean> cdcInsertsOnly) {
            $.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        /**
         * @param cdcInsertsOnly Whether to write insert operations to .csv or .parquet output files. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            return cdcInsertsOnly(Output.of(cdcInsertsOnly));
        }

        /**
         * @param cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
         * 
         * @return builder
         * 
         */
        public Builder cdcMaxBatchInterval(@Nullable Output<Integer> cdcMaxBatchInterval) {
            $.cdcMaxBatchInterval = cdcMaxBatchInterval;
            return this;
        }

        /**
         * @param cdcMaxBatchInterval Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
         * 
         * @return builder
         * 
         */
        public Builder cdcMaxBatchInterval(Integer cdcMaxBatchInterval) {
            return cdcMaxBatchInterval(Output.of(cdcMaxBatchInterval));
        }

        /**
         * @param cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
         * 
         * @return builder
         * 
         */
        public Builder cdcMinFileSize(@Nullable Output<Integer> cdcMinFileSize) {
            $.cdcMinFileSize = cdcMinFileSize;
            return this;
        }

        /**
         * @param cdcMinFileSize Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
         * 
         * @return builder
         * 
         */
        public Builder cdcMinFileSize(Integer cdcMinFileSize) {
            return cdcMinFileSize(Output.of(cdcMinFileSize));
        }

        /**
         * @param cdcPath Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
         * 
         * @return builder
         * 
         */
        public Builder cdcPath(@Nullable Output<String> cdcPath) {
            $.cdcPath = cdcPath;
            return this;
        }

        /**
         * @param cdcPath Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
         * 
         * @return builder
         * 
         */
        public Builder cdcPath(String cdcPath) {
            return cdcPath(Output.of(cdcPath));
        }

        /**
         * @param certificateArn ARN for the certificate.
         * 
         * @return builder
         * 
         */
        public Builder certificateArn(@Nullable Output<String> certificateArn) {
            $.certificateArn = certificateArn;
            return this;
        }

        /**
         * @param certificateArn ARN for the certificate.
         * 
         * @return builder
         * 
         */
        public Builder certificateArn(String certificateArn) {
            return certificateArn(Output.of(certificateArn));
        }

        /**
         * @param compressionType Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder compressionType(@Nullable Output<String> compressionType) {
            $.compressionType = compressionType;
            return this;
        }

        /**
         * @param compressionType Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder compressionType(String compressionType) {
            return compressionType(Output.of(compressionType));
        }

        /**
         * @param csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
         * 
         * @return builder
         * 
         */
        public Builder csvDelimiter(@Nullable Output<String> csvDelimiter) {
            $.csvDelimiter = csvDelimiter;
            return this;
        }

        /**
         * @param csvDelimiter Delimiter used to separate columns in the source files. Default is `,`.
         * 
         * @return builder
         * 
         */
        public Builder csvDelimiter(String csvDelimiter) {
            return csvDelimiter(Output.of(csvDelimiter));
        }

        /**
         * @param csvNoSupValue Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder csvNoSupValue(@Nullable Output<String> csvNoSupValue) {
            $.csvNoSupValue = csvNoSupValue;
            return this;
        }

        /**
         * @param csvNoSupValue Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder csvNoSupValue(String csvNoSupValue) {
            return csvNoSupValue(Output.of(csvNoSupValue));
        }

        /**
         * @param csvNullValue String to as null when writing to the target. (AWS default is `NULL`.)
         * 
         * @return builder
         * 
         */
        public Builder csvNullValue(@Nullable Output<String> csvNullValue) {
            $.csvNullValue = csvNullValue;
            return this;
        }

        /**
         * @param csvNullValue String to as null when writing to the target. (AWS default is `NULL`.)
         * 
         * @return builder
         * 
         */
        public Builder csvNullValue(String csvNullValue) {
            return csvNullValue(Output.of(csvNullValue));
        }

        /**
         * @param csvRowDelimiter Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
         * 
         * @return builder
         * 
         */
        public Builder csvRowDelimiter(@Nullable Output<String> csvRowDelimiter) {
            $.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        /**
         * @param csvRowDelimiter Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
         * 
         * @return builder
         * 
         */
        public Builder csvRowDelimiter(String csvRowDelimiter) {
            return csvRowDelimiter(Output.of(csvRowDelimiter));
        }

        /**
         * @param dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder dataFormat(@Nullable Output<String> dataFormat) {
            $.dataFormat = dataFormat;
            return this;
        }

        /**
         * @param dataFormat Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder dataFormat(String dataFormat) {
            return dataFormat(Output.of(dataFormat));
        }

        /**
         * @param dataPageSize Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder dataPageSize(@Nullable Output<Integer> dataPageSize) {
            $.dataPageSize = dataPageSize;
            return this;
        }

        /**
         * @param dataPageSize Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder dataPageSize(Integer dataPageSize) {
            return dataPageSize(Output.of(dataPageSize));
        }

        /**
         * @param datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionDelimiter(@Nullable Output<String> datePartitionDelimiter) {
            $.datePartitionDelimiter = datePartitionDelimiter;
            return this;
        }

        /**
         * @param datePartitionDelimiter Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionDelimiter(String datePartitionDelimiter) {
            return datePartitionDelimiter(Output.of(datePartitionDelimiter));
        }

        /**
         * @param datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionEnabled(@Nullable Output<Boolean> datePartitionEnabled) {
            $.datePartitionEnabled = datePartitionEnabled;
            return this;
        }

        /**
         * @param datePartitionEnabled Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionEnabled(Boolean datePartitionEnabled) {
            return datePartitionEnabled(Output.of(datePartitionEnabled));
        }

        /**
         * @param datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionSequence(@Nullable Output<String> datePartitionSequence) {
            $.datePartitionSequence = datePartitionSequence;
            return this;
        }

        /**
         * @param datePartitionSequence Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionSequence(String datePartitionSequence) {
            return datePartitionSequence(Output.of(datePartitionSequence));
        }

        /**
         * @param datePartitionTimezone Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionTimezone(@Nullable Output<String> datePartitionTimezone) {
            $.datePartitionTimezone = datePartitionTimezone;
            return this;
        }

        /**
         * @param datePartitionTimezone Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder datePartitionTimezone(String datePartitionTimezone) {
            return datePartitionTimezone(Output.of(datePartitionTimezone));
        }

        /**
         * @param detachTargetOnLobLookupFailureParquet Undocumented argument for use as directed by AWS Support.
         * 
         * @return builder
         * 
         */
        public Builder detachTargetOnLobLookupFailureParquet(@Nullable Output<Boolean> detachTargetOnLobLookupFailureParquet) {
            $.detachTargetOnLobLookupFailureParquet = detachTargetOnLobLookupFailureParquet;
            return this;
        }

        /**
         * @param detachTargetOnLobLookupFailureParquet Undocumented argument for use as directed by AWS Support.
         * 
         * @return builder
         * 
         */
        public Builder detachTargetOnLobLookupFailureParquet(Boolean detachTargetOnLobLookupFailureParquet) {
            return detachTargetOnLobLookupFailureParquet(Output.of(detachTargetOnLobLookupFailureParquet));
        }

        /**
         * @param dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder dictPageSizeLimit(@Nullable Output<Integer> dictPageSizeLimit) {
            $.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        /**
         * @param dictPageSizeLimit Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            return dictPageSizeLimit(Output.of(dictPageSizeLimit));
        }

        /**
         * @param enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder enableStatistics(@Nullable Output<Boolean> enableStatistics) {
            $.enableStatistics = enableStatistics;
            return this;
        }

        /**
         * @param enableStatistics Whether to enable statistics for Parquet pages and row groups. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder enableStatistics(Boolean enableStatistics) {
            return enableStatistics(Output.of(enableStatistics));
        }

        /**
         * @param encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
         * 
         * @return builder
         * 
         */
        public Builder encodingType(@Nullable Output<String> encodingType) {
            $.encodingType = encodingType;
            return this;
        }

        /**
         * @param encodingType Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
         * 
         * @return builder
         * 
         */
        public Builder encodingType(String encodingType) {
            return encodingType(Output.of(encodingType));
        }

        /**
         * @param encryptionMode Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(@Nullable Output<String> encryptionMode) {
            $.encryptionMode = encryptionMode;
            return this;
        }

        /**
         * @param encryptionMode Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(String encryptionMode) {
            return encryptionMode(Output.of(encryptionMode));
        }

        /**
         * @param endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder endpointId(Output<String> endpointId) {
            $.endpointId = endpointId;
            return this;
        }

        /**
         * @param endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder endpointId(String endpointId) {
            return endpointId(Output.of(endpointId));
        }

        /**
         * @param endpointType Type of endpoint. Valid values are `source`, `target`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(Output<String> endpointType) {
            $.endpointType = endpointType;
            return this;
        }

        /**
         * @param endpointType Type of endpoint. Valid values are `source`, `target`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(String endpointType) {
            return endpointType(Output.of(endpointType));
        }

        /**
         * @param expectedBucketOwner Bucket owner to prevent sniping. Value is an AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Bucket owner to prevent sniping. Value is an AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
         * 
         * @return builder
         * 
         */
        public Builder externalTableDefinition(@Nullable Output<String> externalTableDefinition) {
            $.externalTableDefinition = externalTableDefinition;
            return this;
        }

        /**
         * @param externalTableDefinition JSON document that describes how AWS DMS should interpret the data.
         * 
         * @return builder
         * 
         */
        public Builder externalTableDefinition(String externalTableDefinition) {
            return externalTableDefinition(Output.of(externalTableDefinition));
        }

        /**
         * @param ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
         * 
         * @return builder
         * 
         */
        public Builder ignoreHeaderRows(@Nullable Output<Integer> ignoreHeaderRows) {
            $.ignoreHeaderRows = ignoreHeaderRows;
            return this;
        }

        /**
         * @param ignoreHeaderRows When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
         * 
         * @return builder
         * 
         */
        public Builder ignoreHeaderRows(Integer ignoreHeaderRows) {
            return ignoreHeaderRows(Output.of(ignoreHeaderRows));
        }

        /**
         * @param includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder includeOpForFullLoad(@Nullable Output<Boolean> includeOpForFullLoad) {
            $.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        /**
         * @param includeOpForFullLoad Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            return includeOpForFullLoad(Output.of(includeOpForFullLoad));
        }

        /**
         * @param kmsKeyArn ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(@Nullable Output<String> kmsKeyArn) {
            $.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * @param kmsKeyArn ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(String kmsKeyArn) {
            return kmsKeyArn(Output.of(kmsKeyArn));
        }

        /**
         * @param maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder maxFileSize(@Nullable Output<Integer> maxFileSize) {
            $.maxFileSize = maxFileSize;
            return this;
        }

        /**
         * @param maxFileSize Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
         * 
         * @return builder
         * 
         */
        public Builder maxFileSize(Integer maxFileSize) {
            return maxFileSize(Output.of(maxFileSize));
        }

        /**
         * @param parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder parquetTimestampInMillisecond(@Nullable Output<Boolean> parquetTimestampInMillisecond) {
            $.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
            return this;
        }

        /**
         * @param parquetTimestampInMillisecond Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            return parquetTimestampInMillisecond(Output.of(parquetTimestampInMillisecond));
        }

        /**
         * @param parquetVersion Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder parquetVersion(@Nullable Output<String> parquetVersion) {
            $.parquetVersion = parquetVersion;
            return this;
        }

        /**
         * @param parquetVersion Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder parquetVersion(String parquetVersion) {
            return parquetVersion(Output.of(parquetVersion));
        }

        /**
         * @param preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder preserveTransactions(@Nullable Output<Boolean> preserveTransactions) {
            $.preserveTransactions = preserveTransactions;
            return this;
        }

        /**
         * @param preserveTransactions Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder preserveTransactions(Boolean preserveTransactions) {
            return preserveTransactions(Output.of(preserveTransactions));
        }

        /**
         * @param rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder rfc4180(@Nullable Output<Boolean> rfc4180) {
            $.rfc4180 = rfc4180;
            return this;
        }

        /**
         * @param rfc4180 For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder rfc4180(Boolean rfc4180) {
            return rfc4180(Output.of(rfc4180));
        }

        /**
         * @param rowGroupLength Number of rows in a row group. (AWS default is `10000`.)
         * 
         * @return builder
         * 
         */
        public Builder rowGroupLength(@Nullable Output<Integer> rowGroupLength) {
            $.rowGroupLength = rowGroupLength;
            return this;
        }

        /**
         * @param rowGroupLength Number of rows in a row group. (AWS default is `10000`.)
         * 
         * @return builder
         * 
         */
        public Builder rowGroupLength(Integer rowGroupLength) {
            return rowGroupLength(Output.of(rowGroupLength));
        }

        /**
         * @param serverSideEncryptionKmsKeyId When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionKmsKeyId(@Nullable Output<String> serverSideEncryptionKmsKeyId) {
            $.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        /**
         * @param serverSideEncryptionKmsKeyId When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
         * 
         * @return builder
         * 
         */
        public Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            return serverSideEncryptionKmsKeyId(Output.of(serverSideEncryptionKmsKeyId));
        }

        /**
         * @param serviceAccessRoleArn ARN of the IAM role with permissions to the S3 Bucket.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessRoleArn(Output<String> serviceAccessRoleArn) {
            $.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        /**
         * @param serviceAccessRoleArn ARN of the IAM role with permissions to the S3 Bucket.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            return serviceAccessRoleArn(Output.of(serviceAccessRoleArn));
        }

        /**
         * @param sslMode SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
         * 
         * @return builder
         * 
         */
        public Builder sslMode(@Nullable Output<String> sslMode) {
            $.sslMode = sslMode;
            return this;
        }

        /**
         * @param sslMode SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
         * 
         * @return builder
         * 
         */
        public Builder sslMode(String sslMode) {
            return sslMode(Output.of(sslMode));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
         * 
         * @return builder
         * 
         */
        public Builder timestampColumnName(@Nullable Output<String> timestampColumnName) {
            $.timestampColumnName = timestampColumnName;
            return this;
        }

        /**
         * @param timestampColumnName Column to add with timestamp information to the endpoint data for an Amazon S3 target.
         * 
         * @return builder
         * 
         */
        public Builder timestampColumnName(String timestampColumnName) {
            return timestampColumnName(Output.of(timestampColumnName));
        }

        /**
         * @param useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder useCsvNoSupValue(@Nullable Output<Boolean> useCsvNoSupValue) {
            $.useCsvNoSupValue = useCsvNoSupValue;
            return this;
        }

        /**
         * @param useCsvNoSupValue Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
         * 
         * @return builder
         * 
         */
        public Builder useCsvNoSupValue(Boolean useCsvNoSupValue) {
            return useCsvNoSupValue(Output.of(useCsvNoSupValue));
        }

        /**
         * @param useTaskStartTimeForFullLoadTimestamp When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder useTaskStartTimeForFullLoadTimestamp(@Nullable Output<Boolean> useTaskStartTimeForFullLoadTimestamp) {
            $.useTaskStartTimeForFullLoadTimestamp = useTaskStartTimeForFullLoadTimestamp;
            return this;
        }

        /**
         * @param useTaskStartTimeForFullLoadTimestamp When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder useTaskStartTimeForFullLoadTimestamp(Boolean useTaskStartTimeForFullLoadTimestamp) {
            return useTaskStartTimeForFullLoadTimestamp(Output.of(useTaskStartTimeForFullLoadTimestamp));
        }

        public S3EndpointArgs build() {
            $.bucketName = Objects.requireNonNull($.bucketName, "expected parameter 'bucketName' to be non-null");
            $.endpointId = Objects.requireNonNull($.endpointId, "expected parameter 'endpointId' to be non-null");
            $.endpointType = Objects.requireNonNull($.endpointType, "expected parameter 'endpointType' to be non-null");
            $.serviceAccessRoleArn = Objects.requireNonNull($.serviceAccessRoleArn, "expected parameter 'serviceAccessRoleArn' to be non-null");
            return $;
        }
    }

}
