// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.dms;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.dms.S3EndpointArgs;
import com.pulumi.aws.dms.inputs.S3EndpointState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a DMS (Data Migration Service) S3 endpoint resource. DMS S3 endpoints can be created, updated, deleted, and imported.
 * 
 * &gt; **Note:** AWS is deprecating `extra_connection_attributes`, such as used with `aws.dms.Endpoint`. This resource is an alternative to `aws.dms.Endpoint` and does not use `extra_connection_attributes`. (AWS currently includes `extra_connection_attributes` in the raw responses to the AWS Provider requests and so they may be visible in the logs.)
 * 
 * &gt; **Note:** Some of this resource&#39;s arguments have default values that come from the AWS Provider. Other default values are provided by AWS and subject to change without notice. When relying on AWS defaults, the provider state will often have a zero value. For example, the AWS Provider does not provide a default for `cdc_max_batch_interval` but the AWS default is `60` (seconds). However, the provider state will show `0` since this is the value return by AWS when no value is present. Below, we aim to flag the defaults that come from AWS (_e.g._, &#34;AWS default...&#34;).
 * 
 * ## Example Usage
 * ### Minimal Configuration
 * 
 * This is the minimal configuration for an `aws.dms.S3Endpoint`. This endpoint will rely on the AWS Provider and AWS defaults.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint(&#34;example&#34;, S3EndpointArgs.builder()        
 *             .endpointId(&#34;donnedtipi&#34;)
 *             .endpointType(&#34;target&#34;)
 *             .bucketName(&#34;beckut_name&#34;)
 *             .serviceAccessRoleArn(aws_iam_role.example().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.example())
 *                 .build());
 * 
 *     }
 * }
 * ```
 * ### Complete Configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint(&#34;example&#34;, S3EndpointArgs.builder()        
 *             .endpointId(&#34;donnedtipi&#34;)
 *             .endpointType(&#34;target&#34;)
 *             .sslMode(&#34;none&#34;)
 *             .tags(Map.ofEntries(
 *                 Map.entry(&#34;Name&#34;, &#34;donnedtipi&#34;),
 *                 Map.entry(&#34;Update&#34;, &#34;to-update&#34;),
 *                 Map.entry(&#34;Remove&#34;, &#34;to-remove&#34;)
 *             ))
 *             .addColumnName(true)
 *             .addTrailingPaddingCharacter(false)
 *             .bucketFolder(&#34;folder&#34;)
 *             .bucketName(&#34;bucket_name&#34;)
 *             .cannedAclForObjects(&#34;private&#34;)
 *             .cdcInsertsAndUpdates(true)
 *             .cdcInsertsOnly(false)
 *             .cdcMaxBatchInterval(100)
 *             .cdcMinFileSize(16)
 *             .cdcPath(&#34;cdc/path&#34;)
 *             .compressionType(&#34;GZIP&#34;)
 *             .csvDelimiter(&#34;;&#34;)
 *             .csvNoSupValue(&#34;x&#34;)
 *             .csvNullValue(&#34;?&#34;)
 *             .csvRowDelimiter(&#34;\\r\\n&#34;)
 *             .dataFormat(&#34;parquet&#34;)
 *             .dataPageSize(1100000)
 *             .datePartitionDelimiter(&#34;UNDERSCORE&#34;)
 *             .datePartitionEnabled(true)
 *             .datePartitionSequence(&#34;yyyymmddhh&#34;)
 *             .datePartitionTimezone(&#34;Asia/Seoul&#34;)
 *             .dictPageSizeLimit(1000000)
 *             .enableStatistics(false)
 *             .encodingType(&#34;plain&#34;)
 *             .encryptionMode(&#34;SSE_S3&#34;)
 *             .expectedBucketOwner(data.aws_caller_identity().current().account_id())
 *             .externalTableDefinition(&#34;etd&#34;)
 *             .ignoreHeaderRows(1)
 *             .includeOpForFullLoad(true)
 *             .maxFileSize(1000000)
 *             .parquetTimestampInMillisecond(true)
 *             .parquetVersion(&#34;parquet-2-0&#34;)
 *             .preserveTransactions(false)
 *             .rfc4180(false)
 *             .rowGroupLength(11000)
 *             .serverSideEncryptionKmsKeyId(aws_kms_key.example().arn())
 *             .serviceAccessRoleArn(aws_iam_role.example().arn())
 *             .timestampColumnName(&#34;tx_commit_time&#34;)
 *             .useCsvNoSupValue(false)
 *             .useTaskStartTimeForFullLoadTimestamp(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.example())
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import endpoints using the `endpoint_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:dms/s3Endpoint:S3Endpoint example example-dms-endpoint-tf
 * ```
 * 
 */
@ResourceType(type="aws:dms/s3Endpoint:S3Endpoint")
public class S3Endpoint extends com.pulumi.resources.CustomResource {
    /**
     * Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    @Export(name="addColumnName", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> addColumnName;

    /**
     * @return Whether to add column name information to the .csv output file. Default is `false`.
     * 
     */
    public Output<Optional<Boolean>> addColumnName() {
        return Codegen.optional(this.addColumnName);
    }
    /**
     * Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="addTrailingPaddingCharacter", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> addTrailingPaddingCharacter;

    /**
     * @return Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<Boolean>> addTrailingPaddingCharacter() {
        return Codegen.optional(this.addTrailingPaddingCharacter);
    }
    /**
     * S3 object prefix.
     * 
     */
    @Export(name="bucketFolder", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> bucketFolder;

    /**
     * @return S3 object prefix.
     * 
     */
    public Output<Optional<String>> bucketFolder() {
        return Codegen.optional(this.bucketFolder);
    }
    /**
     * S3 bucket name.
     * 
     */
    @Export(name="bucketName", refs={String.class}, tree="[0]")
    private Output<String> bucketName;

    /**
     * @return S3 bucket name.
     * 
     */
    public Output<String> bucketName() {
        return this.bucketName;
    }
    /**
     * Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    @Export(name="cannedAclForObjects", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cannedAclForObjects;

    /**
     * @return Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     * 
     */
    public Output<Optional<String>> cannedAclForObjects() {
        return Codegen.optional(this.cannedAclForObjects);
    }
    /**
     * Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Export(name="cdcInsertsAndUpdates", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> cdcInsertsAndUpdates;

    /**
     * @return Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Output<Optional<Boolean>> cdcInsertsAndUpdates() {
        return Codegen.optional(this.cdcInsertsAndUpdates);
    }
    /**
     * Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    @Export(name="cdcInsertsOnly", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> cdcInsertsOnly;

    /**
     * @return Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     * 
     */
    public Output<Optional<Boolean>> cdcInsertsOnly() {
        return Codegen.optional(this.cdcInsertsOnly);
    }
    /**
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     * 
     */
    @Export(name="cdcMaxBatchInterval", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> cdcMaxBatchInterval;

    /**
     * @return Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     * 
     */
    public Output<Optional<Integer>> cdcMaxBatchInterval() {
        return Codegen.optional(this.cdcMaxBatchInterval);
    }
    /**
     * Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     * 
     */
    @Export(name="cdcMinFileSize", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> cdcMinFileSize;

    /**
     * @return Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     * 
     */
    public Output<Optional<Integer>> cdcMinFileSize() {
        return Codegen.optional(this.cdcMinFileSize);
    }
    /**
     * Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    @Export(name="cdcPath", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cdcPath;

    /**
     * @return Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     * 
     */
    public Output<Optional<String>> cdcPath() {
        return Codegen.optional(this.cdcPath);
    }
    /**
     * ARN for the certificate.
     * 
     */
    @Export(name="certificateArn", refs={String.class}, tree="[0]")
    private Output<String> certificateArn;

    /**
     * @return ARN for the certificate.
     * 
     */
    public Output<String> certificateArn() {
        return this.certificateArn;
    }
    /**
     * Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="compressionType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> compressionType;

    /**
     * @return Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> compressionType() {
        return Codegen.optional(this.compressionType);
    }
    /**
     * Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    @Export(name="csvDelimiter", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> csvDelimiter;

    /**
     * @return Delimiter used to separate columns in the source files. Default is `,`.
     * 
     */
    public Output<Optional<String>> csvDelimiter() {
        return Codegen.optional(this.csvDelimiter);
    }
    /**
     * Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="csvNoSupValue", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> csvNoSupValue;

    /**
     * @return Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> csvNoSupValue() {
        return Codegen.optional(this.csvNoSupValue);
    }
    /**
     * String to as null when writing to the target. (AWS default is `NULL`.)
     * 
     */
    @Export(name="csvNullValue", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> csvNullValue;

    /**
     * @return String to as null when writing to the target. (AWS default is `NULL`.)
     * 
     */
    public Output<Optional<String>> csvNullValue() {
        return Codegen.optional(this.csvNullValue);
    }
    /**
     * Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     * 
     */
    @Export(name="csvRowDelimiter", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> csvRowDelimiter;

    /**
     * @return Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     * 
     */
    public Output<Optional<String>> csvRowDelimiter() {
        return Codegen.optional(this.csvRowDelimiter);
    }
    /**
     * Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     * 
     */
    @Export(name="dataFormat", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> dataFormat;

    /**
     * @return Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     * 
     */
    public Output<Optional<String>> dataFormat() {
        return Codegen.optional(this.dataFormat);
    }
    /**
     * Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    @Export(name="dataPageSize", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> dataPageSize;

    /**
     * @return Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    public Output<Optional<Integer>> dataPageSize() {
        return Codegen.optional(this.dataPageSize);
    }
    /**
     * Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     * 
     */
    @Export(name="datePartitionDelimiter", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> datePartitionDelimiter;

    /**
     * @return Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> datePartitionDelimiter() {
        return Codegen.optional(this.datePartitionDelimiter);
    }
    /**
     * Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="datePartitionEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> datePartitionEnabled;

    /**
     * @return Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<Boolean>> datePartitionEnabled() {
        return Codegen.optional(this.datePartitionEnabled);
    }
    /**
     * Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     * 
     */
    @Export(name="datePartitionSequence", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> datePartitionSequence;

    /**
     * @return Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> datePartitionSequence() {
        return Codegen.optional(this.datePartitionSequence);
    }
    /**
     * Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="datePartitionTimezone", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> datePartitionTimezone;

    /**
     * @return Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> datePartitionTimezone() {
        return Codegen.optional(this.datePartitionTimezone);
    }
    /**
     * Undocumented argument for use as directed by AWS Support.
     * 
     */
    @Export(name="detachTargetOnLobLookupFailureParquet", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> detachTargetOnLobLookupFailureParquet;

    /**
     * @return Undocumented argument for use as directed by AWS Support.
     * 
     */
    public Output<Optional<Boolean>> detachTargetOnLobLookupFailureParquet() {
        return Codegen.optional(this.detachTargetOnLobLookupFailureParquet);
    }
    /**
     * Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    @Export(name="dictPageSizeLimit", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> dictPageSizeLimit;

    /**
     * @return Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     * 
     */
    public Output<Optional<Integer>> dictPageSizeLimit() {
        return Codegen.optional(this.dictPageSizeLimit);
    }
    /**
     * Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    @Export(name="enableStatistics", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableStatistics;

    /**
     * @return Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     * 
     */
    public Output<Optional<Boolean>> enableStatistics() {
        return Codegen.optional(this.enableStatistics);
    }
    /**
     * Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     * 
     */
    @Export(name="encodingType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> encodingType;

    /**
     * @return Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     * 
     */
    public Output<Optional<String>> encodingType() {
        return Codegen.optional(this.encodingType);
    }
    /**
     * Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     * 
     */
    @Export(name="encryptionMode", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> encryptionMode;

    /**
     * @return Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     * 
     */
    public Output<Optional<String>> encryptionMode() {
        return Codegen.optional(this.encryptionMode);
    }
    /**
     * ARN for the endpoint.
     * 
     */
    @Export(name="endpointArn", refs={String.class}, tree="[0]")
    private Output<String> endpointArn;

    /**
     * @return ARN for the endpoint.
     * 
     */
    public Output<String> endpointArn() {
        return this.endpointArn;
    }
    /**
     * Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     * 
     */
    @Export(name="endpointId", refs={String.class}, tree="[0]")
    private Output<String> endpointId;

    /**
     * @return Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     * 
     */
    public Output<String> endpointId() {
        return this.endpointId;
    }
    /**
     * Type of endpoint. Valid values are `source`, `target`.
     * 
     */
    @Export(name="endpointType", refs={String.class}, tree="[0]")
    private Output<String> endpointType;

    /**
     * @return Type of endpoint. Valid values are `source`, `target`.
     * 
     */
    public Output<String> endpointType() {
        return this.endpointType;
    }
    /**
     * Expanded name for the engine name.
     * 
     */
    @Export(name="engineDisplayName", refs={String.class}, tree="[0]")
    private Output<String> engineDisplayName;

    /**
     * @return Expanded name for the engine name.
     * 
     */
    public Output<String> engineDisplayName() {
        return this.engineDisplayName;
    }
    /**
     * Bucket owner to prevent sniping. Value is an AWS account ID.
     * 
     */
    @Export(name="expectedBucketOwner", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> expectedBucketOwner;

    /**
     * @return Bucket owner to prevent sniping. Value is an AWS account ID.
     * 
     */
    public Output<Optional<String>> expectedBucketOwner() {
        return Codegen.optional(this.expectedBucketOwner);
    }
    /**
     * Can be used for cross-account validation. Use it in another account with `aws.dms.S3Endpoint` to create the endpoint cross-account.
     * 
     */
    @Export(name="externalId", refs={String.class}, tree="[0]")
    private Output<String> externalId;

    /**
     * @return Can be used for cross-account validation. Use it in another account with `aws.dms.S3Endpoint` to create the endpoint cross-account.
     * 
     */
    public Output<String> externalId() {
        return this.externalId;
    }
    /**
     * JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    @Export(name="externalTableDefinition", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> externalTableDefinition;

    /**
     * @return JSON document that describes how AWS DMS should interpret the data.
     * 
     */
    public Output<Optional<String>> externalTableDefinition() {
        return Codegen.optional(this.externalTableDefinition);
    }
    /**
     * When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     * 
     */
    @Export(name="ignoreHeaderRows", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> ignoreHeaderRows;

    /**
     * @return When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     * 
     */
    public Output<Optional<Integer>> ignoreHeaderRows() {
        return Codegen.optional(this.ignoreHeaderRows);
    }
    /**
     * Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    @Export(name="includeOpForFullLoad", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> includeOpForFullLoad;

    /**
     * @return Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     * 
     */
    public Output<Optional<Boolean>> includeOpForFullLoad() {
        return Codegen.optional(this.includeOpForFullLoad);
    }
    /**
     * ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     * 
     */
    @Export(name="kmsKeyArn", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyArn;

    /**
     * @return ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     * 
     */
    public Output<String> kmsKeyArn() {
        return this.kmsKeyArn;
    }
    /**
     * Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     * 
     */
    @Export(name="maxFileSize", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maxFileSize;

    /**
     * @return Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     * 
     */
    public Output<Optional<Integer>> maxFileSize() {
        return Codegen.optional(this.maxFileSize);
    }
    /**
     * Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="parquetTimestampInMillisecond", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> parquetTimestampInMillisecond;

    /**
     * @return Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<Boolean>> parquetTimestampInMillisecond() {
        return Codegen.optional(this.parquetTimestampInMillisecond);
    }
    /**
     * Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     * 
     */
    @Export(name="parquetVersion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> parquetVersion;

    /**
     * @return Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<String>> parquetVersion() {
        return Codegen.optional(this.parquetVersion);
    }
    /**
     * Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    @Export(name="preserveTransactions", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> preserveTransactions;

    /**
     * @return Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<Boolean>> preserveTransactions() {
        return Codegen.optional(this.preserveTransactions);
    }
    /**
     * For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    @Export(name="rfc4180", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> rfc4180;

    /**
     * @return For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     * 
     */
    public Output<Optional<Boolean>> rfc4180() {
        return Codegen.optional(this.rfc4180);
    }
    /**
     * Number of rows in a row group. (AWS default is `10000`.)
     * 
     */
    @Export(name="rowGroupLength", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> rowGroupLength;

    /**
     * @return Number of rows in a row group. (AWS default is `10000`.)
     * 
     */
    public Output<Optional<Integer>> rowGroupLength() {
        return Codegen.optional(this.rowGroupLength);
    }
    /**
     * When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     * 
     */
    @Export(name="serverSideEncryptionKmsKeyId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> serverSideEncryptionKmsKeyId;

    /**
     * @return When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     * 
     */
    public Output<Optional<String>> serverSideEncryptionKmsKeyId() {
        return Codegen.optional(this.serverSideEncryptionKmsKeyId);
    }
    /**
     * ARN of the IAM role with permissions to the S3 Bucket.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="serviceAccessRoleArn", refs={String.class}, tree="[0]")
    private Output<String> serviceAccessRoleArn;

    /**
     * @return ARN of the IAM role with permissions to the S3 Bucket.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }
    /**
     * SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     * 
     */
    @Export(name="sslMode", refs={String.class}, tree="[0]")
    private Output<String> sslMode;

    /**
     * @return SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     * 
     */
    public Output<String> sslMode() {
        return this.sslMode;
    }
    /**
     * Status of the endpoint.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the endpoint.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    @Export(name="timestampColumnName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> timestampColumnName;

    /**
     * @return Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     * 
     */
    public Output<Optional<String>> timestampColumnName() {
        return Codegen.optional(this.timestampColumnName);
    }
    /**
     * Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     * 
     */
    @Export(name="useCsvNoSupValue", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> useCsvNoSupValue;

    /**
     * @return Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     * 
     */
    public Output<Optional<Boolean>> useCsvNoSupValue() {
        return Codegen.optional(this.useCsvNoSupValue);
    }
    /**
     * When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    @Export(name="useTaskStartTimeForFullLoadTimestamp", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> useTaskStartTimeForFullLoadTimestamp;

    /**
     * @return When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     * 
     */
    public Output<Optional<Boolean>> useTaskStartTimeForFullLoadTimestamp() {
        return Codegen.optional(this.useTaskStartTimeForFullLoadTimestamp);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public S3Endpoint(String name) {
        this(name, S3EndpointArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public S3Endpoint(String name, S3EndpointArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public S3Endpoint(String name, S3EndpointArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:dms/s3Endpoint:S3Endpoint", name, args == null ? S3EndpointArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private S3Endpoint(String name, Output<String> id, @Nullable S3EndpointState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:dms/s3Endpoint:S3Endpoint", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static S3Endpoint get(String name, Output<String> id, @Nullable S3EndpointState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new S3Endpoint(name, id, state, options);
    }
}
