// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directoryservice.inputs;

import com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs;
import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DirectoryState extends com.pulumi.resources.ResourceArgs {

    public static final DirectoryState Empty = new DirectoryState();

    /**
     * The access URL for the directory, such as `http://alias.awsapps.com`.
     * 
     */
    @Import(name="accessUrl")
    private @Nullable Output<String> accessUrl;

    /**
     * @return The access URL for the directory, such as `http://alias.awsapps.com`.
     * 
     */
    public Optional<Output<String>> accessUrl() {
        return Optional.ofNullable(this.accessUrl);
    }

    /**
     * The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     * 
     */
    @Import(name="alias")
    private @Nullable Output<String> alias;

    /**
     * @return The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     * 
     */
    public Optional<Output<String>> alias() {
        return Optional.ofNullable(this.alias);
    }

    /**
     * Connector related information about the directory. Fields documented below.
     * 
     */
    @Import(name="connectSettings")
    private @Nullable Output<DirectoryConnectSettingsArgs> connectSettings;

    /**
     * @return Connector related information about the directory. Fields documented below.
     * 
     */
    public Optional<Output<DirectoryConnectSettingsArgs>> connectSettings() {
        return Optional.ofNullable(this.connectSettings);
    }

    /**
     * A textual description for the directory.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A textual description for the directory.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     * 
     */
    @Import(name="desiredNumberOfDomainControllers")
    private @Nullable Output<Integer> desiredNumberOfDomainControllers;

    /**
     * @return The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     * 
     */
    public Optional<Output<Integer>> desiredNumberOfDomainControllers() {
        return Optional.ofNullable(this.desiredNumberOfDomainControllers);
    }

    /**
     * A list of IP addresses of the DNS servers for the directory or connector.
     * 
     */
    @Import(name="dnsIpAddresses")
    private @Nullable Output<List<String>> dnsIpAddresses;

    /**
     * @return A list of IP addresses of the DNS servers for the directory or connector.
     * 
     */
    public Optional<Output<List<String>>> dnsIpAddresses() {
        return Optional.ofNullable(this.dnsIpAddresses);
    }

    /**
     * The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     * 
     */
    @Import(name="edition")
    private @Nullable Output<String> edition;

    /**
     * @return The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     * 
     */
    public Optional<Output<String>> edition() {
        return Optional.ofNullable(this.edition);
    }

    /**
     * Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     * 
     */
    @Import(name="enableSso")
    private @Nullable Output<Boolean> enableSso;

    /**
     * @return Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> enableSso() {
        return Optional.ofNullable(this.enableSso);
    }

    /**
     * The fully qualified name for the directory, such as `corp.example.com`
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The fully qualified name for the directory, such as `corp.example.com`
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The password for the directory administrator or connector user.
     * 
     */
    @Import(name="password")
    private @Nullable Output<String> password;

    /**
     * @return The password for the directory administrator or connector user.
     * 
     */
    public Optional<Output<String>> password() {
        return Optional.ofNullable(this.password);
    }

    /**
     * The ID of the security group created by the directory.
     * 
     */
    @Import(name="securityGroupId")
    private @Nullable Output<String> securityGroupId;

    /**
     * @return The ID of the security group created by the directory.
     * 
     */
    public Optional<Output<String>> securityGroupId() {
        return Optional.ofNullable(this.securityGroupId);
    }

    /**
     * The short name of the directory, such as `CORP`.
     * 
     */
    @Import(name="shortName")
    private @Nullable Output<String> shortName;

    /**
     * @return The short name of the directory, such as `CORP`.
     * 
     */
    public Optional<Output<String>> shortName() {
        return Optional.ofNullable(this.shortName);
    }

    /**
     * (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     * 
     */
    @Import(name="size")
    private @Nullable Output<String> size;

    /**
     * @return (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     * 
     */
    public Optional<Output<String>> size() {
        return Optional.ofNullable(this.size);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * VPC related information about the directory. Fields documented below.
     * 
     */
    @Import(name="vpcSettings")
    private @Nullable Output<DirectoryVpcSettingsArgs> vpcSettings;

    /**
     * @return VPC related information about the directory. Fields documented below.
     * 
     */
    public Optional<Output<DirectoryVpcSettingsArgs>> vpcSettings() {
        return Optional.ofNullable(this.vpcSettings);
    }

    private DirectoryState() {}

    private DirectoryState(DirectoryState $) {
        this.accessUrl = $.accessUrl;
        this.alias = $.alias;
        this.connectSettings = $.connectSettings;
        this.description = $.description;
        this.desiredNumberOfDomainControllers = $.desiredNumberOfDomainControllers;
        this.dnsIpAddresses = $.dnsIpAddresses;
        this.edition = $.edition;
        this.enableSso = $.enableSso;
        this.name = $.name;
        this.password = $.password;
        this.securityGroupId = $.securityGroupId;
        this.shortName = $.shortName;
        this.size = $.size;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.type = $.type;
        this.vpcSettings = $.vpcSettings;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DirectoryState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DirectoryState $;

        public Builder() {
            $ = new DirectoryState();
        }

        public Builder(DirectoryState defaults) {
            $ = new DirectoryState(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessUrl The access URL for the directory, such as `http://alias.awsapps.com`.
         * 
         * @return builder
         * 
         */
        public Builder accessUrl(@Nullable Output<String> accessUrl) {
            $.accessUrl = accessUrl;
            return this;
        }

        /**
         * @param accessUrl The access URL for the directory, such as `http://alias.awsapps.com`.
         * 
         * @return builder
         * 
         */
        public Builder accessUrl(String accessUrl) {
            return accessUrl(Output.of(accessUrl));
        }

        /**
         * @param alias The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
         * 
         * @return builder
         * 
         */
        public Builder alias(@Nullable Output<String> alias) {
            $.alias = alias;
            return this;
        }

        /**
         * @param alias The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
         * 
         * @return builder
         * 
         */
        public Builder alias(String alias) {
            return alias(Output.of(alias));
        }

        /**
         * @param connectSettings Connector related information about the directory. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder connectSettings(@Nullable Output<DirectoryConnectSettingsArgs> connectSettings) {
            $.connectSettings = connectSettings;
            return this;
        }

        /**
         * @param connectSettings Connector related information about the directory. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder connectSettings(DirectoryConnectSettingsArgs connectSettings) {
            return connectSettings(Output.of(connectSettings));
        }

        /**
         * @param description A textual description for the directory.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A textual description for the directory.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param desiredNumberOfDomainControllers The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
         * 
         * @return builder
         * 
         */
        public Builder desiredNumberOfDomainControllers(@Nullable Output<Integer> desiredNumberOfDomainControllers) {
            $.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
            return this;
        }

        /**
         * @param desiredNumberOfDomainControllers The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
         * 
         * @return builder
         * 
         */
        public Builder desiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            return desiredNumberOfDomainControllers(Output.of(desiredNumberOfDomainControllers));
        }

        /**
         * @param dnsIpAddresses A list of IP addresses of the DNS servers for the directory or connector.
         * 
         * @return builder
         * 
         */
        public Builder dnsIpAddresses(@Nullable Output<List<String>> dnsIpAddresses) {
            $.dnsIpAddresses = dnsIpAddresses;
            return this;
        }

        /**
         * @param dnsIpAddresses A list of IP addresses of the DNS servers for the directory or connector.
         * 
         * @return builder
         * 
         */
        public Builder dnsIpAddresses(List<String> dnsIpAddresses) {
            return dnsIpAddresses(Output.of(dnsIpAddresses));
        }

        /**
         * @param dnsIpAddresses A list of IP addresses of the DNS servers for the directory or connector.
         * 
         * @return builder
         * 
         */
        public Builder dnsIpAddresses(String... dnsIpAddresses) {
            return dnsIpAddresses(List.of(dnsIpAddresses));
        }

        /**
         * @param edition The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
         * 
         * @return builder
         * 
         */
        public Builder edition(@Nullable Output<String> edition) {
            $.edition = edition;
            return this;
        }

        /**
         * @param edition The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
         * 
         * @return builder
         * 
         */
        public Builder edition(String edition) {
            return edition(Output.of(edition));
        }

        /**
         * @param enableSso Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder enableSso(@Nullable Output<Boolean> enableSso) {
            $.enableSso = enableSso;
            return this;
        }

        /**
         * @param enableSso Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder enableSso(Boolean enableSso) {
            return enableSso(Output.of(enableSso));
        }

        /**
         * @param name The fully qualified name for the directory, such as `corp.example.com`
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The fully qualified name for the directory, such as `corp.example.com`
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param password The password for the directory administrator or connector user.
         * 
         * @return builder
         * 
         */
        public Builder password(@Nullable Output<String> password) {
            $.password = password;
            return this;
        }

        /**
         * @param password The password for the directory administrator or connector user.
         * 
         * @return builder
         * 
         */
        public Builder password(String password) {
            return password(Output.of(password));
        }

        /**
         * @param securityGroupId The ID of the security group created by the directory.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(@Nullable Output<String> securityGroupId) {
            $.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * @param securityGroupId The ID of the security group created by the directory.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(String securityGroupId) {
            return securityGroupId(Output.of(securityGroupId));
        }

        /**
         * @param shortName The short name of the directory, such as `CORP`.
         * 
         * @return builder
         * 
         */
        public Builder shortName(@Nullable Output<String> shortName) {
            $.shortName = shortName;
            return this;
        }

        /**
         * @param shortName The short name of the directory, such as `CORP`.
         * 
         * @return builder
         * 
         */
        public Builder shortName(String shortName) {
            return shortName(Output.of(shortName));
        }

        /**
         * @param size (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
         * 
         * @return builder
         * 
         */
        public Builder size(@Nullable Output<String> size) {
            $.size = size;
            return this;
        }

        /**
         * @param size (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
         * 
         * @return builder
         * 
         */
        public Builder size(String size) {
            return size(Output.of(size));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param type The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param vpcSettings VPC related information about the directory. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder vpcSettings(@Nullable Output<DirectoryVpcSettingsArgs> vpcSettings) {
            $.vpcSettings = vpcSettings;
            return this;
        }

        /**
         * @param vpcSettings VPC related information about the directory. Fields documented below.
         * 
         * @return builder
         * 
         */
        public Builder vpcSettings(DirectoryVpcSettingsArgs vpcSettings) {
            return vpcSettings(Output.of(vpcSettings));
        }

        public DirectoryState build() {
            return $;
        }
    }

}
