// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directoryservice;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.directoryservice.ServiceRegionArgs;
import com.pulumi.aws.directoryservice.inputs.ServiceRegionState;
import com.pulumi.aws.directoryservice.outputs.ServiceRegionVpcSettings;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a replicated Region and directory for Multi-Region replication.
 * Multi-Region replication is only supported for the Enterprise Edition of AWS Managed Microsoft AD.
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Replicated Regions using directory ID,Region name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:directoryservice/serviceRegion:ServiceRegion example d-9267651497,us-east-2
 * ```
 * 
 */
@ResourceType(type="aws:directoryservice/serviceRegion:ServiceRegion")
public class ServiceRegion extends com.pulumi.resources.CustomResource {
    /**
     * The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     * 
     */
    @Export(name="desiredNumberOfDomainControllers", refs={Integer.class}, tree="[0]")
    private Output<Integer> desiredNumberOfDomainControllers;

    /**
     * @return The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     * 
     */
    public Output<Integer> desiredNumberOfDomainControllers() {
        return this.desiredNumberOfDomainControllers;
    }
    /**
     * The identifier of the directory to which you want to add Region replication.
     * 
     */
    @Export(name="directoryId", refs={String.class}, tree="[0]")
    private Output<String> directoryId;

    /**
     * @return The identifier of the directory to which you want to add Region replication.
     * 
     */
    public Output<String> directoryId() {
        return this.directoryId;
    }
    /**
     * The name of the Region where you want to add domain controllers for replication.
     * 
     */
    @Export(name="regionName", refs={String.class}, tree="[0]")
    private Output<String> regionName;

    /**
     * @return The name of the Region where you want to add domain controllers for replication.
     * 
     */
    public Output<String> regionName() {
        return this.regionName;
    }
    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * VPC information in the replicated Region. Detailed below.
     * 
     */
    @Export(name="vpcSettings", refs={ServiceRegionVpcSettings.class}, tree="[0]")
    private Output<ServiceRegionVpcSettings> vpcSettings;

    /**
     * @return VPC information in the replicated Region. Detailed below.
     * 
     */
    public Output<ServiceRegionVpcSettings> vpcSettings() {
        return this.vpcSettings;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ServiceRegion(String name) {
        this(name, ServiceRegionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ServiceRegion(String name, ServiceRegionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ServiceRegion(String name, ServiceRegionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:directoryservice/serviceRegion:ServiceRegion", name, args == null ? ServiceRegionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ServiceRegion(String name, Output<String> id, @Nullable ServiceRegionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:directoryservice/serviceRegion:ServiceRegion", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ServiceRegion get(String name, Output<String> id, @Nullable ServiceRegionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ServiceRegion(name, id, state, options);
    }
}
