// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directoryservice;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.directoryservice.ConditionalForwaderArgs;
import com.pulumi.aws.directoryservice.inputs.ConditionalForwaderState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Provides a conditional forwarder for managed Microsoft AD in AWS Directory Service.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.ConditionalForwader;
 * import com.pulumi.aws.directoryservice.ConditionalForwaderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ConditionalForwader(&#34;example&#34;, ConditionalForwaderArgs.builder()        
 *             .directoryId(aws_directory_service_directory.ad().id())
 *             .remoteDomainName(&#34;example.com&#34;)
 *             .dnsIps(            
 *                 &#34;8.8.8.8&#34;,
 *                 &#34;8.8.4.4&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import conditional forwarders using the directory id and remote_domain_name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:directoryservice/conditionalForwader:ConditionalForwader example d-1234567890:example.com
 * ```
 * 
 */
@ResourceType(type="aws:directoryservice/conditionalForwader:ConditionalForwader")
public class ConditionalForwader extends com.pulumi.resources.CustomResource {
    /**
     * ID of directory.
     * 
     */
    @Export(name="directoryId", refs={String.class}, tree="[0]")
    private Output<String> directoryId;

    /**
     * @return ID of directory.
     * 
     */
    public Output<String> directoryId() {
        return this.directoryId;
    }
    /**
     * A list of forwarder IP addresses.
     * 
     */
    @Export(name="dnsIps", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> dnsIps;

    /**
     * @return A list of forwarder IP addresses.
     * 
     */
    public Output<List<String>> dnsIps() {
        return this.dnsIps;
    }
    /**
     * The fully qualified domain name of the remote domain for which forwarders will be used.
     * 
     */
    @Export(name="remoteDomainName", refs={String.class}, tree="[0]")
    private Output<String> remoteDomainName;

    /**
     * @return The fully qualified domain name of the remote domain for which forwarders will be used.
     * 
     */
    public Output<String> remoteDomainName() {
        return this.remoteDomainName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ConditionalForwader(String name) {
        this(name, ConditionalForwaderArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ConditionalForwader(String name, ConditionalForwaderArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ConditionalForwader(String name, ConditionalForwaderArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:directoryservice/conditionalForwader:ConditionalForwader", name, args == null ? ConditionalForwaderArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ConditionalForwader(String name, Output<String> id, @Nullable ConditionalForwaderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:directoryservice/conditionalForwader:ConditionalForwader", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ConditionalForwader get(String name, Output<String> id, @Nullable ConditionalForwaderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ConditionalForwader(name, id, state, options);
    }
}
