// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directconnect.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GatewayAssociationState extends com.pulumi.resources.ResourceArgs {

    public static final GatewayAssociationState Empty = new GatewayAssociationState();

    /**
     * VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     * 
     */
    @Import(name="allowedPrefixes")
    private @Nullable Output<List<String>> allowedPrefixes;

    /**
     * @return VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     * 
     */
    public Optional<Output<List<String>>> allowedPrefixes() {
        return Optional.ofNullable(this.allowedPrefixes);
    }

    /**
     * The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     * 
     */
    @Import(name="associatedGatewayId")
    private @Nullable Output<String> associatedGatewayId;

    /**
     * @return The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> associatedGatewayId() {
        return Optional.ofNullable(this.associatedGatewayId);
    }

    /**
     * The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    @Import(name="associatedGatewayOwnerAccountId")
    private @Nullable Output<String> associatedGatewayOwnerAccountId;

    /**
     * @return The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> associatedGatewayOwnerAccountId() {
        return Optional.ofNullable(this.associatedGatewayOwnerAccountId);
    }

    /**
     * The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
     * 
     */
    @Import(name="associatedGatewayType")
    private @Nullable Output<String> associatedGatewayType;

    /**
     * @return The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
     * 
     */
    public Optional<Output<String>> associatedGatewayType() {
        return Optional.ofNullable(this.associatedGatewayType);
    }

    /**
     * The ID of the Direct Connect gateway association.
     * 
     */
    @Import(name="dxGatewayAssociationId")
    private @Nullable Output<String> dxGatewayAssociationId;

    /**
     * @return The ID of the Direct Connect gateway association.
     * 
     */
    public Optional<Output<String>> dxGatewayAssociationId() {
        return Optional.ofNullable(this.dxGatewayAssociationId);
    }

    /**
     * The ID of the Direct Connect gateway.
     * 
     */
    @Import(name="dxGatewayId")
    private @Nullable Output<String> dxGatewayId;

    /**
     * @return The ID of the Direct Connect gateway.
     * 
     */
    public Optional<Output<String>> dxGatewayId() {
        return Optional.ofNullable(this.dxGatewayId);
    }

    /**
     * The ID of the AWS account that owns the Direct Connect gateway.
     * 
     */
    @Import(name="dxGatewayOwnerAccountId")
    private @Nullable Output<String> dxGatewayOwnerAccountId;

    /**
     * @return The ID of the AWS account that owns the Direct Connect gateway.
     * 
     */
    public Optional<Output<String>> dxGatewayOwnerAccountId() {
        return Optional.ofNullable(this.dxGatewayOwnerAccountId);
    }

    /**
     * The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    @Import(name="proposalId")
    private @Nullable Output<String> proposalId;

    /**
     * @return The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> proposalId() {
        return Optional.ofNullable(this.proposalId);
    }

    /**
     * @deprecated
     * use &#39;associated_gateway_id&#39; argument instead
     * 
     */
    @Deprecated /* use 'associated_gateway_id' argument instead */
    @Import(name="vpnGatewayId")
    private @Nullable Output<String> vpnGatewayId;

    /**
     * @deprecated
     * use &#39;associated_gateway_id&#39; argument instead
     * 
     */
    @Deprecated /* use 'associated_gateway_id' argument instead */
    public Optional<Output<String>> vpnGatewayId() {
        return Optional.ofNullable(this.vpnGatewayId);
    }

    private GatewayAssociationState() {}

    private GatewayAssociationState(GatewayAssociationState $) {
        this.allowedPrefixes = $.allowedPrefixes;
        this.associatedGatewayId = $.associatedGatewayId;
        this.associatedGatewayOwnerAccountId = $.associatedGatewayOwnerAccountId;
        this.associatedGatewayType = $.associatedGatewayType;
        this.dxGatewayAssociationId = $.dxGatewayAssociationId;
        this.dxGatewayId = $.dxGatewayId;
        this.dxGatewayOwnerAccountId = $.dxGatewayOwnerAccountId;
        this.proposalId = $.proposalId;
        this.vpnGatewayId = $.vpnGatewayId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GatewayAssociationState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GatewayAssociationState $;

        public Builder() {
            $ = new GatewayAssociationState();
        }

        public Builder(GatewayAssociationState defaults) {
            $ = new GatewayAssociationState(Objects.requireNonNull(defaults));
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(@Nullable Output<List<String>> allowedPrefixes) {
            $.allowedPrefixes = allowedPrefixes;
            return this;
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(List<String> allowedPrefixes) {
            return allowedPrefixes(Output.of(allowedPrefixes));
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(String... allowedPrefixes) {
            return allowedPrefixes(List.of(allowedPrefixes));
        }

        /**
         * @param associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for single account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayId(@Nullable Output<String> associatedGatewayId) {
            $.associatedGatewayId = associatedGatewayId;
            return this;
        }

        /**
         * @param associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for single account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayId(String associatedGatewayId) {
            return associatedGatewayId(Output.of(associatedGatewayId));
        }

        /**
         * @param associatedGatewayOwnerAccountId The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayOwnerAccountId(@Nullable Output<String> associatedGatewayOwnerAccountId) {
            $.associatedGatewayOwnerAccountId = associatedGatewayOwnerAccountId;
            return this;
        }

        /**
         * @param associatedGatewayOwnerAccountId The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayOwnerAccountId(String associatedGatewayOwnerAccountId) {
            return associatedGatewayOwnerAccountId(Output.of(associatedGatewayOwnerAccountId));
        }

        /**
         * @param associatedGatewayType The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayType(@Nullable Output<String> associatedGatewayType) {
            $.associatedGatewayType = associatedGatewayType;
            return this;
        }

        /**
         * @param associatedGatewayType The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayType(String associatedGatewayType) {
            return associatedGatewayType(Output.of(associatedGatewayType));
        }

        /**
         * @param dxGatewayAssociationId The ID of the Direct Connect gateway association.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayAssociationId(@Nullable Output<String> dxGatewayAssociationId) {
            $.dxGatewayAssociationId = dxGatewayAssociationId;
            return this;
        }

        /**
         * @param dxGatewayAssociationId The ID of the Direct Connect gateway association.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayAssociationId(String dxGatewayAssociationId) {
            return dxGatewayAssociationId(Output.of(dxGatewayAssociationId));
        }

        /**
         * @param dxGatewayId The ID of the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayId(@Nullable Output<String> dxGatewayId) {
            $.dxGatewayId = dxGatewayId;
            return this;
        }

        /**
         * @param dxGatewayId The ID of the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayId(String dxGatewayId) {
            return dxGatewayId(Output.of(dxGatewayId));
        }

        /**
         * @param dxGatewayOwnerAccountId The ID of the AWS account that owns the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayOwnerAccountId(@Nullable Output<String> dxGatewayOwnerAccountId) {
            $.dxGatewayOwnerAccountId = dxGatewayOwnerAccountId;
            return this;
        }

        /**
         * @param dxGatewayOwnerAccountId The ID of the AWS account that owns the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayOwnerAccountId(String dxGatewayOwnerAccountId) {
            return dxGatewayOwnerAccountId(Output.of(dxGatewayOwnerAccountId));
        }

        /**
         * @param proposalId The ID of the Direct Connect gateway association proposal.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder proposalId(@Nullable Output<String> proposalId) {
            $.proposalId = proposalId;
            return this;
        }

        /**
         * @param proposalId The ID of the Direct Connect gateway association proposal.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder proposalId(String proposalId) {
            return proposalId(Output.of(proposalId));
        }

        /**
         * @return builder
         * 
         * @deprecated
         * use &#39;associated_gateway_id&#39; argument instead
         * 
         */
        @Deprecated /* use 'associated_gateway_id' argument instead */
        public Builder vpnGatewayId(@Nullable Output<String> vpnGatewayId) {
            $.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * @return builder
         * 
         * @deprecated
         * use &#39;associated_gateway_id&#39; argument instead
         * 
         */
        @Deprecated /* use 'associated_gateway_id' argument instead */
        public Builder vpnGatewayId(String vpnGatewayId) {
            return vpnGatewayId(Output.of(vpnGatewayId));
        }

        public GatewayAssociationState build() {
            return $;
        }
    }

}
