// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directconnect.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ConnectionState extends com.pulumi.resources.ResourceArgs {

    public static final ConnectionState Empty = new ConnectionState();

    /**
     * The ARN of the connection.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The ARN of the connection.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The Direct Connect endpoint on which the physical connection terminates.
     * 
     */
    @Import(name="awsDevice")
    private @Nullable Output<String> awsDevice;

    /**
     * @return The Direct Connect endpoint on which the physical connection terminates.
     * 
     */
    public Optional<Output<String>> awsDevice() {
        return Optional.ofNullable(this.awsDevice);
    }

    /**
     * The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     * 
     */
    @Import(name="bandwidth")
    private @Nullable Output<String> bandwidth;

    /**
     * @return The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     * 
     */
    public Optional<Output<String>> bandwidth() {
        return Optional.ofNullable(this.bandwidth);
    }

    /**
     * The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     * 
     */
    @Import(name="encryptionMode")
    private @Nullable Output<String> encryptionMode;

    /**
     * @return The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     * 
     */
    public Optional<Output<String>> encryptionMode() {
        return Optional.ofNullable(this.encryptionMode);
    }

    /**
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * 
     */
    @Import(name="hasLogicalRedundancy")
    private @Nullable Output<String> hasLogicalRedundancy;

    /**
     * @return Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * 
     */
    public Optional<Output<String>> hasLogicalRedundancy() {
        return Optional.ofNullable(this.hasLogicalRedundancy);
    }

    /**
     * Boolean value representing if jumbo frames have been enabled for this connection.
     * 
     */
    @Import(name="jumboFrameCapable")
    private @Nullable Output<Boolean> jumboFrameCapable;

    /**
     * @return Boolean value representing if jumbo frames have been enabled for this connection.
     * 
     */
    public Optional<Output<Boolean>> jumboFrameCapable() {
        return Optional.ofNullable(this.jumboFrameCapable);
    }

    /**
     * The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     * 
     */
    @Import(name="location")
    private @Nullable Output<String> location;

    /**
     * @return The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     * 
     */
    public Optional<Output<String>> location() {
        return Optional.ofNullable(this.location);
    }

    /**
     * Boolean value indicating whether the connection supports MAC Security (MACsec).
     * 
     */
    @Import(name="macsecCapable")
    private @Nullable Output<Boolean> macsecCapable;

    /**
     * @return Boolean value indicating whether the connection supports MAC Security (MACsec).
     * 
     */
    public Optional<Output<Boolean>> macsecCapable() {
        return Optional.ofNullable(this.macsecCapable);
    }

    /**
     * The name of the connection.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the connection.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The ID of the AWS account that owns the connection.
     * 
     */
    @Import(name="ownerAccountId")
    private @Nullable Output<String> ownerAccountId;

    /**
     * @return The ID of the AWS account that owns the connection.
     * 
     */
    public Optional<Output<String>> ownerAccountId() {
        return Optional.ofNullable(this.ownerAccountId);
    }

    /**
     * The name of the AWS Direct Connect service provider associated with the connection.
     * 
     */
    @Import(name="partnerName")
    private @Nullable Output<String> partnerName;

    /**
     * @return The name of the AWS Direct Connect service provider associated with the connection.
     * 
     */
    public Optional<Output<String>> partnerName() {
        return Optional.ofNullable(this.partnerName);
    }

    /**
     * The MAC Security (MACsec) port link status of the connection.
     * 
     */
    @Import(name="portEncryptionStatus")
    private @Nullable Output<String> portEncryptionStatus;

    /**
     * @return The MAC Security (MACsec) port link status of the connection.
     * 
     */
    public Optional<Output<String>> portEncryptionStatus() {
        return Optional.ofNullable(this.portEncryptionStatus);
    }

    /**
     * The name of the service provider associated with the connection.
     * 
     */
    @Import(name="providerName")
    private @Nullable Output<String> providerName;

    /**
     * @return The name of the service provider associated with the connection.
     * 
     */
    public Optional<Output<String>> providerName() {
        return Optional.ofNullable(this.providerName);
    }

    /**
     * Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
     * 
     * &gt; **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
     * 
     */
    @Import(name="requestMacsec")
    private @Nullable Output<Boolean> requestMacsec;

    /**
     * @return Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
     * 
     * &gt; **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
     * 
     */
    public Optional<Output<Boolean>> requestMacsec() {
        return Optional.ofNullable(this.requestMacsec);
    }

    /**
     * Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
     * 
     */
    @Import(name="skipDestroy")
    private @Nullable Output<Boolean> skipDestroy;

    /**
     * @return Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
     * 
     */
    public Optional<Output<Boolean>> skipDestroy() {
        return Optional.ofNullable(this.skipDestroy);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The VLAN ID.
     * 
     */
    @Import(name="vlanId")
    private @Nullable Output<Integer> vlanId;

    /**
     * @return The VLAN ID.
     * 
     */
    public Optional<Output<Integer>> vlanId() {
        return Optional.ofNullable(this.vlanId);
    }

    private ConnectionState() {}

    private ConnectionState(ConnectionState $) {
        this.arn = $.arn;
        this.awsDevice = $.awsDevice;
        this.bandwidth = $.bandwidth;
        this.encryptionMode = $.encryptionMode;
        this.hasLogicalRedundancy = $.hasLogicalRedundancy;
        this.jumboFrameCapable = $.jumboFrameCapable;
        this.location = $.location;
        this.macsecCapable = $.macsecCapable;
        this.name = $.name;
        this.ownerAccountId = $.ownerAccountId;
        this.partnerName = $.partnerName;
        this.portEncryptionStatus = $.portEncryptionStatus;
        this.providerName = $.providerName;
        this.requestMacsec = $.requestMacsec;
        this.skipDestroy = $.skipDestroy;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.vlanId = $.vlanId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ConnectionState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ConnectionState $;

        public Builder() {
            $ = new ConnectionState();
        }

        public Builder(ConnectionState defaults) {
            $ = new ConnectionState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The ARN of the connection.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The ARN of the connection.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param awsDevice The Direct Connect endpoint on which the physical connection terminates.
         * 
         * @return builder
         * 
         */
        public Builder awsDevice(@Nullable Output<String> awsDevice) {
            $.awsDevice = awsDevice;
            return this;
        }

        /**
         * @param awsDevice The Direct Connect endpoint on which the physical connection terminates.
         * 
         * @return builder
         * 
         */
        public Builder awsDevice(String awsDevice) {
            return awsDevice(Output.of(awsDevice));
        }

        /**
         * @param bandwidth The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
         * 
         * @return builder
         * 
         */
        public Builder bandwidth(@Nullable Output<String> bandwidth) {
            $.bandwidth = bandwidth;
            return this;
        }

        /**
         * @param bandwidth The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
         * 
         * @return builder
         * 
         */
        public Builder bandwidth(String bandwidth) {
            return bandwidth(Output.of(bandwidth));
        }

        /**
         * @param encryptionMode The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(@Nullable Output<String> encryptionMode) {
            $.encryptionMode = encryptionMode;
            return this;
        }

        /**
         * @param encryptionMode The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
         * 
         * @return builder
         * 
         */
        public Builder encryptionMode(String encryptionMode) {
            return encryptionMode(Output.of(encryptionMode));
        }

        /**
         * @param hasLogicalRedundancy Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * 
         * @return builder
         * 
         */
        public Builder hasLogicalRedundancy(@Nullable Output<String> hasLogicalRedundancy) {
            $.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        /**
         * @param hasLogicalRedundancy Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * 
         * @return builder
         * 
         */
        public Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            return hasLogicalRedundancy(Output.of(hasLogicalRedundancy));
        }

        /**
         * @param jumboFrameCapable Boolean value representing if jumbo frames have been enabled for this connection.
         * 
         * @return builder
         * 
         */
        public Builder jumboFrameCapable(@Nullable Output<Boolean> jumboFrameCapable) {
            $.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        /**
         * @param jumboFrameCapable Boolean value representing if jumbo frames have been enabled for this connection.
         * 
         * @return builder
         * 
         */
        public Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            return jumboFrameCapable(Output.of(jumboFrameCapable));
        }

        /**
         * @param location The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
         * 
         * @return builder
         * 
         */
        public Builder location(@Nullable Output<String> location) {
            $.location = location;
            return this;
        }

        /**
         * @param location The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
         * 
         * @return builder
         * 
         */
        public Builder location(String location) {
            return location(Output.of(location));
        }

        /**
         * @param macsecCapable Boolean value indicating whether the connection supports MAC Security (MACsec).
         * 
         * @return builder
         * 
         */
        public Builder macsecCapable(@Nullable Output<Boolean> macsecCapable) {
            $.macsecCapable = macsecCapable;
            return this;
        }

        /**
         * @param macsecCapable Boolean value indicating whether the connection supports MAC Security (MACsec).
         * 
         * @return builder
         * 
         */
        public Builder macsecCapable(Boolean macsecCapable) {
            return macsecCapable(Output.of(macsecCapable));
        }

        /**
         * @param name The name of the connection.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the connection.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param ownerAccountId The ID of the AWS account that owns the connection.
         * 
         * @return builder
         * 
         */
        public Builder ownerAccountId(@Nullable Output<String> ownerAccountId) {
            $.ownerAccountId = ownerAccountId;
            return this;
        }

        /**
         * @param ownerAccountId The ID of the AWS account that owns the connection.
         * 
         * @return builder
         * 
         */
        public Builder ownerAccountId(String ownerAccountId) {
            return ownerAccountId(Output.of(ownerAccountId));
        }

        /**
         * @param partnerName The name of the AWS Direct Connect service provider associated with the connection.
         * 
         * @return builder
         * 
         */
        public Builder partnerName(@Nullable Output<String> partnerName) {
            $.partnerName = partnerName;
            return this;
        }

        /**
         * @param partnerName The name of the AWS Direct Connect service provider associated with the connection.
         * 
         * @return builder
         * 
         */
        public Builder partnerName(String partnerName) {
            return partnerName(Output.of(partnerName));
        }

        /**
         * @param portEncryptionStatus The MAC Security (MACsec) port link status of the connection.
         * 
         * @return builder
         * 
         */
        public Builder portEncryptionStatus(@Nullable Output<String> portEncryptionStatus) {
            $.portEncryptionStatus = portEncryptionStatus;
            return this;
        }

        /**
         * @param portEncryptionStatus The MAC Security (MACsec) port link status of the connection.
         * 
         * @return builder
         * 
         */
        public Builder portEncryptionStatus(String portEncryptionStatus) {
            return portEncryptionStatus(Output.of(portEncryptionStatus));
        }

        /**
         * @param providerName The name of the service provider associated with the connection.
         * 
         * @return builder
         * 
         */
        public Builder providerName(@Nullable Output<String> providerName) {
            $.providerName = providerName;
            return this;
        }

        /**
         * @param providerName The name of the service provider associated with the connection.
         * 
         * @return builder
         * 
         */
        public Builder providerName(String providerName) {
            return providerName(Output.of(providerName));
        }

        /**
         * @param requestMacsec Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
         * 
         * &gt; **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
         * 
         * @return builder
         * 
         */
        public Builder requestMacsec(@Nullable Output<Boolean> requestMacsec) {
            $.requestMacsec = requestMacsec;
            return this;
        }

        /**
         * @param requestMacsec Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
         * 
         * &gt; **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
         * 
         * @return builder
         * 
         */
        public Builder requestMacsec(Boolean requestMacsec) {
            return requestMacsec(Output.of(requestMacsec));
        }

        /**
         * @param skipDestroy Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
         * 
         * @return builder
         * 
         */
        public Builder skipDestroy(@Nullable Output<Boolean> skipDestroy) {
            $.skipDestroy = skipDestroy;
            return this;
        }

        /**
         * @param skipDestroy Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
         * 
         * @return builder
         * 
         */
        public Builder skipDestroy(Boolean skipDestroy) {
            return skipDestroy(Output.of(skipDestroy));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param vlanId The VLAN ID.
         * 
         * @return builder
         * 
         */
        public Builder vlanId(@Nullable Output<Integer> vlanId) {
            $.vlanId = vlanId;
            return this;
        }

        /**
         * @param vlanId The VLAN ID.
         * 
         * @return builder
         * 
         */
        public Builder vlanId(Integer vlanId) {
            return vlanId(Output.of(vlanId));
        }

        public ConnectionState build() {
            return $;
        }
    }

}
