// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directconnect;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GatewayAssociationArgs extends com.pulumi.resources.ResourceArgs {

    public static final GatewayAssociationArgs Empty = new GatewayAssociationArgs();

    /**
     * VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     * 
     */
    @Import(name="allowedPrefixes")
    private @Nullable Output<List<String>> allowedPrefixes;

    /**
     * @return VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     * 
     */
    public Optional<Output<List<String>>> allowedPrefixes() {
        return Optional.ofNullable(this.allowedPrefixes);
    }

    /**
     * The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     * 
     */
    @Import(name="associatedGatewayId")
    private @Nullable Output<String> associatedGatewayId;

    /**
     * @return The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> associatedGatewayId() {
        return Optional.ofNullable(this.associatedGatewayId);
    }

    /**
     * The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    @Import(name="associatedGatewayOwnerAccountId")
    private @Nullable Output<String> associatedGatewayOwnerAccountId;

    /**
     * @return The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> associatedGatewayOwnerAccountId() {
        return Optional.ofNullable(this.associatedGatewayOwnerAccountId);
    }

    /**
     * The ID of the Direct Connect gateway.
     * 
     */
    @Import(name="dxGatewayId", required=true)
    private Output<String> dxGatewayId;

    /**
     * @return The ID of the Direct Connect gateway.
     * 
     */
    public Output<String> dxGatewayId() {
        return this.dxGatewayId;
    }

    /**
     * The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    @Import(name="proposalId")
    private @Nullable Output<String> proposalId;

    /**
     * @return The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     * 
     */
    public Optional<Output<String>> proposalId() {
        return Optional.ofNullable(this.proposalId);
    }

    /**
     * @deprecated
     * use &#39;associated_gateway_id&#39; argument instead
     * 
     */
    @Deprecated /* use 'associated_gateway_id' argument instead */
    @Import(name="vpnGatewayId")
    private @Nullable Output<String> vpnGatewayId;

    /**
     * @deprecated
     * use &#39;associated_gateway_id&#39; argument instead
     * 
     */
    @Deprecated /* use 'associated_gateway_id' argument instead */
    public Optional<Output<String>> vpnGatewayId() {
        return Optional.ofNullable(this.vpnGatewayId);
    }

    private GatewayAssociationArgs() {}

    private GatewayAssociationArgs(GatewayAssociationArgs $) {
        this.allowedPrefixes = $.allowedPrefixes;
        this.associatedGatewayId = $.associatedGatewayId;
        this.associatedGatewayOwnerAccountId = $.associatedGatewayOwnerAccountId;
        this.dxGatewayId = $.dxGatewayId;
        this.proposalId = $.proposalId;
        this.vpnGatewayId = $.vpnGatewayId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GatewayAssociationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GatewayAssociationArgs $;

        public Builder() {
            $ = new GatewayAssociationArgs();
        }

        public Builder(GatewayAssociationArgs defaults) {
            $ = new GatewayAssociationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(@Nullable Output<List<String>> allowedPrefixes) {
            $.allowedPrefixes = allowedPrefixes;
            return this;
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(List<String> allowedPrefixes) {
            return allowedPrefixes(Output.of(allowedPrefixes));
        }

        /**
         * @param allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
         * 
         * @return builder
         * 
         */
        public Builder allowedPrefixes(String... allowedPrefixes) {
            return allowedPrefixes(List.of(allowedPrefixes));
        }

        /**
         * @param associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for single account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayId(@Nullable Output<String> associatedGatewayId) {
            $.associatedGatewayId = associatedGatewayId;
            return this;
        }

        /**
         * @param associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for single account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayId(String associatedGatewayId) {
            return associatedGatewayId(Output.of(associatedGatewayId));
        }

        /**
         * @param associatedGatewayOwnerAccountId The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayOwnerAccountId(@Nullable Output<String> associatedGatewayOwnerAccountId) {
            $.associatedGatewayOwnerAccountId = associatedGatewayOwnerAccountId;
            return this;
        }

        /**
         * @param associatedGatewayOwnerAccountId The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder associatedGatewayOwnerAccountId(String associatedGatewayOwnerAccountId) {
            return associatedGatewayOwnerAccountId(Output.of(associatedGatewayOwnerAccountId));
        }

        /**
         * @param dxGatewayId The ID of the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayId(Output<String> dxGatewayId) {
            $.dxGatewayId = dxGatewayId;
            return this;
        }

        /**
         * @param dxGatewayId The ID of the Direct Connect gateway.
         * 
         * @return builder
         * 
         */
        public Builder dxGatewayId(String dxGatewayId) {
            return dxGatewayId(Output.of(dxGatewayId));
        }

        /**
         * @param proposalId The ID of the Direct Connect gateway association proposal.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder proposalId(@Nullable Output<String> proposalId) {
            $.proposalId = proposalId;
            return this;
        }

        /**
         * @param proposalId The ID of the Direct Connect gateway association proposal.
         * Used for cross-account Direct Connect gateway associations.
         * 
         * @return builder
         * 
         */
        public Builder proposalId(String proposalId) {
            return proposalId(Output.of(proposalId));
        }

        /**
         * @return builder
         * 
         * @deprecated
         * use &#39;associated_gateway_id&#39; argument instead
         * 
         */
        @Deprecated /* use 'associated_gateway_id' argument instead */
        public Builder vpnGatewayId(@Nullable Output<String> vpnGatewayId) {
            $.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * @return builder
         * 
         * @deprecated
         * use &#39;associated_gateway_id&#39; argument instead
         * 
         */
        @Deprecated /* use 'associated_gateway_id' argument instead */
        public Builder vpnGatewayId(String vpnGatewayId) {
            return vpnGatewayId(Output.of(vpnGatewayId));
        }

        public GatewayAssociationArgs build() {
            $.dxGatewayId = Objects.requireNonNull($.dxGatewayId, "expected parameter 'dxGatewayId' to be non-null");
            return $;
        }
    }

}
