// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.directconnect;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BgpPeerArgs extends com.pulumi.resources.ResourceArgs {

    public static final BgpPeerArgs Empty = new BgpPeerArgs();

    /**
     * The address family for the BGP peer. ` ipv4  ` or `ipv6`.
     * 
     */
    @Import(name="addressFamily", required=true)
    private Output<String> addressFamily;

    /**
     * @return The address family for the BGP peer. ` ipv4  ` or `ipv6`.
     * 
     */
    public Output<String> addressFamily() {
        return this.addressFamily;
    }

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon.
     * Required for IPv4 BGP peers on public virtual interfaces.
     * 
     */
    @Import(name="amazonAddress")
    private @Nullable Output<String> amazonAddress;

    /**
     * @return The IPv4 CIDR address to use to send traffic to Amazon.
     * Required for IPv4 BGP peers on public virtual interfaces.
     * 
     */
    public Optional<Output<String>> amazonAddress() {
        return Optional.ofNullable(this.amazonAddress);
    }

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * 
     */
    @Import(name="bgpAsn", required=true)
    private Output<Integer> bgpAsn;

    /**
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * 
     */
    public Output<Integer> bgpAsn() {
        return this.bgpAsn;
    }

    /**
     * The authentication key for BGP configuration.
     * 
     */
    @Import(name="bgpAuthKey")
    private @Nullable Output<String> bgpAuthKey;

    /**
     * @return The authentication key for BGP configuration.
     * 
     */
    public Optional<Output<String>> bgpAuthKey() {
        return Optional.ofNullable(this.bgpAuthKey);
    }

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic.
     * Required for IPv4 BGP peers on public virtual interfaces.
     * 
     */
    @Import(name="customerAddress")
    private @Nullable Output<String> customerAddress;

    /**
     * @return The IPv4 CIDR destination address to which Amazon should send traffic.
     * Required for IPv4 BGP peers on public virtual interfaces.
     * 
     */
    public Optional<Output<String>> customerAddress() {
        return Optional.ofNullable(this.customerAddress);
    }

    /**
     * The ID of the Direct Connect virtual interface on which to create the BGP peer.
     * 
     */
    @Import(name="virtualInterfaceId", required=true)
    private Output<String> virtualInterfaceId;

    /**
     * @return The ID of the Direct Connect virtual interface on which to create the BGP peer.
     * 
     */
    public Output<String> virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    private BgpPeerArgs() {}

    private BgpPeerArgs(BgpPeerArgs $) {
        this.addressFamily = $.addressFamily;
        this.amazonAddress = $.amazonAddress;
        this.bgpAsn = $.bgpAsn;
        this.bgpAuthKey = $.bgpAuthKey;
        this.customerAddress = $.customerAddress;
        this.virtualInterfaceId = $.virtualInterfaceId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BgpPeerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BgpPeerArgs $;

        public Builder() {
            $ = new BgpPeerArgs();
        }

        public Builder(BgpPeerArgs defaults) {
            $ = new BgpPeerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param addressFamily The address family for the BGP peer. ` ipv4  ` or `ipv6`.
         * 
         * @return builder
         * 
         */
        public Builder addressFamily(Output<String> addressFamily) {
            $.addressFamily = addressFamily;
            return this;
        }

        /**
         * @param addressFamily The address family for the BGP peer. ` ipv4  ` or `ipv6`.
         * 
         * @return builder
         * 
         */
        public Builder addressFamily(String addressFamily) {
            return addressFamily(Output.of(addressFamily));
        }

        /**
         * @param amazonAddress The IPv4 CIDR address to use to send traffic to Amazon.
         * Required for IPv4 BGP peers on public virtual interfaces.
         * 
         * @return builder
         * 
         */
        public Builder amazonAddress(@Nullable Output<String> amazonAddress) {
            $.amazonAddress = amazonAddress;
            return this;
        }

        /**
         * @param amazonAddress The IPv4 CIDR address to use to send traffic to Amazon.
         * Required for IPv4 BGP peers on public virtual interfaces.
         * 
         * @return builder
         * 
         */
        public Builder amazonAddress(String amazonAddress) {
            return amazonAddress(Output.of(amazonAddress));
        }

        /**
         * @param bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * 
         * @return builder
         * 
         */
        public Builder bgpAsn(Output<Integer> bgpAsn) {
            $.bgpAsn = bgpAsn;
            return this;
        }

        /**
         * @param bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * 
         * @return builder
         * 
         */
        public Builder bgpAsn(Integer bgpAsn) {
            return bgpAsn(Output.of(bgpAsn));
        }

        /**
         * @param bgpAuthKey The authentication key for BGP configuration.
         * 
         * @return builder
         * 
         */
        public Builder bgpAuthKey(@Nullable Output<String> bgpAuthKey) {
            $.bgpAuthKey = bgpAuthKey;
            return this;
        }

        /**
         * @param bgpAuthKey The authentication key for BGP configuration.
         * 
         * @return builder
         * 
         */
        public Builder bgpAuthKey(String bgpAuthKey) {
            return bgpAuthKey(Output.of(bgpAuthKey));
        }

        /**
         * @param customerAddress The IPv4 CIDR destination address to which Amazon should send traffic.
         * Required for IPv4 BGP peers on public virtual interfaces.
         * 
         * @return builder
         * 
         */
        public Builder customerAddress(@Nullable Output<String> customerAddress) {
            $.customerAddress = customerAddress;
            return this;
        }

        /**
         * @param customerAddress The IPv4 CIDR destination address to which Amazon should send traffic.
         * Required for IPv4 BGP peers on public virtual interfaces.
         * 
         * @return builder
         * 
         */
        public Builder customerAddress(String customerAddress) {
            return customerAddress(Output.of(customerAddress));
        }

        /**
         * @param virtualInterfaceId The ID of the Direct Connect virtual interface on which to create the BGP peer.
         * 
         * @return builder
         * 
         */
        public Builder virtualInterfaceId(Output<String> virtualInterfaceId) {
            $.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        /**
         * @param virtualInterfaceId The ID of the Direct Connect virtual interface on which to create the BGP peer.
         * 
         * @return builder
         * 
         */
        public Builder virtualInterfaceId(String virtualInterfaceId) {
            return virtualInterfaceId(Output.of(virtualInterfaceId));
        }

        public BgpPeerArgs build() {
            $.addressFamily = Objects.requireNonNull($.addressFamily, "expected parameter 'addressFamily' to be non-null");
            $.bgpAsn = Objects.requireNonNull($.bgpAsn, "expected parameter 'bgpAsn' to be non-null");
            $.virtualInterfaceId = Objects.requireNonNull($.virtualInterfaceId, "expected parameter 'virtualInterfaceId' to be non-null");
            return $;
        }
    }

}
