// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.devicefarm;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.devicefarm.UploadArgs;
import com.pulumi.aws.devicefarm.inputs.UploadState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage AWS Device Farm Uploads.
 * 
 * &gt; **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.Project;
 * import com.pulumi.aws.devicefarm.Upload;
 * import com.pulumi.aws.devicefarm.UploadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleProject = new Project(&#34;exampleProject&#34;);
 * 
 *         var exampleUpload = new Upload(&#34;exampleUpload&#34;, UploadArgs.builder()        
 *             .projectArn(exampleProject.arn())
 *             .type(&#34;APPIUM_JAVA_TESTNG_TEST_SPEC&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import DeviceFarm Uploads using their ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:devicefarm/upload:Upload example arn:aws:devicefarm:us-west-2:123456789012:upload:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * 
 */
@ResourceType(type="aws:devicefarm/upload:Upload")
public class Upload extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name of this upload.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name of this upload.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The upload&#39;s category.
     * 
     */
    @Export(name="category", refs={String.class}, tree="[0]")
    private Output<String> category;

    /**
     * @return The upload&#39;s category.
     * 
     */
    public Output<String> category() {
        return this.category;
    }
    /**
     * The upload&#39;s content type (for example, application/octet-stream).
     * 
     */
    @Export(name="contentType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> contentType;

    /**
     * @return The upload&#39;s content type (for example, application/octet-stream).
     * 
     */
    public Output<Optional<String>> contentType() {
        return Codegen.optional(this.contentType);
    }
    /**
     * The upload&#39;s metadata. For example, for Android, this contains information that is parsed from the manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
     * 
     */
    @Export(name="metadata", refs={String.class}, tree="[0]")
    private Output<String> metadata;

    /**
     * @return The upload&#39;s metadata. For example, for Android, this contains information that is parsed from the manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
     * 
     */
    public Output<String> metadata() {
        return this.metadata;
    }
    /**
     * The upload&#39;s file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The upload&#39;s file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The ARN of the project for the upload.
     * 
     */
    @Export(name="projectArn", refs={String.class}, tree="[0]")
    private Output<String> projectArn;

    /**
     * @return The ARN of the project for the upload.
     * 
     */
    public Output<String> projectArn() {
        return this.projectArn;
    }
    /**
     * The upload&#39;s upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return The upload&#39;s upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
     * 
     */
    public Output<String> type() {
        return this.type;
    }
    /**
     * The presigned Amazon S3 URL that was used to store a file using a PUT request.
     * 
     */
    @Export(name="url", refs={String.class}, tree="[0]")
    private Output<String> url;

    /**
     * @return The presigned Amazon S3 URL that was used to store a file using a PUT request.
     * 
     */
    public Output<String> url() {
        return this.url;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Upload(String name) {
        this(name, UploadArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Upload(String name, UploadArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Upload(String name, UploadArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:devicefarm/upload:Upload", name, args == null ? UploadArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Upload(String name, Output<String> id, @Nullable UploadState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:devicefarm/upload:Upload", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Upload get(String name, Output<String> id, @Nullable UploadState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Upload(name, id, state, options);
    }
}
