// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.devicefarm;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.devicefarm.DevicePoolArgs;
import com.pulumi.aws.devicefarm.inputs.DevicePoolState;
import com.pulumi.aws.devicefarm.outputs.DevicePoolRule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage AWS Device Farm Device Pools.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.DevicePool;
 * import com.pulumi.aws.devicefarm.DevicePoolArgs;
 * import com.pulumi.aws.devicefarm.inputs.DevicePoolRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new DevicePool(&#34;example&#34;, DevicePoolArgs.builder()        
 *             .projectArn(aws_devicefarm_project.example().arn())
 *             .rules(DevicePoolRuleArgs.builder()
 *                 .attribute(&#34;OS_VERSION&#34;)
 *                 .operator(&#34;EQUALS&#34;)
 *                 .value(&#34;\&#34;AVAILABLE\&#34;&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import DeviceFarm Device Pools using their ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:devicefarm/devicePool:DevicePool example arn:aws:devicefarm:us-west-2:123456789012:devicepool:4fa784c7-ccb4-4dbf-ba4f-02198320daa1/4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * 
 */
@ResourceType(type="aws:devicefarm/devicePool:DevicePool")
public class DevicePool extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name of this Device Pool
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name of this Device Pool
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The device pool&#39;s description.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The device pool&#39;s description.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The number of devices that Device Farm can add to your device pool.
     * 
     */
    @Export(name="maxDevices", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maxDevices;

    /**
     * @return The number of devices that Device Farm can add to your device pool.
     * 
     */
    public Output<Optional<Integer>> maxDevices() {
        return Codegen.optional(this.maxDevices);
    }
    /**
     * The name of the Device Pool
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the Device Pool
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The ARN of the project for the device pool.
     * 
     */
    @Export(name="projectArn", refs={String.class}, tree="[0]")
    private Output<String> projectArn;

    /**
     * @return The ARN of the project for the device pool.
     * 
     */
    public Output<String> projectArn() {
        return this.projectArn;
    }
    /**
     * The device pool&#39;s rules. See Rule.
     * 
     */
    @Export(name="rules", refs={List.class,DevicePoolRule.class}, tree="[0,1]")
    private Output<List<DevicePoolRule>> rules;

    /**
     * @return The device pool&#39;s rules. See Rule.
     * 
     */
    public Output<List<DevicePoolRule>> rules() {
        return this.rules;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    public Output<String> type() {
        return this.type;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DevicePool(String name) {
        this(name, DevicePoolArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DevicePool(String name, DevicePoolArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DevicePool(String name, DevicePoolArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:devicefarm/devicePool:DevicePool", name, args == null ? DevicePoolArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DevicePool(String name, Output<String> id, @Nullable DevicePoolState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:devicefarm/devicePool:DevicePool", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DevicePool get(String name, Output<String> id, @Nullable DevicePoolState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DevicePool(name, id, state, options);
    }
}
