// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.detective;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.detective.InvitationAccepterArgs;
import com.pulumi.aws.detective.inputs.InvitationAccepterState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import com.pulumi.aws.detective.InvitationAccepter;
 * import com.pulumi.aws.detective.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var primaryGraph = new Graph(&#34;primaryGraph&#34;);
 * 
 *         var primaryMember = new Member(&#34;primaryMember&#34;, MemberArgs.builder()        
 *             .accountId(&#34;ACCOUNT ID&#34;)
 *             .emailAddress(&#34;EMAIL&#34;)
 *             .graphArn(primaryGraph.id())
 *             .message(&#34;Message of the invite&#34;)
 *             .build());
 * 
 *         var member = new InvitationAccepter(&#34;member&#34;, InvitationAccepterArgs.builder()        
 *             .graphArn(primaryGraph.graphArn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(&#34;awsalternate&#34;)
 *                 .dependsOn(primaryMember)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
 * ```
 * 
 */
@ResourceType(type="aws:detective/invitationAccepter:InvitationAccepter")
public class InvitationAccepter extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the behavior graph that the member account is accepting the invitation for.
     * 
     */
    @Export(name="graphArn", refs={String.class}, tree="[0]")
    private Output<String> graphArn;

    /**
     * @return ARN of the behavior graph that the member account is accepting the invitation for.
     * 
     */
    public Output<String> graphArn() {
        return this.graphArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public InvitationAccepter(String name) {
        this(name, InvitationAccepterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public InvitationAccepter(String name, InvitationAccepterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public InvitationAccepter(String name, InvitationAccepterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:detective/invitationAccepter:InvitationAccepter", name, args == null ? InvitationAccepterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private InvitationAccepter(String name, Output<String> id, @Nullable InvitationAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:detective/invitationAccepter:InvitationAccepter", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static InvitationAccepter get(String name, Output<String> id, @Nullable InvitationAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new InvitationAccepter(name, id, state, options);
    }
}
