// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync.inputs;

import com.pulumi.aws.datasync.inputs.TaskExcludesArgs;
import com.pulumi.aws.datasync.inputs.TaskIncludesArgs;
import com.pulumi.aws.datasync.inputs.TaskOptionsArgs;
import com.pulumi.aws.datasync.inputs.TaskScheduleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TaskState extends com.pulumi.resources.ResourceArgs {

    public static final TaskState Empty = new TaskState();

    /**
     * Amazon Resource Name (ARN) of the DataSync Task.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the DataSync Task.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
     * 
     */
    @Import(name="cloudwatchLogGroupArn")
    private @Nullable Output<String> cloudwatchLogGroupArn;

    /**
     * @return Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
     * 
     */
    public Optional<Output<String>> cloudwatchLogGroupArn() {
        return Optional.ofNullable(this.cloudwatchLogGroupArn);
    }

    /**
     * Amazon Resource Name (ARN) of destination DataSync Location.
     * 
     */
    @Import(name="destinationLocationArn")
    private @Nullable Output<String> destinationLocationArn;

    /**
     * @return Amazon Resource Name (ARN) of destination DataSync Location.
     * 
     */
    public Optional<Output<String>> destinationLocationArn() {
        return Optional.ofNullable(this.destinationLocationArn);
    }

    /**
     * Filter rules that determines which files to exclude from a task.
     * 
     */
    @Import(name="excludes")
    private @Nullable Output<TaskExcludesArgs> excludes;

    /**
     * @return Filter rules that determines which files to exclude from a task.
     * 
     */
    public Optional<Output<TaskExcludesArgs>> excludes() {
        return Optional.ofNullable(this.excludes);
    }

    /**
     * Filter rules that determines which files to include in a task.
     * 
     */
    @Import(name="includes")
    private @Nullable Output<TaskIncludesArgs> includes;

    /**
     * @return Filter rules that determines which files to include in a task.
     * 
     */
    public Optional<Output<TaskIncludesArgs>> includes() {
        return Optional.ofNullable(this.includes);
    }

    /**
     * Name of the DataSync Task.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the DataSync Task.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     * 
     */
    @Import(name="options")
    private @Nullable Output<TaskOptionsArgs> options;

    /**
     * @return Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     * 
     */
    public Optional<Output<TaskOptionsArgs>> options() {
        return Optional.ofNullable(this.options);
    }

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     * 
     */
    @Import(name="schedule")
    private @Nullable Output<TaskScheduleArgs> schedule;

    /**
     * @return Specifies a schedule used to periodically transfer files from a source to a destination location.
     * 
     */
    public Optional<Output<TaskScheduleArgs>> schedule() {
        return Optional.ofNullable(this.schedule);
    }

    /**
     * Amazon Resource Name (ARN) of source DataSync Location.
     * 
     */
    @Import(name="sourceLocationArn")
    private @Nullable Output<String> sourceLocationArn;

    /**
     * @return Amazon Resource Name (ARN) of source DataSync Location.
     * 
     */
    public Optional<Output<String>> sourceLocationArn() {
        return Optional.ofNullable(this.sourceLocationArn);
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private TaskState() {}

    private TaskState(TaskState $) {
        this.arn = $.arn;
        this.cloudwatchLogGroupArn = $.cloudwatchLogGroupArn;
        this.destinationLocationArn = $.destinationLocationArn;
        this.excludes = $.excludes;
        this.includes = $.includes;
        this.name = $.name;
        this.options = $.options;
        this.schedule = $.schedule;
        this.sourceLocationArn = $.sourceLocationArn;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TaskState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TaskState $;

        public Builder() {
            $ = new TaskState();
        }

        public Builder(TaskState defaults) {
            $ = new TaskState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the DataSync Task.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the DataSync Task.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param cloudwatchLogGroupArn Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
         * 
         * @return builder
         * 
         */
        public Builder cloudwatchLogGroupArn(@Nullable Output<String> cloudwatchLogGroupArn) {
            $.cloudwatchLogGroupArn = cloudwatchLogGroupArn;
            return this;
        }

        /**
         * @param cloudwatchLogGroupArn Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
         * 
         * @return builder
         * 
         */
        public Builder cloudwatchLogGroupArn(String cloudwatchLogGroupArn) {
            return cloudwatchLogGroupArn(Output.of(cloudwatchLogGroupArn));
        }

        /**
         * @param destinationLocationArn Amazon Resource Name (ARN) of destination DataSync Location.
         * 
         * @return builder
         * 
         */
        public Builder destinationLocationArn(@Nullable Output<String> destinationLocationArn) {
            $.destinationLocationArn = destinationLocationArn;
            return this;
        }

        /**
         * @param destinationLocationArn Amazon Resource Name (ARN) of destination DataSync Location.
         * 
         * @return builder
         * 
         */
        public Builder destinationLocationArn(String destinationLocationArn) {
            return destinationLocationArn(Output.of(destinationLocationArn));
        }

        /**
         * @param excludes Filter rules that determines which files to exclude from a task.
         * 
         * @return builder
         * 
         */
        public Builder excludes(@Nullable Output<TaskExcludesArgs> excludes) {
            $.excludes = excludes;
            return this;
        }

        /**
         * @param excludes Filter rules that determines which files to exclude from a task.
         * 
         * @return builder
         * 
         */
        public Builder excludes(TaskExcludesArgs excludes) {
            return excludes(Output.of(excludes));
        }

        /**
         * @param includes Filter rules that determines which files to include in a task.
         * 
         * @return builder
         * 
         */
        public Builder includes(@Nullable Output<TaskIncludesArgs> includes) {
            $.includes = includes;
            return this;
        }

        /**
         * @param includes Filter rules that determines which files to include in a task.
         * 
         * @return builder
         * 
         */
        public Builder includes(TaskIncludesArgs includes) {
            return includes(Output.of(includes));
        }

        /**
         * @param name Name of the DataSync Task.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the DataSync Task.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param options Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
         * 
         * @return builder
         * 
         */
        public Builder options(@Nullable Output<TaskOptionsArgs> options) {
            $.options = options;
            return this;
        }

        /**
         * @param options Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
         * 
         * @return builder
         * 
         */
        public Builder options(TaskOptionsArgs options) {
            return options(Output.of(options));
        }

        /**
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location.
         * 
         * @return builder
         * 
         */
        public Builder schedule(@Nullable Output<TaskScheduleArgs> schedule) {
            $.schedule = schedule;
            return this;
        }

        /**
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location.
         * 
         * @return builder
         * 
         */
        public Builder schedule(TaskScheduleArgs schedule) {
            return schedule(Output.of(schedule));
        }

        /**
         * @param sourceLocationArn Amazon Resource Name (ARN) of source DataSync Location.
         * 
         * @return builder
         * 
         */
        public Builder sourceLocationArn(@Nullable Output<String> sourceLocationArn) {
            $.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * @param sourceLocationArn Amazon Resource Name (ARN) of source DataSync Location.
         * 
         * @return builder
         * 
         */
        public Builder sourceLocationArn(String sourceLocationArn) {
            return sourceLocationArn(Output.of(sourceLocationArn));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public TaskState build() {
            return $;
        }
    }

}
