// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.datasync.S3LocationArgs;
import com.pulumi.aws.datasync.inputs.S3LocationState;
import com.pulumi.aws.datasync.outputs.S3LocationS3Config;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an S3 Location within AWS DataSync.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.S3Location;
 * import com.pulumi.aws.datasync.S3LocationArgs;
 * import com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new S3Location(&#34;example&#34;, S3LocationArgs.builder()        
 *             .s3BucketArn(aws_s3_bucket.example().arn())
 *             .subdirectory(&#34;/example/prefix&#34;)
 *             .s3Config(S3LocationS3ConfigArgs.builder()
 *                 .bucketAccessRoleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_datasync_location_s3` using the DataSync Task Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:datasync/s3Location:S3Location example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * 
 */
@ResourceType(type="aws:datasync/s3Location:S3Location")
public class S3Location extends com.pulumi.resources.CustomResource {
    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    @Export(name="agentArns", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> agentArns;

    /**
     * @return A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    public Output<Optional<List<String>>> agentArns() {
        return Codegen.optional(this.agentArns);
    }
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Amazon Resource Name (ARN) of the S3 Bucket.
     * 
     */
    @Export(name="s3BucketArn", refs={String.class}, tree="[0]")
    private Output<String> s3BucketArn;

    /**
     * @return Amazon Resource Name (ARN) of the S3 Bucket.
     * 
     */
    public Output<String> s3BucketArn() {
        return this.s3BucketArn;
    }
    /**
     * Configuration block containing information for connecting to S3.
     * 
     */
    @Export(name="s3Config", refs={S3LocationS3Config.class}, tree="[0]")
    private Output<S3LocationS3Config> s3Config;

    /**
     * @return Configuration block containing information for connecting to S3.
     * 
     */
    public Output<S3LocationS3Config> s3Config() {
        return this.s3Config;
    }
    /**
     * The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     * 
     */
    @Export(name="s3StorageClass", refs={String.class}, tree="[0]")
    private Output<String> s3StorageClass;

    /**
     * @return The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     * 
     */
    public Output<String> s3StorageClass() {
        return this.s3StorageClass;
    }
    /**
     * Prefix to perform actions as source or destination.
     * 
     */
    @Export(name="subdirectory", refs={String.class}, tree="[0]")
    private Output<String> subdirectory;

    /**
     * @return Prefix to perform actions as source or destination.
     * 
     */
    public Output<String> subdirectory() {
        return this.subdirectory;
    }
    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    @Export(name="uri", refs={String.class}, tree="[0]")
    private Output<String> uri;

    public Output<String> uri() {
        return this.uri;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public S3Location(String name) {
        this(name, S3LocationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public S3Location(String name, S3LocationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public S3Location(String name, S3LocationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/s3Location:S3Location", name, args == null ? S3LocationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private S3Location(String name, Output<String> id, @Nullable S3LocationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/s3Location:S3Location", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static S3Location get(String name, Output<String> id, @Nullable S3LocationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new S3Location(name, id, state, options);
    }
}
