// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.datasync.inputs.LocationSmbMountOptionsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LocationSmbArgs extends com.pulumi.resources.ResourceArgs {

    public static final LocationSmbArgs Empty = new LocationSmbArgs();

    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    @Import(name="agentArns", required=true)
    private Output<List<String>> agentArns;

    /**
     * @return A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    public Output<List<String>> agentArns() {
        return this.agentArns;
    }

    /**
     * The name of the Windows domain the SMB server belongs to.
     * 
     */
    @Import(name="domain")
    private @Nullable Output<String> domain;

    /**
     * @return The name of the Windows domain the SMB server belongs to.
     * 
     */
    public Optional<Output<String>> domain() {
        return Optional.ofNullable(this.domain);
    }

    /**
     * Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     * 
     */
    @Import(name="mountOptions")
    private @Nullable Output<LocationSmbMountOptionsArgs> mountOptions;

    /**
     * @return Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     * 
     */
    public Optional<Output<LocationSmbMountOptionsArgs>> mountOptions() {
        return Optional.ofNullable(this.mountOptions);
    }

    /**
     * The password of the user who can mount the share and has file permissions in the SMB.
     * 
     */
    @Import(name="password", required=true)
    private Output<String> password;

    /**
     * @return The password of the user who can mount the share and has file permissions in the SMB.
     * 
     */
    public Output<String> password() {
        return this.password;
    }

    /**
     * Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     * 
     */
    @Import(name="serverHostname", required=true)
    private Output<String> serverHostname;

    /**
     * @return Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     * 
     */
    public Output<String> serverHostname() {
        return this.serverHostname;
    }

    /**
     * Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     * 
     */
    @Import(name="subdirectory", required=true)
    private Output<String> subdirectory;

    /**
     * @return Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     * 
     */
    public Output<String> subdirectory() {
        return this.subdirectory;
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The user who can mount the share and has file and folder permissions in the SMB share.
     * 
     */
    @Import(name="user", required=true)
    private Output<String> user;

    /**
     * @return The user who can mount the share and has file and folder permissions in the SMB share.
     * 
     */
    public Output<String> user() {
        return this.user;
    }

    private LocationSmbArgs() {}

    private LocationSmbArgs(LocationSmbArgs $) {
        this.agentArns = $.agentArns;
        this.domain = $.domain;
        this.mountOptions = $.mountOptions;
        this.password = $.password;
        this.serverHostname = $.serverHostname;
        this.subdirectory = $.subdirectory;
        this.tags = $.tags;
        this.user = $.user;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LocationSmbArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LocationSmbArgs $;

        public Builder() {
            $ = new LocationSmbArgs();
        }

        public Builder(LocationSmbArgs defaults) {
            $ = new LocationSmbArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(Output<List<String>> agentArns) {
            $.agentArns = agentArns;
            return this;
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(List<String> agentArns) {
            return agentArns(Output.of(agentArns));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(String... agentArns) {
            return agentArns(List.of(agentArns));
        }

        /**
         * @param domain The name of the Windows domain the SMB server belongs to.
         * 
         * @return builder
         * 
         */
        public Builder domain(@Nullable Output<String> domain) {
            $.domain = domain;
            return this;
        }

        /**
         * @param domain The name of the Windows domain the SMB server belongs to.
         * 
         * @return builder
         * 
         */
        public Builder domain(String domain) {
            return domain(Output.of(domain));
        }

        /**
         * @param mountOptions Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
         * 
         * @return builder
         * 
         */
        public Builder mountOptions(@Nullable Output<LocationSmbMountOptionsArgs> mountOptions) {
            $.mountOptions = mountOptions;
            return this;
        }

        /**
         * @param mountOptions Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
         * 
         * @return builder
         * 
         */
        public Builder mountOptions(LocationSmbMountOptionsArgs mountOptions) {
            return mountOptions(Output.of(mountOptions));
        }

        /**
         * @param password The password of the user who can mount the share and has file permissions in the SMB.
         * 
         * @return builder
         * 
         */
        public Builder password(Output<String> password) {
            $.password = password;
            return this;
        }

        /**
         * @param password The password of the user who can mount the share and has file permissions in the SMB.
         * 
         * @return builder
         * 
         */
        public Builder password(String password) {
            return password(Output.of(password));
        }

        /**
         * @param serverHostname Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
         * 
         * @return builder
         * 
         */
        public Builder serverHostname(Output<String> serverHostname) {
            $.serverHostname = serverHostname;
            return this;
        }

        /**
         * @param serverHostname Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
         * 
         * @return builder
         * 
         */
        public Builder serverHostname(String serverHostname) {
            return serverHostname(Output.of(serverHostname));
        }

        /**
         * @param subdirectory Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(Output<String> subdirectory) {
            $.subdirectory = subdirectory;
            return this;
        }

        /**
         * @param subdirectory Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(String subdirectory) {
            return subdirectory(Output.of(subdirectory));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param user The user who can mount the share and has file and folder permissions in the SMB share.
         * 
         * @return builder
         * 
         */
        public Builder user(Output<String> user) {
            $.user = user;
            return this;
        }

        /**
         * @param user The user who can mount the share and has file and folder permissions in the SMB share.
         * 
         * @return builder
         * 
         */
        public Builder user(String user) {
            return user(Output.of(user));
        }

        public LocationSmbArgs build() {
            $.agentArns = Objects.requireNonNull($.agentArns, "expected parameter 'agentArns' to be non-null");
            $.password = Objects.requireNonNull($.password, "expected parameter 'password' to be non-null");
            $.serverHostname = Objects.requireNonNull($.serverHostname, "expected parameter 'serverHostname' to be non-null");
            $.subdirectory = Objects.requireNonNull($.subdirectory, "expected parameter 'subdirectory' to be non-null");
            $.user = Objects.requireNonNull($.user, "expected parameter 'user' to be non-null");
            return $;
        }
    }

}
