// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LocationObjectStorageArgs extends com.pulumi.resources.ResourceArgs {

    public static final LocationObjectStorageArgs Empty = new LocationObjectStorageArgs();

    /**
     * The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     * 
     */
    @Import(name="accessKey")
    private @Nullable Output<String> accessKey;

    /**
     * @return The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     * 
     */
    public Optional<Output<String>> accessKey() {
        return Optional.ofNullable(this.accessKey);
    }

    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    @Import(name="agentArns", required=true)
    private Output<List<String>> agentArns;

    /**
     * @return A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    public Output<List<String>> agentArns() {
        return this.agentArns;
    }

    /**
     * The bucket on the self-managed object storage server that is used to read data from.
     * 
     */
    @Import(name="bucketName", required=true)
    private Output<String> bucketName;

    /**
     * @return The bucket on the self-managed object storage server that is used to read data from.
     * 
     */
    public Output<String> bucketName() {
        return this.bucketName;
    }

    /**
     * The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     * 
     */
    @Import(name="secretKey")
    private @Nullable Output<String> secretKey;

    /**
     * @return The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     * 
     */
    public Optional<Output<String>> secretKey() {
        return Optional.ofNullable(this.secretKey);
    }

    /**
     * Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
     * 
     */
    @Import(name="serverCertificate")
    private @Nullable Output<String> serverCertificate;

    /**
     * @return Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
     * 
     */
    public Optional<Output<String>> serverCertificate() {
        return Optional.ofNullable(this.serverCertificate);
    }

    /**
     * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     * 
     */
    @Import(name="serverHostname", required=true)
    private Output<String> serverHostname;

    /**
     * @return The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     * 
     */
    public Output<String> serverHostname() {
        return this.serverHostname;
    }

    /**
     * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
     * 
     */
    @Import(name="serverPort")
    private @Nullable Output<Integer> serverPort;

    /**
     * @return The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
     * 
     */
    public Optional<Output<Integer>> serverPort() {
        return Optional.ofNullable(this.serverPort);
    }

    /**
     * The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
     * 
     */
    @Import(name="serverProtocol")
    private @Nullable Output<String> serverProtocol;

    /**
     * @return The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
     * 
     */
    public Optional<Output<String>> serverProtocol() {
        return Optional.ofNullable(this.serverProtocol);
    }

    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
     * 
     */
    @Import(name="subdirectory")
    private @Nullable Output<String> subdirectory;

    /**
     * @return A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
     * 
     */
    public Optional<Output<String>> subdirectory() {
        return Optional.ofNullable(this.subdirectory);
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private LocationObjectStorageArgs() {}

    private LocationObjectStorageArgs(LocationObjectStorageArgs $) {
        this.accessKey = $.accessKey;
        this.agentArns = $.agentArns;
        this.bucketName = $.bucketName;
        this.secretKey = $.secretKey;
        this.serverCertificate = $.serverCertificate;
        this.serverHostname = $.serverHostname;
        this.serverPort = $.serverPort;
        this.serverProtocol = $.serverProtocol;
        this.subdirectory = $.subdirectory;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LocationObjectStorageArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LocationObjectStorageArgs $;

        public Builder() {
            $ = new LocationObjectStorageArgs();
        }

        public Builder(LocationObjectStorageArgs defaults) {
            $ = new LocationObjectStorageArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessKey The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(@Nullable Output<String> accessKey) {
            $.accessKey = accessKey;
            return this;
        }

        /**
         * @param accessKey The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
         * 
         * @return builder
         * 
         */
        public Builder accessKey(String accessKey) {
            return accessKey(Output.of(accessKey));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(Output<List<String>> agentArns) {
            $.agentArns = agentArns;
            return this;
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(List<String> agentArns) {
            return agentArns(Output.of(agentArns));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(String... agentArns) {
            return agentArns(List.of(agentArns));
        }

        /**
         * @param bucketName The bucket on the self-managed object storage server that is used to read data from.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(Output<String> bucketName) {
            $.bucketName = bucketName;
            return this;
        }

        /**
         * @param bucketName The bucket on the self-managed object storage server that is used to read data from.
         * 
         * @return builder
         * 
         */
        public Builder bucketName(String bucketName) {
            return bucketName(Output.of(bucketName));
        }

        /**
         * @param secretKey The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
         * 
         * @return builder
         * 
         */
        public Builder secretKey(@Nullable Output<String> secretKey) {
            $.secretKey = secretKey;
            return this;
        }

        /**
         * @param secretKey The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
         * 
         * @return builder
         * 
         */
        public Builder secretKey(String secretKey) {
            return secretKey(Output.of(secretKey));
        }

        /**
         * @param serverCertificate Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
         * 
         * @return builder
         * 
         */
        public Builder serverCertificate(@Nullable Output<String> serverCertificate) {
            $.serverCertificate = serverCertificate;
            return this;
        }

        /**
         * @param serverCertificate Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
         * 
         * @return builder
         * 
         */
        public Builder serverCertificate(String serverCertificate) {
            return serverCertificate(Output.of(serverCertificate));
        }

        /**
         * @param serverHostname The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
         * 
         * @return builder
         * 
         */
        public Builder serverHostname(Output<String> serverHostname) {
            $.serverHostname = serverHostname;
            return this;
        }

        /**
         * @param serverHostname The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
         * 
         * @return builder
         * 
         */
        public Builder serverHostname(String serverHostname) {
            return serverHostname(Output.of(serverHostname));
        }

        /**
         * @param serverPort The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
         * 
         * @return builder
         * 
         */
        public Builder serverPort(@Nullable Output<Integer> serverPort) {
            $.serverPort = serverPort;
            return this;
        }

        /**
         * @param serverPort The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
         * 
         * @return builder
         * 
         */
        public Builder serverPort(Integer serverPort) {
            return serverPort(Output.of(serverPort));
        }

        /**
         * @param serverProtocol The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
         * 
         * @return builder
         * 
         */
        public Builder serverProtocol(@Nullable Output<String> serverProtocol) {
            $.serverProtocol = serverProtocol;
            return this;
        }

        /**
         * @param serverProtocol The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
         * 
         * @return builder
         * 
         */
        public Builder serverProtocol(String serverProtocol) {
            return serverProtocol(Output.of(serverProtocol));
        }

        /**
         * @param subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(@Nullable Output<String> subdirectory) {
            $.subdirectory = subdirectory;
            return this;
        }

        /**
         * @param subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(String subdirectory) {
            return subdirectory(Output.of(subdirectory));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public LocationObjectStorageArgs build() {
            $.agentArns = Objects.requireNonNull($.agentArns, "expected parameter 'agentArns' to be non-null");
            $.bucketName = Objects.requireNonNull($.bucketName, "expected parameter 'bucketName' to be non-null");
            $.serverHostname = Objects.requireNonNull($.serverHostname, "expected parameter 'serverHostname' to be non-null");
            return $;
        }
    }

}
