// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs;
import com.pulumi.aws.datasync.inputs.LocationHdfsQopConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LocationHdfsArgs extends com.pulumi.resources.ResourceArgs {

    public static final LocationHdfsArgs Empty = new LocationHdfsArgs();

    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    @Import(name="agentArns", required=true)
    private Output<List<String>> agentArns;

    /**
     * @return A list of DataSync Agent ARNs with which this location will be associated.
     * 
     */
    public Output<List<String>> agentArns() {
        return this.agentArns;
    }

    /**
     * The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     * 
     */
    @Import(name="authenticationType")
    private @Nullable Output<String> authenticationType;

    /**
     * @return The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     * 
     */
    public Optional<Output<String>> authenticationType() {
        return Optional.ofNullable(this.authenticationType);
    }

    /**
     * The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     * 
     */
    @Import(name="blockSize")
    private @Nullable Output<Integer> blockSize;

    /**
     * @return The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     * 
     */
    public Optional<Output<Integer>> blockSize() {
        return Optional.ofNullable(this.blockSize);
    }

    /**
     * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    @Import(name="kerberosKeytab")
    private @Nullable Output<String> kerberosKeytab;

    /**
     * @return The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    public Optional<Output<String>> kerberosKeytab() {
        return Optional.ofNullable(this.kerberosKeytab);
    }

    /**
     * The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    @Import(name="kerberosKrb5Conf")
    private @Nullable Output<String> kerberosKrb5Conf;

    /**
     * @return The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    public Optional<Output<String>> kerberosKrb5Conf() {
        return Optional.ofNullable(this.kerberosKrb5Conf);
    }

    /**
     * The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    @Import(name="kerberosPrincipal")
    private @Nullable Output<String> kerberosPrincipal;

    /**
     * @return The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     * 
     */
    public Optional<Output<String>> kerberosPrincipal() {
        return Optional.ofNullable(this.kerberosPrincipal);
    }

    /**
     * The URI of the HDFS cluster&#39;s Key Management Server (KMS).
     * 
     */
    @Import(name="kmsKeyProviderUri")
    private @Nullable Output<String> kmsKeyProviderUri;

    /**
     * @return The URI of the HDFS cluster&#39;s Key Management Server (KMS).
     * 
     */
    public Optional<Output<String>> kmsKeyProviderUri() {
        return Optional.ofNullable(this.kmsKeyProviderUri);
    }

    /**
     * The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     * 
     */
    @Import(name="nameNodes", required=true)
    private Output<List<LocationHdfsNameNodeArgs>> nameNodes;

    /**
     * @return The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     * 
     */
    public Output<List<LocationHdfsNameNodeArgs>> nameNodes() {
        return this.nameNodes;
    }

    /**
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn&#39;t specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     * 
     */
    @Import(name="qopConfiguration")
    private @Nullable Output<LocationHdfsQopConfigurationArgs> qopConfiguration;

    /**
     * @return The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn&#39;t specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     * 
     */
    public Optional<Output<LocationHdfsQopConfigurationArgs>> qopConfiguration() {
        return Optional.ofNullable(this.qopConfiguration);
    }

    /**
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     * 
     */
    @Import(name="replicationFactor")
    private @Nullable Output<Integer> replicationFactor;

    /**
     * @return The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     * 
     */
    public Optional<Output<Integer>> replicationFactor() {
        return Optional.ofNullable(this.replicationFactor);
    }

    /**
     * The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     * 
     */
    @Import(name="simpleUser")
    private @Nullable Output<String> simpleUser;

    /**
     * @return The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     * 
     */
    public Optional<Output<String>> simpleUser() {
        return Optional.ofNullable(this.simpleUser);
    }

    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
     * 
     */
    @Import(name="subdirectory")
    private @Nullable Output<String> subdirectory;

    /**
     * @return A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
     * 
     */
    public Optional<Output<String>> subdirectory() {
        return Optional.ofNullable(this.subdirectory);
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private LocationHdfsArgs() {}

    private LocationHdfsArgs(LocationHdfsArgs $) {
        this.agentArns = $.agentArns;
        this.authenticationType = $.authenticationType;
        this.blockSize = $.blockSize;
        this.kerberosKeytab = $.kerberosKeytab;
        this.kerberosKrb5Conf = $.kerberosKrb5Conf;
        this.kerberosPrincipal = $.kerberosPrincipal;
        this.kmsKeyProviderUri = $.kmsKeyProviderUri;
        this.nameNodes = $.nameNodes;
        this.qopConfiguration = $.qopConfiguration;
        this.replicationFactor = $.replicationFactor;
        this.simpleUser = $.simpleUser;
        this.subdirectory = $.subdirectory;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LocationHdfsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LocationHdfsArgs $;

        public Builder() {
            $ = new LocationHdfsArgs();
        }

        public Builder(LocationHdfsArgs defaults) {
            $ = new LocationHdfsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(Output<List<String>> agentArns) {
            $.agentArns = agentArns;
            return this;
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(List<String> agentArns) {
            return agentArns(Output.of(agentArns));
        }

        /**
         * @param agentArns A list of DataSync Agent ARNs with which this location will be associated.
         * 
         * @return builder
         * 
         */
        public Builder agentArns(String... agentArns) {
            return agentArns(List.of(agentArns));
        }

        /**
         * @param authenticationType The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
         * 
         * @return builder
         * 
         */
        public Builder authenticationType(@Nullable Output<String> authenticationType) {
            $.authenticationType = authenticationType;
            return this;
        }

        /**
         * @param authenticationType The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
         * 
         * @return builder
         * 
         */
        public Builder authenticationType(String authenticationType) {
            return authenticationType(Output.of(authenticationType));
        }

        /**
         * @param blockSize The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
         * 
         * @return builder
         * 
         */
        public Builder blockSize(@Nullable Output<Integer> blockSize) {
            $.blockSize = blockSize;
            return this;
        }

        /**
         * @param blockSize The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
         * 
         * @return builder
         * 
         */
        public Builder blockSize(Integer blockSize) {
            return blockSize(Output.of(blockSize));
        }

        /**
         * @param kerberosKeytab The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosKeytab(@Nullable Output<String> kerberosKeytab) {
            $.kerberosKeytab = kerberosKeytab;
            return this;
        }

        /**
         * @param kerberosKeytab The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosKeytab(String kerberosKeytab) {
            return kerberosKeytab(Output.of(kerberosKeytab));
        }

        /**
         * @param kerberosKrb5Conf The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosKrb5Conf(@Nullable Output<String> kerberosKrb5Conf) {
            $.kerberosKrb5Conf = kerberosKrb5Conf;
            return this;
        }

        /**
         * @param kerberosKrb5Conf The krb5.conf file that contains the Kerberos configuration information. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosKrb5Conf(String kerberosKrb5Conf) {
            return kerberosKrb5Conf(Output.of(kerberosKrb5Conf));
        }

        /**
         * @param kerberosPrincipal The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosPrincipal(@Nullable Output<String> kerberosPrincipal) {
            $.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        /**
         * @param kerberosPrincipal The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder kerberosPrincipal(String kerberosPrincipal) {
            return kerberosPrincipal(Output.of(kerberosPrincipal));
        }

        /**
         * @param kmsKeyProviderUri The URI of the HDFS cluster&#39;s Key Management Server (KMS).
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyProviderUri(@Nullable Output<String> kmsKeyProviderUri) {
            $.kmsKeyProviderUri = kmsKeyProviderUri;
            return this;
        }

        /**
         * @param kmsKeyProviderUri The URI of the HDFS cluster&#39;s Key Management Server (KMS).
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyProviderUri(String kmsKeyProviderUri) {
            return kmsKeyProviderUri(Output.of(kmsKeyProviderUri));
        }

        /**
         * @param nameNodes The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
         * 
         * @return builder
         * 
         */
        public Builder nameNodes(Output<List<LocationHdfsNameNodeArgs>> nameNodes) {
            $.nameNodes = nameNodes;
            return this;
        }

        /**
         * @param nameNodes The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
         * 
         * @return builder
         * 
         */
        public Builder nameNodes(List<LocationHdfsNameNodeArgs> nameNodes) {
            return nameNodes(Output.of(nameNodes));
        }

        /**
         * @param nameNodes The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
         * 
         * @return builder
         * 
         */
        public Builder nameNodes(LocationHdfsNameNodeArgs... nameNodes) {
            return nameNodes(List.of(nameNodes));
        }

        /**
         * @param qopConfiguration The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn&#39;t specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
         * 
         * @return builder
         * 
         */
        public Builder qopConfiguration(@Nullable Output<LocationHdfsQopConfigurationArgs> qopConfiguration) {
            $.qopConfiguration = qopConfiguration;
            return this;
        }

        /**
         * @param qopConfiguration The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn&#39;t specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
         * 
         * @return builder
         * 
         */
        public Builder qopConfiguration(LocationHdfsQopConfigurationArgs qopConfiguration) {
            return qopConfiguration(Output.of(qopConfiguration));
        }

        /**
         * @param replicationFactor The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
         * 
         * @return builder
         * 
         */
        public Builder replicationFactor(@Nullable Output<Integer> replicationFactor) {
            $.replicationFactor = replicationFactor;
            return this;
        }

        /**
         * @param replicationFactor The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
         * 
         * @return builder
         * 
         */
        public Builder replicationFactor(Integer replicationFactor) {
            return replicationFactor(Output.of(replicationFactor));
        }

        /**
         * @param simpleUser The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder simpleUser(@Nullable Output<String> simpleUser) {
            $.simpleUser = simpleUser;
            return this;
        }

        /**
         * @param simpleUser The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
         * 
         * @return builder
         * 
         */
        public Builder simpleUser(String simpleUser) {
            return simpleUser(Output.of(simpleUser));
        }

        /**
         * @param subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(@Nullable Output<String> subdirectory) {
            $.subdirectory = subdirectory;
            return this;
        }

        /**
         * @param subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn&#39;t specified, it will default to /.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(String subdirectory) {
            return subdirectory(Output.of(subdirectory));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public LocationHdfsArgs build() {
            $.agentArns = Objects.requireNonNull($.agentArns, "expected parameter 'agentArns' to be non-null");
            $.nameNodes = Objects.requireNonNull($.nameNodes, "expected parameter 'nameNodes' to be non-null");
            return $;
        }
    }

}
