// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LocationFsxOntapFileSystemArgs extends com.pulumi.resources.ResourceArgs {

    public static final LocationFsxOntapFileSystemArgs Empty = new LocationFsxOntapFileSystemArgs();

    /**
     * The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     * 
     */
    @Import(name="protocol", required=true)
    private Output<LocationFsxOntapFileSystemProtocolArgs> protocol;

    /**
     * @return The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     * 
     */
    public Output<LocationFsxOntapFileSystemProtocolArgs> protocol() {
        return this.protocol;
    }

    /**
     * The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     * 
     */
    @Import(name="securityGroupArns", required=true)
    private Output<List<String>> securityGroupArns;

    /**
     * @return The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     * 
     */
    public Output<List<String>> securityGroupArns() {
        return this.securityGroupArns;
    }

    /**
     * The ARN of the SVM in your file system where you want to copy data to of from.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="storageVirtualMachineArn", required=true)
    private Output<String> storageVirtualMachineArn;

    /**
     * @return The ARN of the SVM in your file system where you want to copy data to of from.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> storageVirtualMachineArn() {
        return this.storageVirtualMachineArn;
    }

    /**
     * Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     * 
     */
    @Import(name="subdirectory")
    private @Nullable Output<String> subdirectory;

    /**
     * @return Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     * 
     */
    public Optional<Output<String>> subdirectory() {
        return Optional.ofNullable(this.subdirectory);
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private LocationFsxOntapFileSystemArgs() {}

    private LocationFsxOntapFileSystemArgs(LocationFsxOntapFileSystemArgs $) {
        this.protocol = $.protocol;
        this.securityGroupArns = $.securityGroupArns;
        this.storageVirtualMachineArn = $.storageVirtualMachineArn;
        this.subdirectory = $.subdirectory;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LocationFsxOntapFileSystemArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LocationFsxOntapFileSystemArgs $;

        public Builder() {
            $ = new LocationFsxOntapFileSystemArgs();
        }

        public Builder(LocationFsxOntapFileSystemArgs defaults) {
            $ = new LocationFsxOntapFileSystemArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param protocol The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Output<LocationFsxOntapFileSystemProtocolArgs> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
         * 
         * @return builder
         * 
         */
        public Builder protocol(LocationFsxOntapFileSystemProtocolArgs protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param securityGroupArns The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
         * * Network File System (NFS): TCP ports 111, 635, and 2049
         * * Server Message Block (SMB): TCP port 445
         * 
         * @return builder
         * 
         */
        public Builder securityGroupArns(Output<List<String>> securityGroupArns) {
            $.securityGroupArns = securityGroupArns;
            return this;
        }

        /**
         * @param securityGroupArns The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
         * * Network File System (NFS): TCP ports 111, 635, and 2049
         * * Server Message Block (SMB): TCP port 445
         * 
         * @return builder
         * 
         */
        public Builder securityGroupArns(List<String> securityGroupArns) {
            return securityGroupArns(Output.of(securityGroupArns));
        }

        /**
         * @param securityGroupArns The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
         * * Network File System (NFS): TCP ports 111, 635, and 2049
         * * Server Message Block (SMB): TCP port 445
         * 
         * @return builder
         * 
         */
        public Builder securityGroupArns(String... securityGroupArns) {
            return securityGroupArns(List.of(securityGroupArns));
        }

        /**
         * @param storageVirtualMachineArn The ARN of the SVM in your file system where you want to copy data to of from.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder storageVirtualMachineArn(Output<String> storageVirtualMachineArn) {
            $.storageVirtualMachineArn = storageVirtualMachineArn;
            return this;
        }

        /**
         * @param storageVirtualMachineArn The ARN of the SVM in your file system where you want to copy data to of from.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder storageVirtualMachineArn(String storageVirtualMachineArn) {
            return storageVirtualMachineArn(Output.of(storageVirtualMachineArn));
        }

        /**
         * @param subdirectory Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(@Nullable Output<String> subdirectory) {
            $.subdirectory = subdirectory;
            return this;
        }

        /**
         * @param subdirectory Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(String subdirectory) {
            return subdirectory(Output.of(subdirectory));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public LocationFsxOntapFileSystemArgs build() {
            $.protocol = Objects.requireNonNull($.protocol, "expected parameter 'protocol' to be non-null");
            $.securityGroupArns = Objects.requireNonNull($.securityGroupArns, "expected parameter 'securityGroupArns' to be non-null");
            $.storageVirtualMachineArn = Objects.requireNonNull($.storageVirtualMachineArn, "expected parameter 'storageVirtualMachineArn' to be non-null");
            return $;
        }
    }

}
