// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs;
import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemState;
import com.pulumi.aws.datasync.outputs.LocationFsxOntapFileSystemProtocol;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS DataSync Location FSx Ontap File System.
 * 
 * ## Example Usage
 * ### Basic Usage
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxOntapFileSystem;
 * import com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new LocationFsxOntapFileSystem(&#34;test&#34;, LocationFsxOntapFileSystemArgs.builder()        
 *             .fsxFilesystemArn(aws_fsx_ontap_file_system.test().arn())
 *             .securityGroupArns(aws_security_group.test().arn())
 *             .storageVirtualMachineArn(aws_fsx_ontap_storage_virtual_machine.test().arn())
 *             .protocol(LocationFsxOntapFileSystemProtocolArgs.builder()
 *                 .nfs(LocationFsxOntapFileSystemProtocolNfsArgs.builder()
 *                     .mountOptions(LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs.builder()
 *                         .version(&#34;NFS3&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import `aws_datasync_location_fsx_ontap_file_system` using the `DataSync-ARN#FSx-ontap-svm-ARN`. For exampleterraform import {
 * 
 *  to = aws_datasync_location_fsx_ontap_file_system.example
 * 
 *  id = &#34;arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:storage-virtual-machine/svm-12345678abcdef123&#34; } Using `TODO import`, import `aws_datasync_location_fsx_ontap_file_system` using the `DataSync-ARN#FSx-ontap-svm-ARN`. For exampleconsole % TODO import aws_datasync_location_fsx_ontap_file_system.example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:storage-virtual-machine/svm-12345678abcdef123
 * 
 */
@ResourceType(type="aws:datasync/locationFsxOntapFileSystem:LocationFsxOntapFileSystem")
public class LocationFsxOntapFileSystem extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the DataSync Location for the FSx Ontap File System.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the DataSync Location for the FSx Ontap File System.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    @Export(name="creationTime", refs={String.class}, tree="[0]")
    private Output<String> creationTime;

    public Output<String> creationTime() {
        return this.creationTime;
    }
    /**
     * ARN of the FSx Ontap File System.
     * 
     */
    @Export(name="fsxFilesystemArn", refs={String.class}, tree="[0]")
    private Output<String> fsxFilesystemArn;

    /**
     * @return ARN of the FSx Ontap File System.
     * 
     */
    public Output<String> fsxFilesystemArn() {
        return this.fsxFilesystemArn;
    }
    /**
     * The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     * 
     */
    @Export(name="protocol", refs={LocationFsxOntapFileSystemProtocol.class}, tree="[0]")
    private Output<LocationFsxOntapFileSystemProtocol> protocol;

    /**
     * @return The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     * 
     */
    public Output<LocationFsxOntapFileSystemProtocol> protocol() {
        return this.protocol;
    }
    /**
     * The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     * 
     */
    @Export(name="securityGroupArns", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroupArns;

    /**
     * @return The security groups that provide access to your file system&#39;s preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     * 
     */
    public Output<List<String>> securityGroupArns() {
        return this.securityGroupArns;
    }
    /**
     * The ARN of the SVM in your file system where you want to copy data to of from.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="storageVirtualMachineArn", refs={String.class}, tree="[0]")
    private Output<String> storageVirtualMachineArn;

    /**
     * @return The ARN of the SVM in your file system where you want to copy data to of from.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> storageVirtualMachineArn() {
        return this.storageVirtualMachineArn;
    }
    /**
     * Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     * 
     */
    @Export(name="subdirectory", refs={String.class}, tree="[0]")
    private Output<String> subdirectory;

    /**
     * @return Path to the file share in the SVM where you&#39;ll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     * 
     */
    public Output<String> subdirectory() {
        return this.subdirectory;
    }
    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * URI of the FSx ONTAP file system location
     * 
     */
    @Export(name="uri", refs={String.class}, tree="[0]")
    private Output<String> uri;

    /**
     * @return URI of the FSx ONTAP file system location
     * 
     */
    public Output<String> uri() {
        return this.uri;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LocationFsxOntapFileSystem(String name) {
        this(name, LocationFsxOntapFileSystemArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LocationFsxOntapFileSystem(String name, LocationFsxOntapFileSystemArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LocationFsxOntapFileSystem(String name, LocationFsxOntapFileSystemArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/locationFsxOntapFileSystem:LocationFsxOntapFileSystem", name, args == null ? LocationFsxOntapFileSystemArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LocationFsxOntapFileSystem(String name, Output<String> id, @Nullable LocationFsxOntapFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/locationFsxOntapFileSystem:LocationFsxOntapFileSystem", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LocationFsxOntapFileSystem get(String name, Output<String> id, @Nullable LocationFsxOntapFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LocationFsxOntapFileSystem(name, id, state, options);
    }
}
