// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs;
import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemState;
import com.pulumi.aws.datasync.outputs.FsxOpenZfsFileSystemProtocol;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an AWS DataSync FSx OpenZfs Location.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystem;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new FsxOpenZfsFileSystem(&#34;example&#34;, FsxOpenZfsFileSystemArgs.builder()        
 *             .fsxFilesystemArn(aws_fsx_openzfs_file_system.example().arn())
 *             .securityGroupArns(aws_security_group.example().arn())
 *             .protocol(FsxOpenZfsFileSystemProtocolArgs.builder()
 *                 .nfs(FsxOpenZfsFileSystemProtocolNfsArgs.builder()
 *                     .mountOptions(FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs.builder()
 *                         .version(&#34;AUTOMATIC&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_datasync_location_fsx_openzfs_file_system` using the `DataSync-ARN#FSx-openzfs-ARN`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:file-system/fs-08e04cd442c1bb94a
 * ```
 * 
 */
@ResourceType(type="aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem")
public class FsxOpenZfsFileSystem extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The time that the FSx for openzfs location was created.
     * 
     */
    @Export(name="creationTime", refs={String.class}, tree="[0]")
    private Output<String> creationTime;

    /**
     * @return The time that the FSx for openzfs location was created.
     * 
     */
    public Output<String> creationTime() {
        return this.creationTime;
    }
    /**
     * The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
     * 
     */
    @Export(name="fsxFilesystemArn", refs={String.class}, tree="[0]")
    private Output<String> fsxFilesystemArn;

    /**
     * @return The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
     * 
     */
    public Output<String> fsxFilesystemArn() {
        return this.fsxFilesystemArn;
    }
    /**
     * The type of protocol that DataSync uses to access your file system. See below.
     * 
     */
    @Export(name="protocol", refs={FsxOpenZfsFileSystemProtocol.class}, tree="[0]")
    private Output<FsxOpenZfsFileSystemProtocol> protocol;

    /**
     * @return The type of protocol that DataSync uses to access your file system. See below.
     * 
     */
    public Output<FsxOpenZfsFileSystemProtocol> protocol() {
        return this.protocol;
    }
    /**
     * The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     * 
     */
    @Export(name="securityGroupArns", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroupArns;

    /**
     * @return The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     * 
     */
    public Output<List<String>> securityGroupArns() {
        return this.securityGroupArns;
    }
    /**
     * Subdirectory to perform actions as source or destination. Must start with `/fsx`.
     * 
     */
    @Export(name="subdirectory", refs={String.class}, tree="[0]")
    private Output<String> subdirectory;

    /**
     * @return Subdirectory to perform actions as source or destination. Must start with `/fsx`.
     * 
     */
    public Output<String> subdirectory() {
        return this.subdirectory;
    }
    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The URL of the FSx for openzfs location that was described.
     * 
     */
    @Export(name="uri", refs={String.class}, tree="[0]")
    private Output<String> uri;

    /**
     * @return The URL of the FSx for openzfs location that was described.
     * 
     */
    public Output<String> uri() {
        return this.uri;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FsxOpenZfsFileSystem(String name) {
        this(name, FsxOpenZfsFileSystemArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FsxOpenZfsFileSystem(String name, FsxOpenZfsFileSystemArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FsxOpenZfsFileSystem(String name, FsxOpenZfsFileSystemArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem", name, args == null ? FsxOpenZfsFileSystemArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FsxOpenZfsFileSystem(String name, Output<String> id, @Nullable FsxOpenZfsFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FsxOpenZfsFileSystem get(String name, Output<String> id, @Nullable FsxOpenZfsFileSystemState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FsxOpenZfsFileSystem(name, id, state, options);
    }
}
