// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EfsLocationArgs extends com.pulumi.resources.ResourceArgs {

    public static final EfsLocationArgs Empty = new EfsLocationArgs();

    /**
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     * 
     */
    @Import(name="accessPointArn")
    private @Nullable Output<String> accessPointArn;

    /**
     * @return Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     * 
     */
    public Optional<Output<String>> accessPointArn() {
        return Optional.ofNullable(this.accessPointArn);
    }

    /**
     * Configuration block containing EC2 configurations for connecting to the EFS File System.
     * 
     */
    @Import(name="ec2Config", required=true)
    private Output<EfsLocationEc2ConfigArgs> ec2Config;

    /**
     * @return Configuration block containing EC2 configurations for connecting to the EFS File System.
     * 
     */
    public Output<EfsLocationEc2ConfigArgs> ec2Config() {
        return this.ec2Config;
    }

    /**
     * Amazon Resource Name (ARN) of EFS File System.
     * 
     */
    @Import(name="efsFileSystemArn", required=true)
    private Output<String> efsFileSystemArn;

    /**
     * @return Amazon Resource Name (ARN) of EFS File System.
     * 
     */
    public Output<String> efsFileSystemArn() {
        return this.efsFileSystemArn;
    }

    /**
     * Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     * 
     */
    @Import(name="fileSystemAccessRoleArn")
    private @Nullable Output<String> fileSystemAccessRoleArn;

    /**
     * @return Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     * 
     */
    public Optional<Output<String>> fileSystemAccessRoleArn() {
        return Optional.ofNullable(this.fileSystemAccessRoleArn);
    }

    /**
     * Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     * 
     */
    @Import(name="inTransitEncryption")
    private @Nullable Output<String> inTransitEncryption;

    /**
     * @return Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     * 
     */
    public Optional<Output<String>> inTransitEncryption() {
        return Optional.ofNullable(this.inTransitEncryption);
    }

    /**
     * Subdirectory to perform actions as source or destination. Default `/`.
     * 
     */
    @Import(name="subdirectory")
    private @Nullable Output<String> subdirectory;

    /**
     * @return Subdirectory to perform actions as source or destination. Default `/`.
     * 
     */
    public Optional<Output<String>> subdirectory() {
        return Optional.ofNullable(this.subdirectory);
    }

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private EfsLocationArgs() {}

    private EfsLocationArgs(EfsLocationArgs $) {
        this.accessPointArn = $.accessPointArn;
        this.ec2Config = $.ec2Config;
        this.efsFileSystemArn = $.efsFileSystemArn;
        this.fileSystemAccessRoleArn = $.fileSystemAccessRoleArn;
        this.inTransitEncryption = $.inTransitEncryption;
        this.subdirectory = $.subdirectory;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EfsLocationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EfsLocationArgs $;

        public Builder() {
            $ = new EfsLocationArgs();
        }

        public Builder(EfsLocationArgs defaults) {
            $ = new EfsLocationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessPointArn Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
         * 
         * @return builder
         * 
         */
        public Builder accessPointArn(@Nullable Output<String> accessPointArn) {
            $.accessPointArn = accessPointArn;
            return this;
        }

        /**
         * @param accessPointArn Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
         * 
         * @return builder
         * 
         */
        public Builder accessPointArn(String accessPointArn) {
            return accessPointArn(Output.of(accessPointArn));
        }

        /**
         * @param ec2Config Configuration block containing EC2 configurations for connecting to the EFS File System.
         * 
         * @return builder
         * 
         */
        public Builder ec2Config(Output<EfsLocationEc2ConfigArgs> ec2Config) {
            $.ec2Config = ec2Config;
            return this;
        }

        /**
         * @param ec2Config Configuration block containing EC2 configurations for connecting to the EFS File System.
         * 
         * @return builder
         * 
         */
        public Builder ec2Config(EfsLocationEc2ConfigArgs ec2Config) {
            return ec2Config(Output.of(ec2Config));
        }

        /**
         * @param efsFileSystemArn Amazon Resource Name (ARN) of EFS File System.
         * 
         * @return builder
         * 
         */
        public Builder efsFileSystemArn(Output<String> efsFileSystemArn) {
            $.efsFileSystemArn = efsFileSystemArn;
            return this;
        }

        /**
         * @param efsFileSystemArn Amazon Resource Name (ARN) of EFS File System.
         * 
         * @return builder
         * 
         */
        public Builder efsFileSystemArn(String efsFileSystemArn) {
            return efsFileSystemArn(Output.of(efsFileSystemArn));
        }

        /**
         * @param fileSystemAccessRoleArn Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemAccessRoleArn(@Nullable Output<String> fileSystemAccessRoleArn) {
            $.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        /**
         * @param fileSystemAccessRoleArn Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            return fileSystemAccessRoleArn(Output.of(fileSystemAccessRoleArn));
        }

        /**
         * @param inTransitEncryption Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
         * 
         * @return builder
         * 
         */
        public Builder inTransitEncryption(@Nullable Output<String> inTransitEncryption) {
            $.inTransitEncryption = inTransitEncryption;
            return this;
        }

        /**
         * @param inTransitEncryption Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
         * 
         * @return builder
         * 
         */
        public Builder inTransitEncryption(String inTransitEncryption) {
            return inTransitEncryption(Output.of(inTransitEncryption));
        }

        /**
         * @param subdirectory Subdirectory to perform actions as source or destination. Default `/`.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(@Nullable Output<String> subdirectory) {
            $.subdirectory = subdirectory;
            return this;
        }

        /**
         * @param subdirectory Subdirectory to perform actions as source or destination. Default `/`.
         * 
         * @return builder
         * 
         */
        public Builder subdirectory(String subdirectory) {
            return subdirectory(Output.of(subdirectory));
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public EfsLocationArgs build() {
            $.ec2Config = Objects.requireNonNull($.ec2Config, "expected parameter 'ec2Config' to be non-null");
            $.efsFileSystemArn = Objects.requireNonNull($.efsFileSystemArn, "expected parameter 'efsFileSystemArn' to be non-null");
            return $;
        }
    }

}
