// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.datasync;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.datasync.EfsLocationArgs;
import com.pulumi.aws.datasync.inputs.EfsLocationState;
import com.pulumi.aws.datasync.outputs.EfsLocationEc2Config;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an AWS DataSync EFS Location.
 * 
 * &gt; **NOTE:** The EFS File System must have a mounted EFS Mount Target before creating this resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.EfsLocation;
 * import com.pulumi.aws.datasync.EfsLocationArgs;
 * import com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EfsLocation(&#34;example&#34;, EfsLocationArgs.builder()        
 *             .efsFileSystemArn(aws_efs_mount_target.example().file_system_arn())
 *             .ec2Config(EfsLocationEc2ConfigArgs.builder()
 *                 .securityGroupArns(aws_security_group.example().arn())
 *                 .subnetArn(aws_subnet.example().arn())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_datasync_location_efs` using the DataSync Task Amazon Resource Name (ARN). For example:
 * 
 * ```sh
 *  $ pulumi import aws:datasync/efsLocation:EfsLocation example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * 
 */
@ResourceType(type="aws:datasync/efsLocation:EfsLocation")
public class EfsLocation extends com.pulumi.resources.CustomResource {
    /**
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     * 
     */
    @Export(name="accessPointArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> accessPointArn;

    /**
     * @return Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to access the Amazon EFS file system.
     * 
     */
    public Output<Optional<String>> accessPointArn() {
        return Codegen.optional(this.accessPointArn);
    }
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the DataSync Location.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Configuration block containing EC2 configurations for connecting to the EFS File System.
     * 
     */
    @Export(name="ec2Config", refs={EfsLocationEc2Config.class}, tree="[0]")
    private Output<EfsLocationEc2Config> ec2Config;

    /**
     * @return Configuration block containing EC2 configurations for connecting to the EFS File System.
     * 
     */
    public Output<EfsLocationEc2Config> ec2Config() {
        return this.ec2Config;
    }
    /**
     * Amazon Resource Name (ARN) of EFS File System.
     * 
     */
    @Export(name="efsFileSystemArn", refs={String.class}, tree="[0]")
    private Output<String> efsFileSystemArn;

    /**
     * @return Amazon Resource Name (ARN) of EFS File System.
     * 
     */
    public Output<String> efsFileSystemArn() {
        return this.efsFileSystemArn;
    }
    /**
     * Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     * 
     */
    @Export(name="fileSystemAccessRoleArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> fileSystemAccessRoleArn;

    /**
     * @return Specifies an Identity and Access Management (IAM) role that DataSync assumes when mounting the Amazon EFS file system.
     * 
     */
    public Output<Optional<String>> fileSystemAccessRoleArn() {
        return Codegen.optional(this.fileSystemAccessRoleArn);
    }
    /**
     * Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     * 
     */
    @Export(name="inTransitEncryption", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> inTransitEncryption;

    /**
     * @return Specifies whether you want DataSync to use TLS encryption when transferring data to or from your Amazon EFS file system. Valid values are `NONE` and `TLS1_2`.
     * 
     */
    public Output<Optional<String>> inTransitEncryption() {
        return Codegen.optional(this.inTransitEncryption);
    }
    /**
     * Subdirectory to perform actions as source or destination. Default `/`.
     * 
     */
    @Export(name="subdirectory", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> subdirectory;

    /**
     * @return Subdirectory to perform actions as source or destination. Default `/`.
     * 
     */
    public Output<Optional<String>> subdirectory() {
        return Codegen.optional(this.subdirectory);
    }
    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    @Export(name="uri", refs={String.class}, tree="[0]")
    private Output<String> uri;

    public Output<String> uri() {
        return this.uri;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EfsLocation(String name) {
        this(name, EfsLocationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EfsLocation(String name, EfsLocationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EfsLocation(String name, EfsLocationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/efsLocation:EfsLocation", name, args == null ? EfsLocationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EfsLocation(String name, Output<String> id, @Nullable EfsLocationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:datasync/efsLocation:EfsLocation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EfsLocation get(String name, Output<String> id, @Nullable EfsLocationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EfsLocation(name, id, state, options);
    }
}
