// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cur;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cur.ReportDefinitionArgs;
import com.pulumi.aws.cur.inputs.ReportDefinitionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages Cost and Usage Report Definitions.
 * 
 * &gt; *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cur.ReportDefinition;
 * import com.pulumi.aws.cur.ReportDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleCurReportDefinition = new ReportDefinition(&#34;exampleCurReportDefinition&#34;, ReportDefinitionArgs.builder()        
 *             .additionalArtifacts(            
 *                 &#34;REDSHIFT&#34;,
 *                 &#34;QUICKSIGHT&#34;)
 *             .additionalSchemaElements(            
 *                 &#34;RESOURCES&#34;,
 *                 &#34;SPLIT_COST_ALLOCATION_DATA&#34;)
 *             .compression(&#34;GZIP&#34;)
 *             .format(&#34;textORcsv&#34;)
 *             .reportName(&#34;example-cur-report-definition&#34;)
 *             .s3Bucket(&#34;example-bucket-name&#34;)
 *             .s3Region(&#34;us-east-1&#34;)
 *             .timeUnit(&#34;HOURLY&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Report Definitions using the `report_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
 * ```
 * 
 */
@ResourceType(type="aws:cur/reportDefinition:ReportDefinition")
public class ReportDefinition extends com.pulumi.resources.CustomResource {
    /**
     * A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     * 
     */
    @Export(name="additionalArtifacts", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> additionalArtifacts;

    /**
     * @return A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     * 
     */
    public Output<Optional<List<String>>> additionalArtifacts() {
        return Codegen.optional(this.additionalArtifacts);
    }
    /**
     * A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     * 
     */
    @Export(name="additionalSchemaElements", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> additionalSchemaElements;

    /**
     * @return A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     * 
     */
    public Output<List<String>> additionalSchemaElements() {
        return this.additionalSchemaElements;
    }
    /**
     * The Amazon Resource Name (ARN) specifying the cur report.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) specifying the cur report.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     * 
     */
    @Export(name="compression", refs={String.class}, tree="[0]")
    private Output<String> compression;

    /**
     * @return Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     * 
     */
    public Output<String> compression() {
        return this.compression;
    }
    /**
     * Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     * 
     */
    @Export(name="format", refs={String.class}, tree="[0]")
    private Output<String> format;

    /**
     * @return Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     * 
     */
    public Output<String> format() {
        return this.format;
    }
    /**
     * Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     * 
     */
    @Export(name="refreshClosedReports", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> refreshClosedReports;

    /**
     * @return Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     * 
     */
    public Output<Optional<Boolean>> refreshClosedReports() {
        return Codegen.optional(this.refreshClosedReports);
    }
    /**
     * Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     * 
     */
    @Export(name="reportName", refs={String.class}, tree="[0]")
    private Output<String> reportName;

    /**
     * @return Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     * 
     */
    public Output<String> reportName() {
        return this.reportName;
    }
    /**
     * Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     * 
     */
    @Export(name="reportVersioning", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> reportVersioning;

    /**
     * @return Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     * 
     */
    public Output<Optional<String>> reportVersioning() {
        return Codegen.optional(this.reportVersioning);
    }
    /**
     * Name of the existing S3 bucket to hold generated reports.
     * 
     */
    @Export(name="s3Bucket", refs={String.class}, tree="[0]")
    private Output<String> s3Bucket;

    /**
     * @return Name of the existing S3 bucket to hold generated reports.
     * 
     */
    public Output<String> s3Bucket() {
        return this.s3Bucket;
    }
    /**
     * Report path prefix. Limited to 256 characters.
     * 
     */
    @Export(name="s3Prefix", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> s3Prefix;

    /**
     * @return Report path prefix. Limited to 256 characters.
     * 
     */
    public Output<Optional<String>> s3Prefix() {
        return Codegen.optional(this.s3Prefix);
    }
    /**
     * Region of the existing S3 bucket to hold generated reports.
     * 
     */
    @Export(name="s3Region", refs={String.class}, tree="[0]")
    private Output<String> s3Region;

    /**
     * @return Region of the existing S3 bucket to hold generated reports.
     * 
     */
    public Output<String> s3Region() {
        return this.s3Region;
    }
    /**
     * The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     * 
     */
    @Export(name="timeUnit", refs={String.class}, tree="[0]")
    private Output<String> timeUnit;

    /**
     * @return The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     * 
     */
    public Output<String> timeUnit() {
        return this.timeUnit;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ReportDefinition(String name) {
        this(name, ReportDefinitionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ReportDefinition(String name, ReportDefinitionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ReportDefinition(String name, ReportDefinitionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cur/reportDefinition:ReportDefinition", name, args == null ? ReportDefinitionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ReportDefinition(String name, Output<String> id, @Nullable ReportDefinitionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cur/reportDefinition:ReportDefinition", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ReportDefinition get(String name, Output<String> id, @Nullable ReportDefinitionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ReportDefinition(name, id, state, options);
    }
}
