// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.costexplorer.inputs;

import com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleParameterArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class CostCategorySplitChargeRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final CostCategorySplitChargeRuleArgs Empty = new CostCategorySplitChargeRuleArgs();

    /**
     * Method that&#39;s used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
     * 
     */
    @Import(name="method", required=true)
    private Output<String> method;

    /**
     * @return Method that&#39;s used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
     * 
     */
    public Output<String> method() {
        return this.method;
    }

    /**
     * Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     * 
     */
    @Import(name="parameters")
    private @Nullable Output<List<CostCategorySplitChargeRuleParameterArgs>> parameters;

    /**
     * @return Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
     * 
     */
    public Optional<Output<List<CostCategorySplitChargeRuleParameterArgs>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    /**
     * Cost Category value that you want to split.
     * 
     */
    @Import(name="source", required=true)
    private Output<String> source;

    /**
     * @return Cost Category value that you want to split.
     * 
     */
    public Output<String> source() {
        return this.source;
    }

    /**
     * Cost Category values that you want to split costs across. These values can&#39;t be used as a source in other split charge rules.
     * 
     */
    @Import(name="targets", required=true)
    private Output<List<String>> targets;

    /**
     * @return Cost Category values that you want to split costs across. These values can&#39;t be used as a source in other split charge rules.
     * 
     */
    public Output<List<String>> targets() {
        return this.targets;
    }

    private CostCategorySplitChargeRuleArgs() {}

    private CostCategorySplitChargeRuleArgs(CostCategorySplitChargeRuleArgs $) {
        this.method = $.method;
        this.parameters = $.parameters;
        this.source = $.source;
        this.targets = $.targets;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(CostCategorySplitChargeRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CostCategorySplitChargeRuleArgs $;

        public Builder() {
            $ = new CostCategorySplitChargeRuleArgs();
        }

        public Builder(CostCategorySplitChargeRuleArgs defaults) {
            $ = new CostCategorySplitChargeRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param method Method that&#39;s used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
         * 
         * @return builder
         * 
         */
        public Builder method(Output<String> method) {
            $.method = method;
            return this;
        }

        /**
         * @param method Method that&#39;s used to define how to split your source costs across your targets. Valid values are `FIXED`, `PROPORTIONAL`, `EVEN`
         * 
         * @return builder
         * 
         */
        public Builder method(String method) {
            return method(Output.of(method));
        }

        /**
         * @param parameters Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
         * 
         * @return builder
         * 
         */
        public Builder parameters(@Nullable Output<List<CostCategorySplitChargeRuleParameterArgs>> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
         * 
         * @return builder
         * 
         */
        public Builder parameters(List<CostCategorySplitChargeRuleParameterArgs> parameters) {
            return parameters(Output.of(parameters));
        }

        /**
         * @param parameters Configuration block for the parameters for a split charge method. This is only required for the `FIXED` method. See below.
         * 
         * @return builder
         * 
         */
        public Builder parameters(CostCategorySplitChargeRuleParameterArgs... parameters) {
            return parameters(List.of(parameters));
        }

        /**
         * @param source Cost Category value that you want to split.
         * 
         * @return builder
         * 
         */
        public Builder source(Output<String> source) {
            $.source = source;
            return this;
        }

        /**
         * @param source Cost Category value that you want to split.
         * 
         * @return builder
         * 
         */
        public Builder source(String source) {
            return source(Output.of(source));
        }

        /**
         * @param targets Cost Category values that you want to split costs across. These values can&#39;t be used as a source in other split charge rules.
         * 
         * @return builder
         * 
         */
        public Builder targets(Output<List<String>> targets) {
            $.targets = targets;
            return this;
        }

        /**
         * @param targets Cost Category values that you want to split costs across. These values can&#39;t be used as a source in other split charge rules.
         * 
         * @return builder
         * 
         */
        public Builder targets(List<String> targets) {
            return targets(Output.of(targets));
        }

        /**
         * @param targets Cost Category values that you want to split costs across. These values can&#39;t be used as a source in other split charge rules.
         * 
         * @return builder
         * 
         */
        public Builder targets(String... targets) {
            return targets(List.of(targets));
        }

        public CostCategorySplitChargeRuleArgs build() {
            $.method = Objects.requireNonNull($.method, "expected parameter 'method' to be non-null");
            $.source = Objects.requireNonNull($.source, "expected parameter 'source' to be non-null");
            $.targets = Objects.requireNonNull($.targets, "expected parameter 'targets' to be non-null");
            return $;
        }
    }

}
