// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.connect;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.connect.HoursOfOperationArgs;
import com.pulumi.aws.connect.inputs.HoursOfOperationState;
import com.pulumi.aws.connect.outputs.HoursOfOperationConfig;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Amazon Connect Hours of Operation resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.HoursOfOperation;
 * import com.pulumi.aws.connect.HoursOfOperationArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigStartTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new HoursOfOperation(&#34;test&#34;, HoursOfOperationArgs.builder()        
 *             .configs(            
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day(&#34;MONDAY&#34;)
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(23)
 *                         .minutes(8)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(8)
 *                         .minutes(0)
 *                         .build())
 *                     .build(),
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day(&#34;TUESDAY&#34;)
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(21)
 *                         .minutes(0)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(9)
 *                         .minutes(0)
 *                         .build())
 *                     .build())
 *             .description(&#34;Monday office hours&#34;)
 *             .instanceId(&#34;aaaaaaaa-bbbb-cccc-dddd-111111111111&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;Example Hours of Operation&#34;))
 *             .timeZone(&#34;EST&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Amazon Connect Hours of Operations using the `instance_id` and `hours_of_operation_id` separated by a colon (`:`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:connect/hoursOfOperation:HoursOfOperation example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * 
 */
@ResourceType(type="aws:connect/hoursOfOperation:HoursOfOperation")
public class HoursOfOperation extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the Hours of Operation.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the Hours of Operation.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     * 
     */
    @Export(name="configs", refs={List.class,HoursOfOperationConfig.class}, tree="[0,1]")
    private Output<List<HoursOfOperationConfig>> configs;

    /**
     * @return One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     * 
     */
    public Output<List<HoursOfOperationConfig>> configs() {
        return this.configs;
    }
    /**
     * Specifies the description of the Hours of Operation.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Specifies the description of the Hours of Operation.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The identifier for the hours of operation.
     * 
     */
    @Export(name="hoursOfOperationId", refs={String.class}, tree="[0]")
    private Output<String> hoursOfOperationId;

    /**
     * @return The identifier for the hours of operation.
     * 
     */
    public Output<String> hoursOfOperationId() {
        return this.hoursOfOperationId;
    }
    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     * 
     */
    @Export(name="instanceId", refs={String.class}, tree="[0]")
    private Output<String> instanceId;

    /**
     * @return Specifies the identifier of the hosting Amazon Connect Instance.
     * 
     */
    public Output<String> instanceId() {
        return this.instanceId;
    }
    /**
     * Specifies the name of the Hours of Operation.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Specifies the name of the Hours of Operation.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Specifies the time zone of the Hours of Operation.
     * 
     */
    @Export(name="timeZone", refs={String.class}, tree="[0]")
    private Output<String> timeZone;

    /**
     * @return Specifies the time zone of the Hours of Operation.
     * 
     */
    public Output<String> timeZone() {
        return this.timeZone;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public HoursOfOperation(String name) {
        this(name, HoursOfOperationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public HoursOfOperation(String name, HoursOfOperationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public HoursOfOperation(String name, HoursOfOperationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:connect/hoursOfOperation:HoursOfOperation", name, args == null ? HoursOfOperationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private HoursOfOperation(String name, Output<String> id, @Nullable HoursOfOperationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:connect/hoursOfOperation:HoursOfOperation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static HoursOfOperation get(String name, Output<String> id, @Nullable HoursOfOperationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new HoursOfOperation(name, id, state, options);
    }
}
