// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cognito;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cognito.UserArgs;
import com.pulumi.aws.cognito.inputs.UserState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Cognito User Resource.
 * 
 * ## Example Usage
 * ### Basic configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool(&#34;exampleUserPool&#34;);
 * 
 *         var exampleUser = new User(&#34;exampleUser&#34;, UserArgs.builder()        
 *             .userPoolId(exampleUserPool.id())
 *             .username(&#34;example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Setting user attributes
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaArgs;
 * import com.pulumi.aws.cognito.inputs.UserPoolSchemaStringAttributeConstraintsArgs;
 * import com.pulumi.aws.cognito.User;
 * import com.pulumi.aws.cognito.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool(&#34;exampleUserPool&#34;, UserPoolArgs.builder()        
 *             .schemas(            
 *                 UserPoolSchemaArgs.builder()
 *                     .name(&#34;example&#34;)
 *                     .attributeDataType(&#34;Boolean&#34;)
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .build(),
 *                 UserPoolSchemaArgs.builder()
 *                     .name(&#34;foo&#34;)
 *                     .attributeDataType(&#34;String&#34;)
 *                     .mutable(false)
 *                     .required(false)
 *                     .developerOnlyAttribute(false)
 *                     .stringAttributeConstraints()
 *                     .build())
 *             .build());
 * 
 *         var exampleUser = new User(&#34;exampleUser&#34;, UserArgs.builder()        
 *             .userPoolId(exampleUserPool.id())
 *             .username(&#34;example&#34;)
 *             .attributes(Map.ofEntries(
 *                 Map.entry(&#34;example&#34;, true),
 *                 Map.entry(&#34;foo&#34;, &#34;bar&#34;),
 *                 Map.entry(&#34;email&#34;, &#34;no-reply@domain.example&#34;),
 *                 Map.entry(&#34;email_verified&#34;, true)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cognito User using the `user_pool_id`/`name` attributes concatenated. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cognito/user:User user us-east-1_vG78M4goG/user
 * ```
 * 
 */
@ResourceType(type="aws:cognito/user:User")
public class User extends com.pulumi.resources.CustomResource {
    /**
     * A map that contains user attributes and attribute values to be set for the user.
     * 
     */
    @Export(name="attributes", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> attributes;

    /**
     * @return A map that contains user attributes and attribute values to be set for the user.
     * 
     */
    public Output<Optional<Map<String,String>>> attributes() {
        return Codegen.optional(this.attributes);
    }
    /**
     * A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * 
     */
    @Export(name="clientMetadata", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> clientMetadata;

    /**
     * @return A map of custom key-value pairs that you can provide as input for any custom workflows that user creation triggers. Amazon Cognito does not store the `client_metadata` value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * 
     */
    public Output<Optional<Map<String,String>>> clientMetadata() {
        return Codegen.optional(this.clientMetadata);
    }
    @Export(name="creationDate", refs={String.class}, tree="[0]")
    private Output<String> creationDate;

    public Output<String> creationDate() {
        return this.creationDate;
    }
    /**
     * A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it&#39;s provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `[&#34;SMS&#34;]`.
     * 
     */
    @Export(name="desiredDeliveryMediums", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> desiredDeliveryMediums;

    /**
     * @return A list of mediums to the welcome message will be sent through. Allowed values are `EMAIL` and `SMS`. If it&#39;s provided, make sure you have also specified `email` attribute for the `EMAIL` medium and `phone_number` for the `SMS`. More than one value can be specified. Amazon Cognito does not store the `desired_delivery_mediums` value. Defaults to `[&#34;SMS&#34;]`.
     * 
     */
    public Output<Optional<List<String>>> desiredDeliveryMediums() {
        return Codegen.optional(this.desiredDeliveryMediums);
    }
    /**
     * Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     * 
     */
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enabled;

    /**
     * @return Specifies whether the user should be enabled after creation. The welcome message will be sent regardless of the `enabled` value. The behavior can be changed with `message_action` argument. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> enabled() {
        return Codegen.optional(this.enabled);
    }
    /**
     * If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     * 
     */
    @Export(name="forceAliasCreation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> forceAliasCreation;

    /**
     * @return If this parameter is set to True and the `phone_number` or `email` address specified in the `attributes` parameter already exists as an alias with a different user, Amazon Cognito will migrate the alias from the previous user to the newly created user. The previous user will no longer be able to log in using that alias. Amazon Cognito does not store the `force_alias_creation` value. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> forceAliasCreation() {
        return Codegen.optional(this.forceAliasCreation);
    }
    @Export(name="lastModifiedDate", refs={String.class}, tree="[0]")
    private Output<String> lastModifiedDate;

    public Output<String> lastModifiedDate() {
        return this.lastModifiedDate;
    }
    /**
     * Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user&#39;s account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     * 
     */
    @Export(name="messageAction", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> messageAction;

    /**
     * @return Set to `RESEND` to resend the invitation message to a user that already exists and reset the expiration limit on the user&#39;s account. Set to `SUPPRESS` to suppress sending the message. Only one value can be specified. Amazon Cognito does not store the `message_action` value.
     * 
     */
    public Output<Optional<String>> messageAction() {
        return Codegen.optional(this.messageAction);
    }
    @Export(name="mfaSettingLists", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> mfaSettingLists;

    public Output<List<String>> mfaSettingLists() {
        return this.mfaSettingLists;
    }
    /**
     * The user&#39;s permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     * 
     */
    @Export(name="password", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> password;

    /**
     * @return The user&#39;s permanent password. This password must conform to the password policy specified by user pool the user belongs to. The welcome message always contains only `temporary_password` value. You can suppress sending the welcome message with the `message_action` argument. Amazon Cognito does not store the `password` value. Conflicts with `temporary_password`.
     * 
     */
    public Output<Optional<String>> password() {
        return Codegen.optional(this.password);
    }
    @Export(name="preferredMfaSetting", refs={String.class}, tree="[0]")
    private Output<String> preferredMfaSetting;

    public Output<String> preferredMfaSetting() {
        return this.preferredMfaSetting;
    }
    /**
     * current user status.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return current user status.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * unique user id that is never reassignable to another user.
     * 
     */
    @Export(name="sub", refs={String.class}, tree="[0]")
    private Output<String> sub;

    /**
     * @return unique user id that is never reassignable to another user.
     * 
     */
    public Output<String> sub() {
        return this.sub;
    }
    /**
     * The user&#39;s temporary password. Conflicts with `password`.
     * 
     */
    @Export(name="temporaryPassword", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> temporaryPassword;

    /**
     * @return The user&#39;s temporary password. Conflicts with `password`.
     * 
     */
    public Output<Optional<String>> temporaryPassword() {
        return Codegen.optional(this.temporaryPassword);
    }
    /**
     * The user pool ID for the user pool where the user will be created.
     * 
     */
    @Export(name="userPoolId", refs={String.class}, tree="[0]")
    private Output<String> userPoolId;

    /**
     * @return The user pool ID for the user pool where the user will be created.
     * 
     */
    public Output<String> userPoolId() {
        return this.userPoolId;
    }
    /**
     * The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="username", refs={String.class}, tree="[0]")
    private Output<String> username;

    /**
     * @return The username for the user. Must be unique within the user pool. Must be a UTF-8 string between 1 and 128 characters. After the user is created, the username cannot be changed.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> username() {
        return this.username;
    }
    /**
     * The user&#39;s validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * 
     * &gt; **NOTE:** Clearing `password` or `temporary_password` does not reset user&#39;s password in Cognito.
     * 
     */
    @Export(name="validationData", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> validationData;

    /**
     * @return The user&#39;s validation data. This is an array of name-value pairs that contain user attributes and attribute values that you can use for custom validation, such as restricting the types of user accounts that can be registered. Amazon Cognito does not store the `validation_data` value. For more information, see [Customizing User Pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html).
     * 
     * &gt; **NOTE:** Clearing `password` or `temporary_password` does not reset user&#39;s password in Cognito.
     * 
     */
    public Output<Optional<Map<String,String>>> validationData() {
        return Codegen.optional(this.validationData);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public User(String name) {
        this(name, UserArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public User(String name, UserArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public User(String name, UserArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/user:User", name, args == null ? UserArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private User(String name, Output<String> id, @Nullable UserState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/user:User", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "password",
                "temporaryPassword"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static User get(String name, Output<String> id, @Nullable UserState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new User(name, id, state, options);
    }
}
