// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cognito;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cognito.ManagedUserPoolClientArgs;
import com.pulumi.aws.cognito.inputs.ManagedUserPoolClientState;
import com.pulumi.aws.cognito.outputs.ManagedUserPoolClientAnalyticsConfiguration;
import com.pulumi.aws.cognito.outputs.ManagedUserPoolClientTokenValidityUnits;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Use the `aws.cognito.UserPoolClient` resource to manage a Cognito User Pool Client.
 * 
 * **This resource is advanced** and has special caveats to consider before use. Please read this document completely before using the resource.
 * 
 * Use the `aws.cognito.ManagedUserPoolClient` resource to manage a Cognito User Pool Client that is automatically created by an AWS service. For instance, when [configuring an OpenSearch Domain to use Cognito authentication](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html), the OpenSearch service creates the User Pool Client during setup and removes it when it is no longer required. As a result, the `aws.cognito.ManagedUserPoolClient` resource does not create or delete this resource, but instead assumes management of it.
 * 
 * Use the `aws.cognito.UserPoolClient` resource to manage Cognito User Pool Clients for normal use cases.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.IdentityPool;
 * import com.pulumi.aws.cognito.IdentityPoolArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainCognitoOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.cognito.ManagedUserPoolClient;
 * import com.pulumi.aws.cognito.ManagedUserPoolClientArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool(&#34;exampleUserPool&#34;);
 * 
 *         var exampleIdentityPool = new IdentityPool(&#34;exampleIdentityPool&#34;, IdentityPoolArgs.builder()        
 *             .identityPoolName(&#34;example&#34;)
 *             .build());
 * 
 *         final var current = AwsFunctions.getPartition();
 * 
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(&#34;&#34;)
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(String.format(&#34;es.%s&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.dnsSuffix())))
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *         var exampleRole = new Role(&#34;exampleRole&#34;, RoleArgs.builder()        
 *             .path(&#34;/service-role/&#34;)
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment(&#34;exampleRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .role(exampleRole.name())
 *             .policyArn(String.format(&#34;arn:%s:iam::aws:policy/AmazonESCognitoAccess&#34;, current.applyValue(getPartitionResult -&gt; getPartitionResult.partition())))
 *             .build());
 * 
 *         var exampleDomain = new Domain(&#34;exampleDomain&#34;, DomainArgs.builder()        
 *             .cognitoOptions(DomainCognitoOptionsArgs.builder()
 *                 .enabled(true)
 *                 .userPoolId(exampleUserPool.id())
 *                 .identityPoolId(exampleIdentityPool.id())
 *                 .roleArn(exampleRole.arn())
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(                
 *                     aws_cognito_user_pool_domain.example(),
 *                     exampleRolePolicyAttachment)
 *                 .build());
 * 
 *         var exampleManagedUserPoolClient = new ManagedUserPoolClient(&#34;exampleManagedUserPoolClient&#34;, ManagedUserPoolClientArgs.builder()        
 *             .namePrefix(&#34;AmazonOpenSearchService-example&#34;)
 *             .userPoolId(exampleUserPool.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleDomain)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cognito User Pool Clients using the `id` of the Cognito User Pool and the `id` of the Cognito User Pool Client. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cognito/managedUserPoolClient:ManagedUserPoolClient client us-west-2_abc123/3ho4ek12345678909nh3fmhpko
 * ```
 * 
 */
@ResourceType(type="aws:cognito/managedUserPoolClient:ManagedUserPoolClient")
public class ManagedUserPoolClient extends com.pulumi.resources.CustomResource {
    /**
     * Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
     * 
     */
    @Export(name="accessTokenValidity", refs={Integer.class}, tree="[0]")
    private Output<Integer> accessTokenValidity;

    /**
     * @return Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.access_token`.
     * 
     */
    public Output<Integer> accessTokenValidity() {
        return this.accessTokenValidity;
    }
    /**
     * List of allowed OAuth flows, including code, implicit, and client_credentials.
     * 
     */
    @Export(name="allowedOauthFlows", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allowedOauthFlows;

    /**
     * @return List of allowed OAuth flows, including code, implicit, and client_credentials.
     * 
     */
    public Output<List<String>> allowedOauthFlows() {
        return this.allowedOauthFlows;
    }
    /**
     * Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
     * 
     */
    @Export(name="allowedOauthFlowsUserPoolClient", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> allowedOauthFlowsUserPoolClient;

    /**
     * @return Whether the client is allowed to use the OAuth protocol when interacting with Cognito user pools.
     * 
     */
    public Output<Boolean> allowedOauthFlowsUserPoolClient() {
        return this.allowedOauthFlowsUserPoolClient;
    }
    /**
     * List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     * 
     */
    @Export(name="allowedOauthScopes", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> allowedOauthScopes;

    /**
     * @return List of allowed OAuth scopes, including phone, email, openid, profile, and aws.cognito.signin.user.admin.
     * 
     */
    public Output<List<String>> allowedOauthScopes() {
        return this.allowedOauthScopes;
    }
    /**
     * Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     * 
     */
    @Export(name="analyticsConfiguration", refs={ManagedUserPoolClientAnalyticsConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ManagedUserPoolClientAnalyticsConfiguration> analyticsConfiguration;

    /**
     * @return Configuration block for Amazon Pinpoint analytics that collects metrics for this user pool. See details below.
     * 
     */
    public Output<Optional<ManagedUserPoolClientAnalyticsConfiguration>> analyticsConfiguration() {
        return Codegen.optional(this.analyticsConfiguration);
    }
    /**
     * Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
     * 
     */
    @Export(name="authSessionValidity", refs={Integer.class}, tree="[0]")
    private Output<Integer> authSessionValidity;

    /**
     * @return Duration, in minutes, of the session token created by Amazon Cognito for each API request in an authentication flow. The session token must be responded to by the native user of the user pool before it expires. Valid values for `auth_session_validity` are between `3` and `15`, with a default value of `3`.
     * 
     */
    public Output<Integer> authSessionValidity() {
        return this.authSessionValidity;
    }
    /**
     * List of allowed callback URLs for the identity providers.
     * 
     */
    @Export(name="callbackUrls", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> callbackUrls;

    /**
     * @return List of allowed callback URLs for the identity providers.
     * 
     */
    public Output<List<String>> callbackUrls() {
        return this.callbackUrls;
    }
    /**
     * Client secret of the user pool client.
     * 
     */
    @Export(name="clientSecret", refs={String.class}, tree="[0]")
    private Output<String> clientSecret;

    /**
     * @return Client secret of the user pool client.
     * 
     */
    public Output<String> clientSecret() {
        return this.clientSecret;
    }
    /**
     * Default redirect URI and must be included in the list of callback URLs.
     * 
     */
    @Export(name="defaultRedirectUri", refs={String.class}, tree="[0]")
    private Output<String> defaultRedirectUri;

    /**
     * @return Default redirect URI and must be included in the list of callback URLs.
     * 
     */
    public Output<String> defaultRedirectUri() {
        return this.defaultRedirectUri;
    }
    /**
     * Enables the propagation of additional user context data.
     * 
     */
    @Export(name="enablePropagateAdditionalUserContextData", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enablePropagateAdditionalUserContextData;

    /**
     * @return Enables the propagation of additional user context data.
     * 
     */
    public Output<Boolean> enablePropagateAdditionalUserContextData() {
        return this.enablePropagateAdditionalUserContextData;
    }
    /**
     * Enables or disables token revocation.
     * 
     */
    @Export(name="enableTokenRevocation", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enableTokenRevocation;

    /**
     * @return Enables or disables token revocation.
     * 
     */
    public Output<Boolean> enableTokenRevocation() {
        return this.enableTokenRevocation;
    }
    /**
     * List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     * 
     */
    @Export(name="explicitAuthFlows", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> explicitAuthFlows;

    /**
     * @return List of authentication flows. The available options include ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_REFRESH_TOKEN_AUTH.
     * 
     */
    public Output<List<String>> explicitAuthFlows() {
        return this.explicitAuthFlows;
    }
    /**
     * Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
     * 
     */
    @Export(name="idTokenValidity", refs={Integer.class}, tree="[0]")
    private Output<Integer> idTokenValidity;

    /**
     * @return Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. By default, the unit is hours. The unit can be overridden by a value in `token_validity_units.id_token`.
     * 
     */
    public Output<Integer> idTokenValidity() {
        return this.idTokenValidity;
    }
    /**
     * List of allowed logout URLs for the identity providers.
     * 
     */
    @Export(name="logoutUrls", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> logoutUrls;

    /**
     * @return List of allowed logout URLs for the identity providers.
     * 
     */
    public Output<List<String>> logoutUrls() {
        return this.logoutUrls;
    }
    /**
     * Name of the user pool client.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the user pool client.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
     * 
     */
    @Export(name="namePattern", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> namePattern;

    /**
     * @return Regular expression that matches the name of the desired User Pool Client. It must only match one User Pool Client.
     * 
     */
    public Output<Optional<String>> namePattern() {
        return Codegen.optional(this.namePattern);
    }
    /**
     * String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> namePrefix;

    /**
     * @return String that matches the beginning of the name of the desired User Pool Client. It must match only one User Pool Client.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Optional<String>> namePrefix() {
        return Codegen.optional(this.namePrefix);
    }
    /**
     * Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
     * 
     */
    @Export(name="preventUserExistenceErrors", refs={String.class}, tree="[0]")
    private Output<String> preventUserExistenceErrors;

    /**
     * @return Setting determines the errors and responses returned by Cognito APIs when a user does not exist in the user pool during authentication, account confirmation, and password recovery.
     * 
     */
    public Output<String> preventUserExistenceErrors() {
        return this.preventUserExistenceErrors;
    }
    /**
     * List of user pool attributes that the application client can read from.
     * 
     */
    @Export(name="readAttributes", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> readAttributes;

    /**
     * @return List of user pool attributes that the application client can read from.
     * 
     */
    public Output<List<String>> readAttributes() {
        return this.readAttributes;
    }
    /**
     * Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
     * 
     */
    @Export(name="refreshTokenValidity", refs={Integer.class}, tree="[0]")
    private Output<Integer> refreshTokenValidity;

    /**
     * @return Time limit, between 60 minutes and 10 years, after which the refresh token is no longer valid and cannot be used. By default, the unit is days. The unit can be overridden by a value in `token_validity_units.refresh_token`.
     * 
     */
    public Output<Integer> refreshTokenValidity() {
        return this.refreshTokenValidity;
    }
    /**
     * List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     * 
     */
    @Export(name="supportedIdentityProviders", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> supportedIdentityProviders;

    /**
     * @return List of provider names for the identity providers that are supported on this client. It uses the `provider_name` attribute of the `aws.cognito.IdentityProvider` resource(s), or the equivalent string(s).
     * 
     */
    public Output<List<String>> supportedIdentityProviders() {
        return this.supportedIdentityProviders;
    }
    /**
     * Configuration block for representing the validity times in units. See details below. Detailed below.
     * 
     */
    @Export(name="tokenValidityUnits", refs={ManagedUserPoolClientTokenValidityUnits.class}, tree="[0]")
    private Output</* @Nullable */ ManagedUserPoolClientTokenValidityUnits> tokenValidityUnits;

    /**
     * @return Configuration block for representing the validity times in units. See details below. Detailed below.
     * 
     */
    public Output<Optional<ManagedUserPoolClientTokenValidityUnits>> tokenValidityUnits() {
        return Codegen.optional(this.tokenValidityUnits);
    }
    /**
     * User pool that the client belongs to.
     * 
     */
    @Export(name="userPoolId", refs={String.class}, tree="[0]")
    private Output<String> userPoolId;

    /**
     * @return User pool that the client belongs to.
     * 
     */
    public Output<String> userPoolId() {
        return this.userPoolId;
    }
    /**
     * List of user pool attributes that the application client can write to.
     * 
     */
    @Export(name="writeAttributes", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> writeAttributes;

    /**
     * @return List of user pool attributes that the application client can write to.
     * 
     */
    public Output<List<String>> writeAttributes() {
        return this.writeAttributes;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ManagedUserPoolClient(String name) {
        this(name, ManagedUserPoolClientArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ManagedUserPoolClient(String name, ManagedUserPoolClientArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ManagedUserPoolClient(String name, ManagedUserPoolClientArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/managedUserPoolClient:ManagedUserPoolClient", name, args == null ? ManagedUserPoolClientArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ManagedUserPoolClient(String name, Output<String> id, @Nullable ManagedUserPoolClientState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/managedUserPoolClient:ManagedUserPoolClient", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "clientSecret"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ManagedUserPoolClient get(String name, Output<String> id, @Nullable ManagedUserPoolClientState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ManagedUserPoolClient(name, id, state, options);
    }
}
