// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cognito;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cognito.IdentityProviderArgs;
import com.pulumi.aws.cognito.inputs.IdentityProviderState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Cognito User Identity Provider resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.IdentityProvider;
 * import com.pulumi.aws.cognito.IdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new UserPool(&#34;example&#34;, UserPoolArgs.builder()        
 *             .autoVerifiedAttributes(&#34;email&#34;)
 *             .build());
 * 
 *         var exampleProvider = new IdentityProvider(&#34;exampleProvider&#34;, IdentityProviderArgs.builder()        
 *             .userPoolId(example.id())
 *             .providerName(&#34;Google&#34;)
 *             .providerType(&#34;Google&#34;)
 *             .providerDetails(Map.ofEntries(
 *                 Map.entry(&#34;authorize_scopes&#34;, &#34;email&#34;),
 *                 Map.entry(&#34;client_id&#34;, &#34;your client_id&#34;),
 *                 Map.entry(&#34;client_secret&#34;, &#34;your client_secret&#34;)
 *             ))
 *             .attributeMapping(Map.ofEntries(
 *                 Map.entry(&#34;email&#34;, &#34;email&#34;),
 *                 Map.entry(&#34;username&#34;, &#34;sub&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_cognito_identity_provider` resources using their User Pool ID and Provider Name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cognito/identityProvider:IdentityProvider example us-west-2_abc123:CorpAD
 * ```
 * 
 */
@ResourceType(type="aws:cognito/identityProvider:IdentityProvider")
public class IdentityProvider extends com.pulumi.resources.CustomResource {
    /**
     * The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     * 
     */
    @Export(name="attributeMapping", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> attributeMapping;

    /**
     * @return The map of attribute mapping of user pool attributes. [AttributeMapping in AWS API documentation](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-AttributeMapping)
     * 
     */
    public Output<Map<String,String>> attributeMapping() {
        return this.attributeMapping;
    }
    /**
     * The list of identity providers.
     * 
     */
    @Export(name="idpIdentifiers", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> idpIdentifiers;

    /**
     * @return The list of identity providers.
     * 
     */
    public Output<Optional<List<String>>> idpIdentifiers() {
        return Codegen.optional(this.idpIdentifiers);
    }
    /**
     * The map of identity details, such as access token
     * 
     */
    @Export(name="providerDetails", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> providerDetails;

    /**
     * @return The map of identity details, such as access token
     * 
     */
    public Output<Map<String,String>> providerDetails() {
        return this.providerDetails;
    }
    /**
     * The provider name
     * 
     */
    @Export(name="providerName", refs={String.class}, tree="[0]")
    private Output<String> providerName;

    /**
     * @return The provider name
     * 
     */
    public Output<String> providerName() {
        return this.providerName;
    }
    /**
     * The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
     * 
     */
    @Export(name="providerType", refs={String.class}, tree="[0]")
    private Output<String> providerType;

    /**
     * @return The provider type.  [See AWS API for valid values](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html#CognitoUserPools-CreateIdentityProvider-request-ProviderType)
     * 
     */
    public Output<String> providerType() {
        return this.providerType;
    }
    /**
     * The user pool id
     * 
     */
    @Export(name="userPoolId", refs={String.class}, tree="[0]")
    private Output<String> userPoolId;

    /**
     * @return The user pool id
     * 
     */
    public Output<String> userPoolId() {
        return this.userPoolId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public IdentityProvider(String name) {
        this(name, IdentityProviderArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public IdentityProvider(String name, IdentityProviderArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public IdentityProvider(String name, IdentityProviderArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/identityProvider:IdentityProvider", name, args == null ? IdentityProviderArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private IdentityProvider(String name, Output<String> id, @Nullable IdentityProviderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cognito/identityProvider:IdentityProvider", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static IdentityProvider get(String name, Output<String> id, @Nullable IdentityProviderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new IdentityProvider(name, id, state, options);
    }
}
