// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codepipeline.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PipelineStageAction {
    /**
     * @return A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
     * 
     */
    private String category;
    /**
     * @return A map of the action declaration&#39;s configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     * 
     */
    private @Nullable Map<String,String> configuration;
    /**
     * @return A list of artifact names to be worked on.
     * 
     */
    private @Nullable List<String> inputArtifacts;
    /**
     * @return The action declaration&#39;s name.
     * 
     */
    private String name;
    /**
     * @return The namespace all output variables will be accessed from.
     * 
     * &gt; **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     * 
     */
    private @Nullable String namespace;
    /**
     * @return A list of artifact names to output. Output artifact names must be unique within a pipeline.
     * 
     */
    private @Nullable List<String> outputArtifacts;
    /**
     * @return The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
     * 
     */
    private String owner;
    /**
     * @return The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     * 
     */
    private String provider;
    /**
     * @return The region in which to run the action.
     * 
     */
    private @Nullable String region;
    /**
     * @return The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
     * 
     */
    private @Nullable String roleArn;
    /**
     * @return The order in which actions are run.
     * 
     */
    private @Nullable Integer runOrder;
    /**
     * @return A string that identifies the action type.
     * 
     */
    private String version;

    private PipelineStageAction() {}
    /**
     * @return A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Possible values are `Approval`, `Build`, `Deploy`, `Invoke`, `Source` and `Test`.
     * 
     */
    public String category() {
        return this.category;
    }
    /**
     * @return A map of the action declaration&#39;s configuration. Configurations options for action types and providers can be found in the [Pipeline Structure Reference](http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements) and [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     * 
     */
    public Map<String,String> configuration() {
        return this.configuration == null ? Map.of() : this.configuration;
    }
    /**
     * @return A list of artifact names to be worked on.
     * 
     */
    public List<String> inputArtifacts() {
        return this.inputArtifacts == null ? List.of() : this.inputArtifacts;
    }
    /**
     * @return The action declaration&#39;s name.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return The namespace all output variables will be accessed from.
     * 
     * &gt; **Note:** The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
     * 
     */
    public Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }
    /**
     * @return A list of artifact names to output. Output artifact names must be unique within a pipeline.
     * 
     */
    public List<String> outputArtifacts() {
        return this.outputArtifacts == null ? List.of() : this.outputArtifacts;
    }
    /**
     * @return The creator of the action being called. Possible values are `AWS`, `Custom` and `ThirdParty`.
     * 
     */
    public String owner() {
        return this.owner;
    }
    /**
     * @return The provider of the service being called by the action. Valid providers are determined by the action category. Provider names are listed in the [Action Structure Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html) documentation.
     * 
     */
    public String provider() {
        return this.provider;
    }
    /**
     * @return The region in which to run the action.
     * 
     */
    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }
    /**
     * @return The ARN of the IAM service role that will perform the declared action. This is assumed through the roleArn for the pipeline.
     * 
     */
    public Optional<String> roleArn() {
        return Optional.ofNullable(this.roleArn);
    }
    /**
     * @return The order in which actions are run.
     * 
     */
    public Optional<Integer> runOrder() {
        return Optional.ofNullable(this.runOrder);
    }
    /**
     * @return A string that identifies the action type.
     * 
     */
    public String version() {
        return this.version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PipelineStageAction defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String category;
        private @Nullable Map<String,String> configuration;
        private @Nullable List<String> inputArtifacts;
        private String name;
        private @Nullable String namespace;
        private @Nullable List<String> outputArtifacts;
        private String owner;
        private String provider;
        private @Nullable String region;
        private @Nullable String roleArn;
        private @Nullable Integer runOrder;
        private String version;
        public Builder() {}
        public Builder(PipelineStageAction defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.category = defaults.category;
    	      this.configuration = defaults.configuration;
    	      this.inputArtifacts = defaults.inputArtifacts;
    	      this.name = defaults.name;
    	      this.namespace = defaults.namespace;
    	      this.outputArtifacts = defaults.outputArtifacts;
    	      this.owner = defaults.owner;
    	      this.provider = defaults.provider;
    	      this.region = defaults.region;
    	      this.roleArn = defaults.roleArn;
    	      this.runOrder = defaults.runOrder;
    	      this.version = defaults.version;
        }

        @CustomType.Setter
        public Builder category(String category) {
            this.category = Objects.requireNonNull(category);
            return this;
        }
        @CustomType.Setter
        public Builder configuration(@Nullable Map<String,String> configuration) {
            this.configuration = configuration;
            return this;
        }
        @CustomType.Setter
        public Builder inputArtifacts(@Nullable List<String> inputArtifacts) {
            this.inputArtifacts = inputArtifacts;
            return this;
        }
        public Builder inputArtifacts(String... inputArtifacts) {
            return inputArtifacts(List.of(inputArtifacts));
        }
        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }
        @CustomType.Setter
        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace;
            return this;
        }
        @CustomType.Setter
        public Builder outputArtifacts(@Nullable List<String> outputArtifacts) {
            this.outputArtifacts = outputArtifacts;
            return this;
        }
        public Builder outputArtifacts(String... outputArtifacts) {
            return outputArtifacts(List.of(outputArtifacts));
        }
        @CustomType.Setter
        public Builder owner(String owner) {
            this.owner = Objects.requireNonNull(owner);
            return this;
        }
        @CustomType.Setter
        public Builder provider(String provider) {
            this.provider = Objects.requireNonNull(provider);
            return this;
        }
        @CustomType.Setter
        public Builder region(@Nullable String region) {
            this.region = region;
            return this;
        }
        @CustomType.Setter
        public Builder roleArn(@Nullable String roleArn) {
            this.roleArn = roleArn;
            return this;
        }
        @CustomType.Setter
        public Builder runOrder(@Nullable Integer runOrder) {
            this.runOrder = runOrder;
            return this;
        }
        @CustomType.Setter
        public Builder version(String version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }
        public PipelineStageAction build() {
            final var o = new PipelineStageAction();
            o.category = category;
            o.configuration = configuration;
            o.inputArtifacts = inputArtifacts;
            o.name = name;
            o.namespace = namespace;
            o.outputArtifacts = outputArtifacts;
            o.owner = owner;
            o.provider = provider;
            o.region = region;
            o.roleArn = roleArn;
            o.runOrder = runOrder;
            o.version = version;
            return o;
        }
    }
}
