// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codecatalyst;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.codecatalyst.SourceRepositoryArgs;
import com.pulumi.aws.codecatalyst.inputs.SourceRepositoryState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS CodeCatalyst Source Repository.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codecatalyst.SourceRepository;
 * import com.pulumi.aws.codecatalyst.SourceRepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SourceRepository(&#34;example&#34;, SourceRepositoryArgs.builder()        
 *             .projectName(&#34;example-project&#34;)
 *             .spaceName(&#34;example-space&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import CodeCatalyst Source Repository using the `example_id_arg`. For exampleterraform import {
 * 
 *  to = aws_codecatalyst_source_repository.example
 * 
 *  id = &#34;source_repository-id-12345678&#34; } Using `TODO import`, import CodeCatalyst Source Repository using the `example_id_arg`. For exampleconsole % TODO import aws_codecatalyst_source_repository.example source_repository-id-12345678
 * 
 */
@ResourceType(type="aws:codecatalyst/sourceRepository:SourceRepository")
public class SourceRepository extends com.pulumi.resources.CustomResource {
    /**
     * The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the source repository. For more information about name requirements, see [Quotas for source repositories](https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html).
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The name of the project in the CodeCatalyst space.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="projectName", refs={String.class}, tree="[0]")
    private Output<String> projectName;

    /**
     * @return The name of the project in the CodeCatalyst space.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> projectName() {
        return this.projectName;
    }
    /**
     * The name of the CodeCatalyst space.
     * 
     */
    @Export(name="spaceName", refs={String.class}, tree="[0]")
    private Output<String> spaceName;

    /**
     * @return The name of the CodeCatalyst space.
     * 
     */
    public Output<String> spaceName() {
        return this.spaceName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SourceRepository(String name) {
        this(name, SourceRepositoryArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SourceRepository(String name, SourceRepositoryArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SourceRepository(String name, SourceRepositoryArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codecatalyst/sourceRepository:SourceRepository", name, args == null ? SourceRepositoryArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SourceRepository(String name, Output<String> id, @Nullable SourceRepositoryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codecatalyst/sourceRepository:SourceRepository", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SourceRepository get(String name, Output<String> id, @Nullable SourceRepositoryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SourceRepository(name, id, state, options);
    }
}
