// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codecatalyst;

import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentIdesArgs;
import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentPersistentStorageArgs;
import com.pulumi.aws.codecatalyst.inputs.DevEnvironmentRepositoryArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DevEnvironmentArgs extends com.pulumi.resources.ResourceArgs {

    public static final DevEnvironmentArgs Empty = new DevEnvironmentArgs();

    @Import(name="alias")
    private @Nullable Output<String> alias;

    public Optional<Output<String>> alias() {
        return Optional.ofNullable(this.alias);
    }

    /**
     * Information about the integrated development environment (IDE) configured for a Dev Environment.
     * 
     */
    @Import(name="ides", required=true)
    private Output<DevEnvironmentIdesArgs> ides;

    /**
     * @return Information about the integrated development environment (IDE) configured for a Dev Environment.
     * 
     */
    public Output<DevEnvironmentIdesArgs> ides() {
        return this.ides;
    }

    /**
     * The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     * 
     */
    @Import(name="inactivityTimeoutMinutes")
    private @Nullable Output<Integer> inactivityTimeoutMinutes;

    /**
     * @return The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
     * 
     */
    public Optional<Output<Integer>> inactivityTimeoutMinutes() {
        return Optional.ofNullable(this.inactivityTimeoutMinutes);
    }

    /**
     * The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="instanceType", required=true)
    private Output<String> instanceType;

    /**
     * @return The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> instanceType() {
        return this.instanceType;
    }

    /**
     * Information about the amount of storage allocated to the Dev Environment.
     * 
     */
    @Import(name="persistentStorage", required=true)
    private Output<DevEnvironmentPersistentStorageArgs> persistentStorage;

    /**
     * @return Information about the amount of storage allocated to the Dev Environment.
     * 
     */
    public Output<DevEnvironmentPersistentStorageArgs> persistentStorage() {
        return this.persistentStorage;
    }

    /**
     * The name of the project in the space.
     * 
     */
    @Import(name="projectName", required=true)
    private Output<String> projectName;

    /**
     * @return The name of the project in the space.
     * 
     */
    public Output<String> projectName() {
        return this.projectName;
    }

    /**
     * The source repository that contains the branch to clone into the Dev Environment.
     * 
     */
    @Import(name="repositories")
    private @Nullable Output<List<DevEnvironmentRepositoryArgs>> repositories;

    /**
     * @return The source repository that contains the branch to clone into the Dev Environment.
     * 
     */
    public Optional<Output<List<DevEnvironmentRepositoryArgs>>> repositories() {
        return Optional.ofNullable(this.repositories);
    }

    /**
     * The name of the space.
     * 
     */
    @Import(name="spaceName", required=true)
    private Output<String> spaceName;

    /**
     * @return The name of the space.
     * 
     */
    public Output<String> spaceName() {
        return this.spaceName;
    }

    private DevEnvironmentArgs() {}

    private DevEnvironmentArgs(DevEnvironmentArgs $) {
        this.alias = $.alias;
        this.ides = $.ides;
        this.inactivityTimeoutMinutes = $.inactivityTimeoutMinutes;
        this.instanceType = $.instanceType;
        this.persistentStorage = $.persistentStorage;
        this.projectName = $.projectName;
        this.repositories = $.repositories;
        this.spaceName = $.spaceName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DevEnvironmentArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DevEnvironmentArgs $;

        public Builder() {
            $ = new DevEnvironmentArgs();
        }

        public Builder(DevEnvironmentArgs defaults) {
            $ = new DevEnvironmentArgs(Objects.requireNonNull(defaults));
        }

        public Builder alias(@Nullable Output<String> alias) {
            $.alias = alias;
            return this;
        }

        public Builder alias(String alias) {
            return alias(Output.of(alias));
        }

        /**
         * @param ides Information about the integrated development environment (IDE) configured for a Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder ides(Output<DevEnvironmentIdesArgs> ides) {
            $.ides = ides;
            return this;
        }

        /**
         * @param ides Information about the integrated development environment (IDE) configured for a Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder ides(DevEnvironmentIdesArgs ides) {
            return ides(Output.of(ides));
        }

        /**
         * @param inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
         * 
         * @return builder
         * 
         */
        public Builder inactivityTimeoutMinutes(@Nullable Output<Integer> inactivityTimeoutMinutes) {
            $.inactivityTimeoutMinutes = inactivityTimeoutMinutes;
            return this;
        }

        /**
         * @param inactivityTimeoutMinutes The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
         * 
         * @return builder
         * 
         */
        public Builder inactivityTimeoutMinutes(Integer inactivityTimeoutMinutes) {
            return inactivityTimeoutMinutes(Output.of(inactivityTimeoutMinutes));
        }

        /**
         * @param instanceType The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder instanceType(Output<String> instanceType) {
            $.instanceType = instanceType;
            return this;
        }

        /**
         * @param instanceType The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder instanceType(String instanceType) {
            return instanceType(Output.of(instanceType));
        }

        /**
         * @param persistentStorage Information about the amount of storage allocated to the Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder persistentStorage(Output<DevEnvironmentPersistentStorageArgs> persistentStorage) {
            $.persistentStorage = persistentStorage;
            return this;
        }

        /**
         * @param persistentStorage Information about the amount of storage allocated to the Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder persistentStorage(DevEnvironmentPersistentStorageArgs persistentStorage) {
            return persistentStorage(Output.of(persistentStorage));
        }

        /**
         * @param projectName The name of the project in the space.
         * 
         * @return builder
         * 
         */
        public Builder projectName(Output<String> projectName) {
            $.projectName = projectName;
            return this;
        }

        /**
         * @param projectName The name of the project in the space.
         * 
         * @return builder
         * 
         */
        public Builder projectName(String projectName) {
            return projectName(Output.of(projectName));
        }

        /**
         * @param repositories The source repository that contains the branch to clone into the Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder repositories(@Nullable Output<List<DevEnvironmentRepositoryArgs>> repositories) {
            $.repositories = repositories;
            return this;
        }

        /**
         * @param repositories The source repository that contains the branch to clone into the Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder repositories(List<DevEnvironmentRepositoryArgs> repositories) {
            return repositories(Output.of(repositories));
        }

        /**
         * @param repositories The source repository that contains the branch to clone into the Dev Environment.
         * 
         * @return builder
         * 
         */
        public Builder repositories(DevEnvironmentRepositoryArgs... repositories) {
            return repositories(List.of(repositories));
        }

        /**
         * @param spaceName The name of the space.
         * 
         * @return builder
         * 
         */
        public Builder spaceName(Output<String> spaceName) {
            $.spaceName = spaceName;
            return this;
        }

        /**
         * @param spaceName The name of the space.
         * 
         * @return builder
         * 
         */
        public Builder spaceName(String spaceName) {
            return spaceName(Output.of(spaceName));
        }

        public DevEnvironmentArgs build() {
            $.ides = Objects.requireNonNull($.ides, "expected parameter 'ides' to be non-null");
            $.instanceType = Objects.requireNonNull($.instanceType, "expected parameter 'instanceType' to be non-null");
            $.persistentStorage = Objects.requireNonNull($.persistentStorage, "expected parameter 'persistentStorage' to be non-null");
            $.projectName = Objects.requireNonNull($.projectName, "expected parameter 'projectName' to be non-null");
            $.spaceName = Objects.requireNonNull($.spaceName, "expected parameter 'spaceName' to be non-null");
            return $;
        }
    }

}
