// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codebuild.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ProjectCache {
    /**
     * @return Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
     * 
     */
    private @Nullable String location;
    /**
     * @return Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     * 
     */
    private @Nullable List<String> modes;
    /**
     * @return Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
     * 
     */
    private @Nullable String type;

    private ProjectCache() {}
    /**
     * @return Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
     * 
     */
    public Optional<String> location() {
        return Optional.ofNullable(this.location);
    }
    /**
     * @return Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
     * 
     */
    public List<String> modes() {
        return this.modes == null ? List.of() : this.modes;
    }
    /**
     * @return Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
     * 
     */
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectCache defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String location;
        private @Nullable List<String> modes;
        private @Nullable String type;
        public Builder() {}
        public Builder(ProjectCache defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.location = defaults.location;
    	      this.modes = defaults.modes;
    	      this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder location(@Nullable String location) {
            this.location = location;
            return this;
        }
        @CustomType.Setter
        public Builder modes(@Nullable List<String> modes) {
            this.modes = modes;
            return this;
        }
        public Builder modes(String... modes) {
            return modes(List.of(modes));
        }
        @CustomType.Setter
        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }
        public ProjectCache build() {
            final var o = new ProjectCache();
            o.location = location;
            o.modes = modes;
            o.type = type;
            return o;
        }
    }
}
