// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codebuild.inputs;

import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceBuildStatusConfigArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceGitSubmodulesConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProjectSecondarySourceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ProjectSecondarySourceArgs Empty = new ProjectSecondarySourceArgs();

    /**
     * Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
     * 
     */
    @Import(name="buildStatusConfig")
    private @Nullable Output<ProjectSecondarySourceBuildStatusConfigArgs> buildStatusConfig;

    /**
     * @return Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
     * 
     */
    public Optional<Output<ProjectSecondarySourceBuildStatusConfigArgs>> buildStatusConfig() {
        return Optional.ofNullable(this.buildStatusConfig);
    }

    /**
     * The build spec declaration to use for this build project&#39;s related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
     * 
     */
    @Import(name="buildspec")
    private @Nullable Output<String> buildspec;

    /**
     * @return The build spec declaration to use for this build project&#39;s related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
     * 
     */
    public Optional<Output<String>> buildspec() {
        return Optional.ofNullable(this.buildspec);
    }

    /**
     * Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     * 
     */
    @Import(name="gitCloneDepth")
    private @Nullable Output<Integer> gitCloneDepth;

    /**
     * @return Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
     * 
     */
    public Optional<Output<Integer>> gitCloneDepth() {
        return Optional.ofNullable(this.gitCloneDepth);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="gitSubmodulesConfig")
    private @Nullable Output<ProjectSecondarySourceGitSubmodulesConfigArgs> gitSubmodulesConfig;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<ProjectSecondarySourceGitSubmodulesConfigArgs>> gitSubmodulesConfig() {
        return Optional.ofNullable(this.gitSubmodulesConfig);
    }

    /**
     * Ignore SSL warnings when connecting to source control.
     * 
     */
    @Import(name="insecureSsl")
    private @Nullable Output<Boolean> insecureSsl;

    /**
     * @return Ignore SSL warnings when connecting to source control.
     * 
     */
    public Optional<Output<Boolean>> insecureSsl() {
        return Optional.ofNullable(this.insecureSsl);
    }

    /**
     * Location of the source code from git or s3.
     * 
     */
    @Import(name="location")
    private @Nullable Output<String> location;

    /**
     * @return Location of the source code from git or s3.
     * 
     */
    public Optional<Output<String>> location() {
        return Optional.ofNullable(this.location);
    }

    /**
     * Whether to report the status of a build&#39;s start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
     * 
     */
    @Import(name="reportBuildStatus")
    private @Nullable Output<Boolean> reportBuildStatus;

    /**
     * @return Whether to report the status of a build&#39;s start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
     * 
     */
    public Optional<Output<Boolean>> reportBuildStatus() {
        return Optional.ofNullable(this.reportBuildStatus);
    }

    /**
     * An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     * 
     */
    @Import(name="sourceIdentifier", required=true)
    private Output<String> sourceIdentifier;

    /**
     * @return An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
     * 
     */
    public Output<String> sourceIdentifier() {
        return this.sourceIdentifier;
    }

    /**
     * Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    private ProjectSecondarySourceArgs() {}

    private ProjectSecondarySourceArgs(ProjectSecondarySourceArgs $) {
        this.buildStatusConfig = $.buildStatusConfig;
        this.buildspec = $.buildspec;
        this.gitCloneDepth = $.gitCloneDepth;
        this.gitSubmodulesConfig = $.gitSubmodulesConfig;
        this.insecureSsl = $.insecureSsl;
        this.location = $.location;
        this.reportBuildStatus = $.reportBuildStatus;
        this.sourceIdentifier = $.sourceIdentifier;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProjectSecondarySourceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProjectSecondarySourceArgs $;

        public Builder() {
            $ = new ProjectSecondarySourceArgs();
        }

        public Builder(ProjectSecondarySourceArgs defaults) {
            $ = new ProjectSecondarySourceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
         * 
         * @return builder
         * 
         */
        public Builder buildStatusConfig(@Nullable Output<ProjectSecondarySourceBuildStatusConfigArgs> buildStatusConfig) {
            $.buildStatusConfig = buildStatusConfig;
            return this;
        }

        /**
         * @param buildStatusConfig Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`. `build_status_config` blocks are documented below.
         * 
         * @return builder
         * 
         */
        public Builder buildStatusConfig(ProjectSecondarySourceBuildStatusConfigArgs buildStatusConfig) {
            return buildStatusConfig(Output.of(buildStatusConfig));
        }

        /**
         * @param buildspec The build spec declaration to use for this build project&#39;s related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
         * 
         * @return builder
         * 
         */
        public Builder buildspec(@Nullable Output<String> buildspec) {
            $.buildspec = buildspec;
            return this;
        }

        /**
         * @param buildspec The build spec declaration to use for this build project&#39;s related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
         * 
         * @return builder
         * 
         */
        public Builder buildspec(String buildspec) {
            return buildspec(Output.of(buildspec));
        }

        /**
         * @param gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder gitCloneDepth(@Nullable Output<Integer> gitCloneDepth) {
            $.gitCloneDepth = gitCloneDepth;
            return this;
        }

        /**
         * @param gitCloneDepth Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
         * 
         * @return builder
         * 
         */
        public Builder gitCloneDepth(Integer gitCloneDepth) {
            return gitCloneDepth(Output.of(gitCloneDepth));
        }

        /**
         * @param gitSubmodulesConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder gitSubmodulesConfig(@Nullable Output<ProjectSecondarySourceGitSubmodulesConfigArgs> gitSubmodulesConfig) {
            $.gitSubmodulesConfig = gitSubmodulesConfig;
            return this;
        }

        /**
         * @param gitSubmodulesConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder gitSubmodulesConfig(ProjectSecondarySourceGitSubmodulesConfigArgs gitSubmodulesConfig) {
            return gitSubmodulesConfig(Output.of(gitSubmodulesConfig));
        }

        /**
         * @param insecureSsl Ignore SSL warnings when connecting to source control.
         * 
         * @return builder
         * 
         */
        public Builder insecureSsl(@Nullable Output<Boolean> insecureSsl) {
            $.insecureSsl = insecureSsl;
            return this;
        }

        /**
         * @param insecureSsl Ignore SSL warnings when connecting to source control.
         * 
         * @return builder
         * 
         */
        public Builder insecureSsl(Boolean insecureSsl) {
            return insecureSsl(Output.of(insecureSsl));
        }

        /**
         * @param location Location of the source code from git or s3.
         * 
         * @return builder
         * 
         */
        public Builder location(@Nullable Output<String> location) {
            $.location = location;
            return this;
        }

        /**
         * @param location Location of the source code from git or s3.
         * 
         * @return builder
         * 
         */
        public Builder location(String location) {
            return location(Output.of(location));
        }

        /**
         * @param reportBuildStatus Whether to report the status of a build&#39;s start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
         * 
         * @return builder
         * 
         */
        public Builder reportBuildStatus(@Nullable Output<Boolean> reportBuildStatus) {
            $.reportBuildStatus = reportBuildStatus;
            return this;
        }

        /**
         * @param reportBuildStatus Whether to report the status of a build&#39;s start and finish to your source provider. This option is only valid when your source provider is `GITHUB`, `BITBUCKET`, or `GITHUB_ENTERPRISE`.
         * 
         * @return builder
         * 
         */
        public Builder reportBuildStatus(Boolean reportBuildStatus) {
            return reportBuildStatus(Output.of(reportBuildStatus));
        }

        /**
         * @param sourceIdentifier An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder sourceIdentifier(Output<String> sourceIdentifier) {
            $.sourceIdentifier = sourceIdentifier;
            return this;
        }

        /**
         * @param sourceIdentifier An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
         * 
         * @return builder
         * 
         */
        public Builder sourceIdentifier(String sourceIdentifier) {
            return sourceIdentifier(Output.of(sourceIdentifier));
        }

        /**
         * @param type Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of repository that contains the source code to be built. Valid values: `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `BITBUCKET` or `S3`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ProjectSecondarySourceArgs build() {
            $.sourceIdentifier = Objects.requireNonNull($.sourceIdentifier, "expected parameter 'sourceIdentifier' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
