// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codebuild;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.codebuild.WebhookArgs;
import com.pulumi.aws.codebuild.inputs.WebhookState;
import com.pulumi.aws.codebuild.outputs.WebhookFilterGroup;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a CodeBuild webhook, which is an endpoint accepted by the CodeBuild service to trigger builds from source code repositories. Depending on the source type of the CodeBuild project, the CodeBuild service may also automatically create and delete the actual repository webhook as well.
 * 
 * ## Example Usage
 * ### Bitbucket and GitHub
 * 
 * When working with [Bitbucket](https://bitbucket.org) and [GitHub](https://github.com) source CodeBuild webhooks, the CodeBuild service will automatically create (on `aws.codebuild.Webhook` resource creation) and delete (on `aws.codebuild.Webhook` resource deletion) the Bitbucket/GitHub repository webhook using its granted OAuth permissions. This behavior cannot be controlled by this provider.
 * 
 * &gt; **Note:** The AWS account that this provider uses to create this resource *must* have authorized CodeBuild to access Bitbucket/GitHub&#39;s OAuth API in each applicable region. This is a manual step that must be done *before* creating webhooks with this resource. If OAuth is not configured, AWS will return an error similar to `ResourceNotFoundException: Could not find access token for server type github`. More information can be found in the CodeBuild User Guide for [Bitbucket](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-bitbucket-pull-request.html) and [GitHub](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-pull-request.html).
 * 
 * &gt; **Note:** Further managing the automatically created Bitbucket/GitHub webhook with the `bitbucket_hook`/`github_repository_webhook` resource is only possible with importing that resource after creation of the `aws.codebuild.Webhook` resource. The CodeBuild API does not ever provide the `secret` attribute for the `aws.codebuild.Webhook` resource in this scenario.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Webhook(&#34;example&#34;, WebhookArgs.builder()        
 *             .projectName(aws_codebuild_project.example().name())
 *             .buildType(&#34;BUILD&#34;)
 *             .filterGroups(WebhookFilterGroupArgs.builder()
 *                 .filters(                
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type(&#34;EVENT&#34;)
 *                         .pattern(&#34;PUSH&#34;)
 *                         .build(),
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type(&#34;BASE_REF&#34;)
 *                         .pattern(&#34;master&#34;)
 *                         .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### GitHub Enterprise
 * 
 * When working with [GitHub Enterprise](https://enterprise.github.com/) source CodeBuild webhooks, the GHE repository webhook must be separately managed (e.g., manually or with the `github_repository_webhook` resource).
 * 
 * More information creating webhooks with GitHub Enterprise can be found in the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-enterprise.html).
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.github.RepositoryWebhook;
 * import com.pulumi.github.RepositoryWebhookArgs;
 * import com.pulumi.github.inputs.RepositoryWebhookConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleWebhook = new Webhook(&#34;exampleWebhook&#34;, WebhookArgs.builder()        
 *             .projectName(aws_codebuild_project.example().name())
 *             .build());
 * 
 *         var exampleRepositoryWebhook = new RepositoryWebhook(&#34;exampleRepositoryWebhook&#34;, RepositoryWebhookArgs.builder()        
 *             .active(true)
 *             .events(&#34;push&#34;)
 *             .repository(github_repository.example().name())
 *             .configuration(RepositoryWebhookConfigurationArgs.builder()
 *                 .url(exampleWebhook.payloadUrl())
 *                 .secret(exampleWebhook.secret())
 *                 .contentType(&#34;json&#34;)
 *                 .insecureSsl(false)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import CodeBuild Webhooks using the CodeBuild Project name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:codebuild/webhook:Webhook example MyProjectName
 * ```
 * 
 */
@ResourceType(type="aws:codebuild/webhook:Webhook")
public class Webhook extends com.pulumi.resources.CustomResource {
    /**
     * A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     * 
     */
    @Export(name="branchFilter", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> branchFilter;

    /**
     * @return A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     * 
     */
    public Output<Optional<String>> branchFilter() {
        return Codegen.optional(this.branchFilter);
    }
    /**
     * The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     * 
     */
    @Export(name="buildType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> buildType;

    /**
     * @return The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     * 
     */
    public Output<Optional<String>> buildType() {
        return Codegen.optional(this.buildType);
    }
    /**
     * Information about the webhook&#39;s trigger. Filter group blocks are documented below.
     * 
     */
    @Export(name="filterGroups", refs={List.class,WebhookFilterGroup.class}, tree="[0,1]")
    private Output</* @Nullable */ List<WebhookFilterGroup>> filterGroups;

    /**
     * @return Information about the webhook&#39;s trigger. Filter group blocks are documented below.
     * 
     */
    public Output<Optional<List<WebhookFilterGroup>>> filterGroups() {
        return Codegen.optional(this.filterGroups);
    }
    /**
     * The CodeBuild endpoint where webhook events are sent.
     * 
     */
    @Export(name="payloadUrl", refs={String.class}, tree="[0]")
    private Output<String> payloadUrl;

    /**
     * @return The CodeBuild endpoint where webhook events are sent.
     * 
     */
    public Output<String> payloadUrl() {
        return this.payloadUrl;
    }
    /**
     * The name of the build project.
     * 
     */
    @Export(name="projectName", refs={String.class}, tree="[0]")
    private Output<String> projectName;

    /**
     * @return The name of the build project.
     * 
     */
    public Output<String> projectName() {
        return this.projectName;
    }
    /**
     * The secret token of the associated repository. Not returned by the CodeBuild API for all source types.
     * 
     */
    @Export(name="secret", refs={String.class}, tree="[0]")
    private Output<String> secret;

    /**
     * @return The secret token of the associated repository. Not returned by the CodeBuild API for all source types.
     * 
     */
    public Output<String> secret() {
        return this.secret;
    }
    /**
     * The URL to the webhook.
     * 
     */
    @Export(name="url", refs={String.class}, tree="[0]")
    private Output<String> url;

    /**
     * @return The URL to the webhook.
     * 
     */
    public Output<String> url() {
        return this.url;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Webhook(String name) {
        this(name, WebhookArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Webhook(String name, WebhookArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Webhook(String name, WebhookArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codebuild/webhook:Webhook", name, args == null ? WebhookArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Webhook(String name, Output<String> id, @Nullable WebhookState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codebuild/webhook:Webhook", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "secret"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Webhook get(String name, Output<String> id, @Nullable WebhookState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Webhook(name, id, state, options);
    }
}
