// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codebuild;

import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
import com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs;
import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
import com.pulumi.aws.codebuild.inputs.ProjectFileSystemLocationArgs;
import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs;
import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProjectArgs extends com.pulumi.resources.ResourceArgs {

    public static final ProjectArgs Empty = new ProjectArgs();

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="artifacts", required=true)
    private Output<ProjectArtifactsArgs> artifacts;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Output<ProjectArtifactsArgs> artifacts() {
        return this.artifacts;
    }

    /**
     * Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     * 
     */
    @Import(name="badgeEnabled")
    private @Nullable Output<Boolean> badgeEnabled;

    /**
     * @return Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     * 
     */
    public Optional<Output<Boolean>> badgeEnabled() {
        return Optional.ofNullable(this.badgeEnabled);
    }

    /**
     * Defines the batch build options for the project.
     * 
     */
    @Import(name="buildBatchConfig")
    private @Nullable Output<ProjectBuildBatchConfigArgs> buildBatchConfig;

    /**
     * @return Defines the batch build options for the project.
     * 
     */
    public Optional<Output<ProjectBuildBatchConfigArgs>> buildBatchConfig() {
        return Optional.ofNullable(this.buildBatchConfig);
    }

    /**
     * Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     * 
     */
    @Import(name="buildTimeout")
    private @Nullable Output<Integer> buildTimeout;

    /**
     * @return Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     * 
     */
    public Optional<Output<Integer>> buildTimeout() {
        return Optional.ofNullable(this.buildTimeout);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="cache")
    private @Nullable Output<ProjectCacheArgs> cache;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<ProjectCacheArgs>> cache() {
        return Optional.ofNullable(this.cache);
    }

    /**
     * Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     * 
     */
    @Import(name="concurrentBuildLimit")
    private @Nullable Output<Integer> concurrentBuildLimit;

    /**
     * @return Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     * 
     */
    public Optional<Output<Integer>> concurrentBuildLimit() {
        return Optional.ofNullable(this.concurrentBuildLimit);
    }

    /**
     * Short description of the project.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Short description of the project.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project&#39;s build output artifacts.
     * 
     */
    @Import(name="encryptionKey")
    private @Nullable Output<String> encryptionKey;

    /**
     * @return AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project&#39;s build output artifacts.
     * 
     */
    public Optional<Output<String>> encryptionKey() {
        return Optional.ofNullable(this.encryptionKey);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="environment", required=true)
    private Output<ProjectEnvironmentArgs> environment;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Output<ProjectEnvironmentArgs> environment() {
        return this.environment;
    }

    /**
     * A set of file system locations to mount inside the build. File system locations are documented below.
     * 
     */
    @Import(name="fileSystemLocations")
    private @Nullable Output<List<ProjectFileSystemLocationArgs>> fileSystemLocations;

    /**
     * @return A set of file system locations to mount inside the build. File system locations are documented below.
     * 
     */
    public Optional<Output<List<ProjectFileSystemLocationArgs>>> fileSystemLocations() {
        return Optional.ofNullable(this.fileSystemLocations);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="logsConfig")
    private @Nullable Output<ProjectLogsConfigArgs> logsConfig;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<ProjectLogsConfigArgs>> logsConfig() {
        return Optional.ofNullable(this.logsConfig);
    }

    /**
     * Project&#39;s name.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Project&#39;s name.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Specifies the visibility of the project&#39;s builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     * 
     */
    @Import(name="projectVisibility")
    private @Nullable Output<String> projectVisibility;

    /**
     * @return Specifies the visibility of the project&#39;s builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     * 
     */
    public Optional<Output<String>> projectVisibility() {
        return Optional.ofNullable(this.projectVisibility);
    }

    /**
     * Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
     * 
     */
    @Import(name="queuedTimeout")
    private @Nullable Output<Integer> queuedTimeout;

    /**
     * @return Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
     * 
     */
    public Optional<Output<Integer>> queuedTimeout() {
        return Optional.ofNullable(this.queuedTimeout);
    }

    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project&#39;s builds.
     * 
     */
    @Import(name="resourceAccessRole")
    private @Nullable Output<String> resourceAccessRole;

    /**
     * @return The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project&#39;s builds.
     * 
     */
    public Optional<Output<String>> resourceAccessRole() {
        return Optional.ofNullable(this.resourceAccessRole);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="secondaryArtifacts")
    private @Nullable Output<List<ProjectSecondaryArtifactArgs>> secondaryArtifacts;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<List<ProjectSecondaryArtifactArgs>>> secondaryArtifacts() {
        return Optional.ofNullable(this.secondaryArtifacts);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="secondarySourceVersions")
    private @Nullable Output<List<ProjectSecondarySourceVersionArgs>> secondarySourceVersions;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<List<ProjectSecondarySourceVersionArgs>>> secondarySourceVersions() {
        return Optional.ofNullable(this.secondarySourceVersions);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="secondarySources")
    private @Nullable Output<List<ProjectSecondarySourceArgs>> secondarySources;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<List<ProjectSecondarySourceArgs>>> secondarySources() {
        return Optional.ofNullable(this.secondarySources);
    }

    /**
     * Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     * 
     */
    @Import(name="serviceRole", required=true)
    private Output<String> serviceRole;

    /**
     * @return Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     * 
     */
    public Output<String> serviceRole() {
        return this.serviceRole;
    }

    /**
     * Configuration block. Detailed below.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="source", required=true)
    private Output<ProjectSourceArgs> source;

    /**
     * @return Configuration block. Detailed below.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<ProjectSourceArgs> source() {
        return this.source;
    }

    /**
     * Version of the build input to be built for this project. If not specified, the latest version is used.
     * 
     */
    @Import(name="sourceVersion")
    private @Nullable Output<String> sourceVersion;

    /**
     * @return Version of the build input to be built for this project. If not specified, the latest version is used.
     * 
     */
    public Optional<Output<String>> sourceVersion() {
        return Optional.ofNullable(this.sourceVersion);
    }

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Configuration block. Detailed below.
     * 
     */
    @Import(name="vpcConfig")
    private @Nullable Output<ProjectVpcConfigArgs> vpcConfig;

    /**
     * @return Configuration block. Detailed below.
     * 
     */
    public Optional<Output<ProjectVpcConfigArgs>> vpcConfig() {
        return Optional.ofNullable(this.vpcConfig);
    }

    private ProjectArgs() {}

    private ProjectArgs(ProjectArgs $) {
        this.artifacts = $.artifacts;
        this.badgeEnabled = $.badgeEnabled;
        this.buildBatchConfig = $.buildBatchConfig;
        this.buildTimeout = $.buildTimeout;
        this.cache = $.cache;
        this.concurrentBuildLimit = $.concurrentBuildLimit;
        this.description = $.description;
        this.encryptionKey = $.encryptionKey;
        this.environment = $.environment;
        this.fileSystemLocations = $.fileSystemLocations;
        this.logsConfig = $.logsConfig;
        this.name = $.name;
        this.projectVisibility = $.projectVisibility;
        this.queuedTimeout = $.queuedTimeout;
        this.resourceAccessRole = $.resourceAccessRole;
        this.secondaryArtifacts = $.secondaryArtifacts;
        this.secondarySourceVersions = $.secondarySourceVersions;
        this.secondarySources = $.secondarySources;
        this.serviceRole = $.serviceRole;
        this.source = $.source;
        this.sourceVersion = $.sourceVersion;
        this.tags = $.tags;
        this.vpcConfig = $.vpcConfig;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProjectArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProjectArgs $;

        public Builder() {
            $ = new ProjectArgs();
        }

        public Builder(ProjectArgs defaults) {
            $ = new ProjectArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param artifacts Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder artifacts(Output<ProjectArtifactsArgs> artifacts) {
            $.artifacts = artifacts;
            return this;
        }

        /**
         * @param artifacts Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder artifacts(ProjectArtifactsArgs artifacts) {
            return artifacts(Output.of(artifacts));
        }

        /**
         * @param badgeEnabled Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
         * 
         * @return builder
         * 
         */
        public Builder badgeEnabled(@Nullable Output<Boolean> badgeEnabled) {
            $.badgeEnabled = badgeEnabled;
            return this;
        }

        /**
         * @param badgeEnabled Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
         * 
         * @return builder
         * 
         */
        public Builder badgeEnabled(Boolean badgeEnabled) {
            return badgeEnabled(Output.of(badgeEnabled));
        }

        /**
         * @param buildBatchConfig Defines the batch build options for the project.
         * 
         * @return builder
         * 
         */
        public Builder buildBatchConfig(@Nullable Output<ProjectBuildBatchConfigArgs> buildBatchConfig) {
            $.buildBatchConfig = buildBatchConfig;
            return this;
        }

        /**
         * @param buildBatchConfig Defines the batch build options for the project.
         * 
         * @return builder
         * 
         */
        public Builder buildBatchConfig(ProjectBuildBatchConfigArgs buildBatchConfig) {
            return buildBatchConfig(Output.of(buildBatchConfig));
        }

        /**
         * @param buildTimeout Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
         * 
         * @return builder
         * 
         */
        public Builder buildTimeout(@Nullable Output<Integer> buildTimeout) {
            $.buildTimeout = buildTimeout;
            return this;
        }

        /**
         * @param buildTimeout Number of minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
         * 
         * @return builder
         * 
         */
        public Builder buildTimeout(Integer buildTimeout) {
            return buildTimeout(Output.of(buildTimeout));
        }

        /**
         * @param cache Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder cache(@Nullable Output<ProjectCacheArgs> cache) {
            $.cache = cache;
            return this;
        }

        /**
         * @param cache Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder cache(ProjectCacheArgs cache) {
            return cache(Output.of(cache));
        }

        /**
         * @param concurrentBuildLimit Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
         * 
         * @return builder
         * 
         */
        public Builder concurrentBuildLimit(@Nullable Output<Integer> concurrentBuildLimit) {
            $.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        /**
         * @param concurrentBuildLimit Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
         * 
         * @return builder
         * 
         */
        public Builder concurrentBuildLimit(Integer concurrentBuildLimit) {
            return concurrentBuildLimit(Output.of(concurrentBuildLimit));
        }

        /**
         * @param description Short description of the project.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Short description of the project.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param encryptionKey AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project&#39;s build output artifacts.
         * 
         * @return builder
         * 
         */
        public Builder encryptionKey(@Nullable Output<String> encryptionKey) {
            $.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * @param encryptionKey AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project&#39;s build output artifacts.
         * 
         * @return builder
         * 
         */
        public Builder encryptionKey(String encryptionKey) {
            return encryptionKey(Output.of(encryptionKey));
        }

        /**
         * @param environment Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder environment(Output<ProjectEnvironmentArgs> environment) {
            $.environment = environment;
            return this;
        }

        /**
         * @param environment Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder environment(ProjectEnvironmentArgs environment) {
            return environment(Output.of(environment));
        }

        /**
         * @param fileSystemLocations A set of file system locations to mount inside the build. File system locations are documented below.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemLocations(@Nullable Output<List<ProjectFileSystemLocationArgs>> fileSystemLocations) {
            $.fileSystemLocations = fileSystemLocations;
            return this;
        }

        /**
         * @param fileSystemLocations A set of file system locations to mount inside the build. File system locations are documented below.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemLocations(List<ProjectFileSystemLocationArgs> fileSystemLocations) {
            return fileSystemLocations(Output.of(fileSystemLocations));
        }

        /**
         * @param fileSystemLocations A set of file system locations to mount inside the build. File system locations are documented below.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemLocations(ProjectFileSystemLocationArgs... fileSystemLocations) {
            return fileSystemLocations(List.of(fileSystemLocations));
        }

        /**
         * @param logsConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder logsConfig(@Nullable Output<ProjectLogsConfigArgs> logsConfig) {
            $.logsConfig = logsConfig;
            return this;
        }

        /**
         * @param logsConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder logsConfig(ProjectLogsConfigArgs logsConfig) {
            return logsConfig(Output.of(logsConfig));
        }

        /**
         * @param name Project&#39;s name.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Project&#39;s name.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param projectVisibility Specifies the visibility of the project&#39;s builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
         * 
         * @return builder
         * 
         */
        public Builder projectVisibility(@Nullable Output<String> projectVisibility) {
            $.projectVisibility = projectVisibility;
            return this;
        }

        /**
         * @param projectVisibility Specifies the visibility of the project&#39;s builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
         * 
         * @return builder
         * 
         */
        public Builder projectVisibility(String projectVisibility) {
            return projectVisibility(Output.of(projectVisibility));
        }

        /**
         * @param queuedTimeout Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
         * 
         * @return builder
         * 
         */
        public Builder queuedTimeout(@Nullable Output<Integer> queuedTimeout) {
            $.queuedTimeout = queuedTimeout;
            return this;
        }

        /**
         * @param queuedTimeout Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours.
         * 
         * @return builder
         * 
         */
        public Builder queuedTimeout(Integer queuedTimeout) {
            return queuedTimeout(Output.of(queuedTimeout));
        }

        /**
         * @param resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project&#39;s builds.
         * 
         * @return builder
         * 
         */
        public Builder resourceAccessRole(@Nullable Output<String> resourceAccessRole) {
            $.resourceAccessRole = resourceAccessRole;
            return this;
        }

        /**
         * @param resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project&#39;s builds.
         * 
         * @return builder
         * 
         */
        public Builder resourceAccessRole(String resourceAccessRole) {
            return resourceAccessRole(Output.of(resourceAccessRole));
        }

        /**
         * @param secondaryArtifacts Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondaryArtifacts(@Nullable Output<List<ProjectSecondaryArtifactArgs>> secondaryArtifacts) {
            $.secondaryArtifacts = secondaryArtifacts;
            return this;
        }

        /**
         * @param secondaryArtifacts Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondaryArtifacts(List<ProjectSecondaryArtifactArgs> secondaryArtifacts) {
            return secondaryArtifacts(Output.of(secondaryArtifacts));
        }

        /**
         * @param secondaryArtifacts Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondaryArtifacts(ProjectSecondaryArtifactArgs... secondaryArtifacts) {
            return secondaryArtifacts(List.of(secondaryArtifacts));
        }

        /**
         * @param secondarySourceVersions Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySourceVersions(@Nullable Output<List<ProjectSecondarySourceVersionArgs>> secondarySourceVersions) {
            $.secondarySourceVersions = secondarySourceVersions;
            return this;
        }

        /**
         * @param secondarySourceVersions Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySourceVersions(List<ProjectSecondarySourceVersionArgs> secondarySourceVersions) {
            return secondarySourceVersions(Output.of(secondarySourceVersions));
        }

        /**
         * @param secondarySourceVersions Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySourceVersions(ProjectSecondarySourceVersionArgs... secondarySourceVersions) {
            return secondarySourceVersions(List.of(secondarySourceVersions));
        }

        /**
         * @param secondarySources Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySources(@Nullable Output<List<ProjectSecondarySourceArgs>> secondarySources) {
            $.secondarySources = secondarySources;
            return this;
        }

        /**
         * @param secondarySources Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySources(List<ProjectSecondarySourceArgs> secondarySources) {
            return secondarySources(Output.of(secondarySources));
        }

        /**
         * @param secondarySources Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder secondarySources(ProjectSecondarySourceArgs... secondarySources) {
            return secondarySources(List.of(secondarySources));
        }

        /**
         * @param serviceRole Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         * 
         * @return builder
         * 
         */
        public Builder serviceRole(Output<String> serviceRole) {
            $.serviceRole = serviceRole;
            return this;
        }

        /**
         * @param serviceRole Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         * 
         * @return builder
         * 
         */
        public Builder serviceRole(String serviceRole) {
            return serviceRole(Output.of(serviceRole));
        }

        /**
         * @param source Configuration block. Detailed below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder source(Output<ProjectSourceArgs> source) {
            $.source = source;
            return this;
        }

        /**
         * @param source Configuration block. Detailed below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder source(ProjectSourceArgs source) {
            return source(Output.of(source));
        }

        /**
         * @param sourceVersion Version of the build input to be built for this project. If not specified, the latest version is used.
         * 
         * @return builder
         * 
         */
        public Builder sourceVersion(@Nullable Output<String> sourceVersion) {
            $.sourceVersion = sourceVersion;
            return this;
        }

        /**
         * @param sourceVersion Version of the build input to be built for this project. If not specified, the latest version is used.
         * 
         * @return builder
         * 
         */
        public Builder sourceVersion(String sourceVersion) {
            return sourceVersion(Output.of(sourceVersion));
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param vpcConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder vpcConfig(@Nullable Output<ProjectVpcConfigArgs> vpcConfig) {
            $.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * @param vpcConfig Configuration block. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder vpcConfig(ProjectVpcConfigArgs vpcConfig) {
            return vpcConfig(Output.of(vpcConfig));
        }

        public ProjectArgs build() {
            $.artifacts = Objects.requireNonNull($.artifacts, "expected parameter 'artifacts' to be non-null");
            $.environment = Objects.requireNonNull($.environment, "expected parameter 'environment' to be non-null");
            $.serviceRole = Objects.requireNonNull($.serviceRole, "expected parameter 'serviceRole' to be non-null");
            $.source = Objects.requireNonNull($.source, "expected parameter 'source' to be non-null");
            return $;
        }
    }

}
