// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codeartifact;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RepositoryPermissionsPolicyArgs extends com.pulumi.resources.ResourceArgs {

    public static final RepositoryPermissionsPolicyArgs Empty = new RepositoryPermissionsPolicyArgs();

    /**
     * The name of the domain on which to set the resource policy.
     * 
     */
    @Import(name="domain", required=true)
    private Output<String> domain;

    /**
     * @return The name of the domain on which to set the resource policy.
     * 
     */
    public Output<String> domain() {
        return this.domain;
    }

    /**
     * The account number of the AWS account that owns the domain.
     * 
     */
    @Import(name="domainOwner")
    private @Nullable Output<String> domainOwner;

    /**
     * @return The account number of the AWS account that owns the domain.
     * 
     */
    public Optional<Output<String>> domainOwner() {
        return Optional.ofNullable(this.domainOwner);
    }

    /**
     * A JSON policy string to be set as the access control resource policy on the provided domain.
     * 
     */
    @Import(name="policyDocument", required=true)
    private Output<String> policyDocument;

    /**
     * @return A JSON policy string to be set as the access control resource policy on the provided domain.
     * 
     */
    public Output<String> policyDocument() {
        return this.policyDocument;
    }

    /**
     * The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
     * 
     */
    @Import(name="policyRevision")
    private @Nullable Output<String> policyRevision;

    /**
     * @return The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
     * 
     */
    public Optional<Output<String>> policyRevision() {
        return Optional.ofNullable(this.policyRevision);
    }

    /**
     * The name of the repository to set the resource policy on.
     * 
     */
    @Import(name="repository", required=true)
    private Output<String> repository;

    /**
     * @return The name of the repository to set the resource policy on.
     * 
     */
    public Output<String> repository() {
        return this.repository;
    }

    private RepositoryPermissionsPolicyArgs() {}

    private RepositoryPermissionsPolicyArgs(RepositoryPermissionsPolicyArgs $) {
        this.domain = $.domain;
        this.domainOwner = $.domainOwner;
        this.policyDocument = $.policyDocument;
        this.policyRevision = $.policyRevision;
        this.repository = $.repository;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RepositoryPermissionsPolicyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RepositoryPermissionsPolicyArgs $;

        public Builder() {
            $ = new RepositoryPermissionsPolicyArgs();
        }

        public Builder(RepositoryPermissionsPolicyArgs defaults) {
            $ = new RepositoryPermissionsPolicyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param domain The name of the domain on which to set the resource policy.
         * 
         * @return builder
         * 
         */
        public Builder domain(Output<String> domain) {
            $.domain = domain;
            return this;
        }

        /**
         * @param domain The name of the domain on which to set the resource policy.
         * 
         * @return builder
         * 
         */
        public Builder domain(String domain) {
            return domain(Output.of(domain));
        }

        /**
         * @param domainOwner The account number of the AWS account that owns the domain.
         * 
         * @return builder
         * 
         */
        public Builder domainOwner(@Nullable Output<String> domainOwner) {
            $.domainOwner = domainOwner;
            return this;
        }

        /**
         * @param domainOwner The account number of the AWS account that owns the domain.
         * 
         * @return builder
         * 
         */
        public Builder domainOwner(String domainOwner) {
            return domainOwner(Output.of(domainOwner));
        }

        /**
         * @param policyDocument A JSON policy string to be set as the access control resource policy on the provided domain.
         * 
         * @return builder
         * 
         */
        public Builder policyDocument(Output<String> policyDocument) {
            $.policyDocument = policyDocument;
            return this;
        }

        /**
         * @param policyDocument A JSON policy string to be set as the access control resource policy on the provided domain.
         * 
         * @return builder
         * 
         */
        public Builder policyDocument(String policyDocument) {
            return policyDocument(Output.of(policyDocument));
        }

        /**
         * @param policyRevision The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
         * 
         * @return builder
         * 
         */
        public Builder policyRevision(@Nullable Output<String> policyRevision) {
            $.policyRevision = policyRevision;
            return this;
        }

        /**
         * @param policyRevision The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
         * 
         * @return builder
         * 
         */
        public Builder policyRevision(String policyRevision) {
            return policyRevision(Output.of(policyRevision));
        }

        /**
         * @param repository The name of the repository to set the resource policy on.
         * 
         * @return builder
         * 
         */
        public Builder repository(Output<String> repository) {
            $.repository = repository;
            return this;
        }

        /**
         * @param repository The name of the repository to set the resource policy on.
         * 
         * @return builder
         * 
         */
        public Builder repository(String repository) {
            return repository(Output.of(repository));
        }

        public RepositoryPermissionsPolicyArgs build() {
            $.domain = Objects.requireNonNull($.domain, "expected parameter 'domain' to be non-null");
            $.policyDocument = Objects.requireNonNull($.policyDocument, "expected parameter 'policyDocument' to be non-null");
            $.repository = Objects.requireNonNull($.repository, "expected parameter 'repository' to be non-null");
            return $;
        }
    }

}
