// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.codeartifact;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.codeartifact.DomainPermissionsArgs;
import com.pulumi.aws.codeartifact.inputs.DomainPermissionsState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a CodeArtifact Domains Permissions Policy Resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.DomainPermissions;
 * import com.pulumi.aws.codeartifact.DomainPermissionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key(&#34;exampleKey&#34;, KeyArgs.builder()        
 *             .description(&#34;domain key&#34;)
 *             .build());
 * 
 *         var exampleDomain = new Domain(&#34;exampleDomain&#34;, DomainArgs.builder()        
 *             .domain(&#34;example&#34;)
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 * 
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;*&#34;)
 *                     .identifiers(&#34;*&#34;)
 *                     .build())
 *                 .actions(&#34;codeartifact:CreateRepository&#34;)
 *                 .resources(exampleDomain.arn())
 *                 .build())
 *             .build());
 * 
 *         var testDomainPermissions = new DomainPermissions(&#34;testDomainPermissions&#34;, DomainPermissionsArgs.builder()        
 *             .domain(exampleDomain.domain())
 *             .policyDocument(testPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(testPolicyDocument -&gt; testPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import CodeArtifact Domain Permissions Policies using the CodeArtifact Domain ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:codeartifact/domainPermissions:DomainPermissions example arn:aws:codeartifact:us-west-2:012345678912:domain/tf-acc-test-1928056699409417367
 * ```
 * 
 */
@ResourceType(type="aws:codeartifact/domainPermissions:DomainPermissions")
public class DomainPermissions extends com.pulumi.resources.CustomResource {
    /**
     * The name of the domain on which to set the resource policy.
     * 
     */
    @Export(name="domain", refs={String.class}, tree="[0]")
    private Output<String> domain;

    /**
     * @return The name of the domain on which to set the resource policy.
     * 
     */
    public Output<String> domain() {
        return this.domain;
    }
    /**
     * The account number of the AWS account that owns the domain.
     * 
     */
    @Export(name="domainOwner", refs={String.class}, tree="[0]")
    private Output<String> domainOwner;

    /**
     * @return The account number of the AWS account that owns the domain.
     * 
     */
    public Output<String> domainOwner() {
        return this.domainOwner;
    }
    /**
     * A JSON policy string to be set as the access control resource policy on the provided domain.
     * 
     */
    @Export(name="policyDocument", refs={String.class}, tree="[0]")
    private Output<String> policyDocument;

    /**
     * @return A JSON policy string to be set as the access control resource policy on the provided domain.
     * 
     */
    public Output<String> policyDocument() {
        return this.policyDocument;
    }
    /**
     * The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
     * 
     */
    @Export(name="policyRevision", refs={String.class}, tree="[0]")
    private Output<String> policyRevision;

    /**
     * @return The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain&#39;s resource policy.
     * 
     */
    public Output<String> policyRevision() {
        return this.policyRevision;
    }
    /**
     * The ARN of the resource associated with the resource policy.
     * 
     */
    @Export(name="resourceArn", refs={String.class}, tree="[0]")
    private Output<String> resourceArn;

    /**
     * @return The ARN of the resource associated with the resource policy.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DomainPermissions(String name) {
        this(name, DomainPermissionsArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DomainPermissions(String name, DomainPermissionsArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DomainPermissions(String name, DomainPermissionsArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codeartifact/domainPermissions:DomainPermissions", name, args == null ? DomainPermissionsArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DomainPermissions(String name, Output<String> id, @Nullable DomainPermissionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:codeartifact/domainPermissions:DomainPermissions", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DomainPermissions get(String name, Output<String> id, @Nullable DomainPermissionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DomainPermissions(name, id, state, options);
    }
}
