// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudwatch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudwatch.InternetMonitorArgs;
import com.pulumi.aws.cloudwatch.inputs.InternetMonitorState;
import com.pulumi.aws.cloudwatch.outputs.InternetMonitorHealthEventsConfig;
import com.pulumi.aws.cloudwatch.outputs.InternetMonitorInternetMeasurementsLogDelivery;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Internet Monitor Monitor resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.InternetMonitor;
 * import com.pulumi.aws.cloudwatch.InternetMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new InternetMonitor(&#34;example&#34;, InternetMonitorArgs.builder()        
 *             .monitorName(&#34;exmple&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Internet Monitor Monitors using the `monitor_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudwatch/internetMonitor:InternetMonitor some some-monitor
 * ```
 * 
 */
@ResourceType(type="aws:cloudwatch/internetMonitor:InternetMonitor")
public class InternetMonitor extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Monitor.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Monitor.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there&#39;s an internet issue that affects your application end users. See Health Events Config below.
     * 
     */
    @Export(name="healthEventsConfig", refs={InternetMonitorHealthEventsConfig.class}, tree="[0]")
    private Output</* @Nullable */ InternetMonitorHealthEventsConfig> healthEventsConfig;

    /**
     * @return Health event thresholds. A health event threshold percentage, for performance and availability, determines when Internet Monitor creates a health event when there&#39;s an internet issue that affects your application end users. See Health Events Config below.
     * 
     */
    public Output<Optional<InternetMonitorHealthEventsConfig>> healthEventsConfig() {
        return Codegen.optional(this.healthEventsConfig);
    }
    /**
     * Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     * 
     */
    @Export(name="internetMeasurementsLogDelivery", refs={InternetMonitorInternetMeasurementsLogDelivery.class}, tree="[0]")
    private Output</* @Nullable */ InternetMonitorInternetMeasurementsLogDelivery> internetMeasurementsLogDelivery;

    /**
     * @return Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.
     * 
     */
    public Output<Optional<InternetMonitorInternetMeasurementsLogDelivery>> internetMeasurementsLogDelivery() {
        return Codegen.optional(this.internetMeasurementsLogDelivery);
    }
    /**
     * The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
     * 
     */
    @Export(name="maxCityNetworksToMonitor", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> maxCityNetworksToMonitor;

    /**
     * @return The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network or ASN, such as an internet service provider (ISP), that clients access the resources through. This limit helps control billing costs.
     * 
     */
    public Output<Optional<Integer>> maxCityNetworksToMonitor() {
        return Codegen.optional(this.maxCityNetworksToMonitor);
    }
    /**
     * The name of the monitor.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="monitorName", refs={String.class}, tree="[0]")
    private Output<String> monitorName;

    /**
     * @return The name of the monitor.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> monitorName() {
        return this.monitorName;
    }
    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     * 
     */
    @Export(name="resources", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> resources;

    /**
     * @return The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     * 
     */
    public Output<Optional<List<String>>> resources() {
        return Codegen.optional(this.resources);
    }
    /**
     * The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> status;

    /**
     * @return The status for a monitor. The accepted values for Status with the UpdateMonitor API call are the following: `ACTIVE` and `INACTIVE`.
     * 
     */
    public Output<Optional<String>> status() {
        return Codegen.optional(this.status);
    }
    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     * 
     */
    @Export(name="trafficPercentageToMonitor", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> trafficPercentageToMonitor;

    /**
     * @return The percentage of the internet-facing traffic for your application that you want to monitor with this monitor.
     * 
     */
    public Output<Optional<Integer>> trafficPercentageToMonitor() {
        return Codegen.optional(this.trafficPercentageToMonitor);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public InternetMonitor(String name) {
        this(name, InternetMonitorArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public InternetMonitor(String name, InternetMonitorArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public InternetMonitor(String name, InternetMonitorArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/internetMonitor:InternetMonitor", name, args == null ? InternetMonitorArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private InternetMonitor(String name, Output<String> id, @Nullable InternetMonitorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/internetMonitor:InternetMonitor", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static InternetMonitor get(String name, Output<String> id, @Nullable InternetMonitorState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new InternetMonitor(name, id, state, options);
    }
}
