// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudwatch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudwatch.EventTargetArgs;
import com.pulumi.aws.cloudwatch.inputs.EventTargetState;
import com.pulumi.aws.cloudwatch.outputs.EventTargetBatchTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetDeadLetterConfig;
import com.pulumi.aws.cloudwatch.outputs.EventTargetEcsTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetHttpTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetInputTransformer;
import com.pulumi.aws.cloudwatch.outputs.EventTargetKinesisTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetRedshiftTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetRetryPolicy;
import com.pulumi.aws.cloudwatch.outputs.EventTargetRunCommandTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetSagemakerPipelineTarget;
import com.pulumi.aws.cloudwatch.outputs.EventTargetSqsTarget;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an EventBridge Target resource.
 * 
 * &gt; **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * 
 * ## Example Usage
 * ### Kinesis Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var console = new EventRule(&#34;console&#34;, EventRuleArgs.builder()        
 *             .description(&#34;Capture all EC2 scaling events&#34;)
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;source&#34;, jsonArray(&#34;aws.autoscaling&#34;)),
 *                     jsonProperty(&#34;detail-type&#34;, jsonArray(
 *                         &#34;EC2 Instance Launch Successful&#34;, 
 *                         &#34;EC2 Instance Terminate Successful&#34;, 
 *                         &#34;EC2 Instance Launch Unsuccessful&#34;, 
 *                         &#34;EC2 Instance Terminate Unsuccessful&#34;
 *                     ))
 *                 )))
 *             .build());
 * 
 *         var testStream = new Stream(&#34;testStream&#34;, StreamArgs.builder()        
 *             .shardCount(1)
 *             .build());
 * 
 *         var yada = new EventTarget(&#34;yada&#34;, EventTargetArgs.builder()        
 *             .rule(console.name())
 *             .arn(testStream.arn())
 *             .runCommandTargets(            
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key(&#34;tag:Name&#34;)
 *                     .values(&#34;FooBar&#34;)
 *                     .build(),
 *                 EventTargetRunCommandTargetArgs.builder()
 *                     .key(&#34;InstanceIds&#34;)
 *                     .values(&#34;i-162058cd308bffec2&#34;)
 *                     .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### SSM Document Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ssm.Document;
 * import com.pulumi.aws.ssm.DocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var ssmLifecycleTrust = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;events.amazonaws.com&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *         var stopInstance = new Document(&#34;stopInstance&#34;, DocumentArgs.builder()        
 *             .documentType(&#34;Command&#34;)
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;schemaVersion&#34;, &#34;1.2&#34;),
 *                     jsonProperty(&#34;description&#34;, &#34;Stop an instance&#34;),
 *                     jsonProperty(&#34;parameters&#34;, jsonObject(
 * 
 *                     )),
 *                     jsonProperty(&#34;runtimeConfig&#34;, jsonObject(
 *                         jsonProperty(&#34;aws:runShellScript&#34;, jsonObject(
 *                             jsonProperty(&#34;properties&#34;, jsonArray(jsonObject(
 *                                 jsonProperty(&#34;id&#34;, &#34;0.aws:runShellScript&#34;),
 *                                 jsonProperty(&#34;runCommand&#34;, jsonArray(&#34;halt&#34;))
 *                             )))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 * 
 *         final var ssmLifecyclePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(            
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(&#34;ssm:SendCommand&#34;)
 *                     .resources(&#34;arn:aws:ec2:eu-west-1:1234567890:instance/*&#34;)
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test(&#34;StringEquals&#34;)
 *                         .variable(&#34;ec2:ResourceTag/Terminate&#34;)
 *                         .values(&#34;*&#34;)
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(&#34;ssm:SendCommand&#34;)
 *                     .resources(stopInstance.arn())
 *                     .build())
 *             .build());
 * 
 *         var ssmLifecycleRole = new Role(&#34;ssmLifecycleRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(ssmLifecycleTrust.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var ssmLifecyclePolicy = new Policy(&#34;ssmLifecyclePolicy&#34;, PolicyArgs.builder()        
 *             .policy(ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(ssmLifecyclePolicyDocument -&gt; ssmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *         var ssmLifecycleRolePolicyAttachment = new RolePolicyAttachment(&#34;ssmLifecycleRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .policyArn(ssmLifecyclePolicy.arn())
 *             .role(ssmLifecycleRole.name())
 *             .build());
 * 
 *         var stopInstancesEventRule = new EventRule(&#34;stopInstancesEventRule&#34;, EventRuleArgs.builder()        
 *             .description(&#34;Stop instances nightly&#34;)
 *             .scheduleExpression(&#34;cron(0 0 * * ? *)&#34;)
 *             .build());
 * 
 *         var stopInstancesEventTarget = new EventTarget(&#34;stopInstancesEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(stopInstance.arn())
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(ssmLifecycleRole.arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key(&#34;tag:Terminate&#34;)
 *                 .values(&#34;midnight&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### RunCommand Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetRunCommandTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var stopInstancesEventRule = new EventRule(&#34;stopInstancesEventRule&#34;, EventRuleArgs.builder()        
 *             .description(&#34;Stop instances nightly&#34;)
 *             .scheduleExpression(&#34;cron(0 0 * * ? *)&#34;)
 *             .build());
 * 
 *         var stopInstancesEventTarget = new EventTarget(&#34;stopInstancesEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(String.format(&#34;arn:aws:ssm:%s::document/AWS-RunShellScript&#34;, var_.aws_region()))
 *             .input(&#34;{\&#34;commands\&#34;:[\&#34;halt\&#34;]}&#34;)
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(aws_iam_role.ssm_lifecycle().arn())
 *             .runCommandTargets(EventTargetRunCommandTargetArgs.builder()
 *                 .key(&#34;tag:Terminate&#34;)
 *                 .values(&#34;midnight&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### API Gateway target
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetHttpTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule(&#34;exampleEventRule&#34;);
 * 
 *         var exampleDeployment = new Deployment(&#34;exampleDeployment&#34;, DeploymentArgs.builder()        
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .build());
 * 
 *         var exampleStage = new Stage(&#34;exampleStage&#34;, StageArgs.builder()        
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .deployment(exampleDeployment.id())
 *             .build());
 * 
 *         var exampleEventTarget = new EventTarget(&#34;exampleEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(exampleStage.executionArn().applyValue(executionArn -&gt; String.format(&#34;%s/GET&#34;, executionArn)))
 *             .rule(exampleEventRule.id())
 *             .httpTarget(EventTargetHttpTargetArgs.builder()
 *                 .queryStringParameters(Map.of(&#34;Body&#34;, &#34;$.detail.body&#34;))
 *                 .headerParameters(Map.of(&#34;Env&#34;, &#34;Test&#34;))
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Cross-Account Event Bus target
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;events.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var eventBusInvokeRemoteEventBusRole = new Role(&#34;eventBusInvokeRemoteEventBusRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         final var eventBusInvokeRemoteEventBusPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .actions(&#34;events:PutEvents&#34;)
 *                 .resources(&#34;arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus&#34;)
 *                 .build())
 *             .build());
 * 
 *         var eventBusInvokeRemoteEventBusPolicy = new Policy(&#34;eventBusInvokeRemoteEventBusPolicy&#34;, PolicyArgs.builder()        
 *             .policy(eventBusInvokeRemoteEventBusPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var eventBusInvokeRemoteEventBusRolePolicyAttachment = new RolePolicyAttachment(&#34;eventBusInvokeRemoteEventBusRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .role(eventBusInvokeRemoteEventBusRole.name())
 *             .policyArn(eventBusInvokeRemoteEventBusPolicy.arn())
 *             .build());
 * 
 *         var stopInstancesEventRule = new EventRule(&#34;stopInstancesEventRule&#34;, EventRuleArgs.builder()        
 *             .description(&#34;Stop instances nightly&#34;)
 *             .scheduleExpression(&#34;cron(0 0 * * ? *)&#34;)
 *             .build());
 * 
 *         var stopInstancesEventTarget = new EventTarget(&#34;stopInstancesEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(&#34;arn:aws:events:eu-west-1:1234567890:event-bus/My-Event-Bus&#34;)
 *             .rule(stopInstancesEventRule.name())
 *             .roleArn(eventBusInvokeRemoteEventBusRole.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Input Transformer Usage - JSON Object
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule(&#34;exampleEventRule&#34;);
 * 
 *         var exampleEventTarget = new EventTarget(&#34;exampleEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry(&#34;instance&#34;, &#34;$.detail.instance&#34;),
 *                     Map.entry(&#34;status&#34;, &#34;$.detail.status&#34;)
 *                 ))
 *                 .inputTemplate(&#34;&#34;&#34;
 * {
 *   &#34;instance_id&#34;: &lt;instance&gt;,
 *   &#34;instance_status&#34;: &lt;status&gt;
 * }
 *                 &#34;&#34;&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Input Transformer Usage - Simple String
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleEventRule = new EventRule(&#34;exampleEventRule&#34;);
 * 
 *         var exampleEventTarget = new EventTarget(&#34;exampleEventTarget&#34;, EventTargetArgs.builder()        
 *             .arn(aws_lambda_function.example().arn())
 *             .rule(exampleEventRule.id())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry(&#34;instance&#34;, &#34;$.detail.instance&#34;),
 *                     Map.entry(&#34;status&#34;, &#34;$.detail.status&#34;)
 *                 ))
 *                 .inputTemplate(&#34;\&#34;&lt;instance&gt; is in state &lt;status&gt;\&#34;&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Cloudwatch Log Group Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup(&#34;exampleLogGroup&#34;, LogGroupArgs.builder()        
 *             .retentionInDays(1)
 *             .build());
 * 
 *         var exampleEventRule = new EventRule(&#34;exampleEventRule&#34;, EventRuleArgs.builder()        
 *             .description(&#34;GuardDuty Findings&#34;)
 *             .eventPattern(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;source&#34;, jsonArray(&#34;aws.guardduty&#34;))
 *                 )))
 *             .tags(Map.of(&#34;Environment&#34;, &#34;example&#34;))
 *             .build());
 * 
 *         final var exampleLogPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(            
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(&#34;logs:CreateLogStream&#34;)
 *                     .resources(exampleLogGroup.arn().applyValue(arn -&gt; String.format(&#34;%s:*&#34;, arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type(&#34;Service&#34;)
 *                         .identifiers(                        
 *                             &#34;events.amazonaws.com&#34;,
 *                             &#34;delivery.logs.amazonaws.com&#34;)
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(&#34;logs:PutLogEvents&#34;)
 *                     .resources(exampleLogGroup.arn().applyValue(arn -&gt; String.format(&#34;%s:*:*&#34;, arn)))
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type(&#34;Service&#34;)
 *                         .identifiers(                        
 *                             &#34;events.amazonaws.com&#34;,
 *                             &#34;delivery.logs.amazonaws.com&#34;)
 *                         .build())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test(&#34;ArnEquals&#34;)
 *                         .values(exampleEventRule.arn())
 *                         .variable(&#34;aws:SourceArn&#34;)
 *                         .build())
 *                     .build())
 *             .build());
 * 
 *         var exampleLogResourcePolicy = new LogResourcePolicy(&#34;exampleLogResourcePolicy&#34;, LogResourcePolicyArgs.builder()        
 *             .policyDocument(exampleLogPolicy.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(exampleLogPolicy -&gt; exampleLogPolicy.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .policyName(&#34;guardduty-log-publishing-policy&#34;)
 *             .build());
 * 
 *         var exampleEventTarget = new EventTarget(&#34;exampleEventTarget&#34;, EventTargetArgs.builder()        
 *             .rule(exampleEventRule.name())
 *             .arn(exampleLogGroup.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EventBridge Targets using `event_bus_name/rule-name/target-id` (if you omit `event_bus_name`, the `default` event bus will be used). For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudwatch/eventTarget:EventTarget test-event-target rule-name/target-id
 * ```
 * 
 */
@ResourceType(type="aws:cloudwatch/eventTarget:EventTarget")
public class EventTarget extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the target.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the target.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="batchTarget", refs={EventTargetBatchTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetBatchTarget> batchTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an Amazon Batch Job. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetBatchTarget>> batchTarget() {
        return Codegen.optional(this.batchTarget);
    }
    /**
     * Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="deadLetterConfig", refs={EventTargetDeadLetterConfig.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetDeadLetterConfig> deadLetterConfig;

    /**
     * @return Parameters used when you are providing a dead letter config. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetDeadLetterConfig>> deadLetterConfig() {
        return Codegen.optional(this.deadLetterConfig);
    }
    /**
     * Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="ecsTarget", refs={EventTargetEcsTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetEcsTarget> ecsTarget;

    /**
     * @return Parameters used when you are using the rule to invoke Amazon ECS Task. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetEcsTarget>> ecsTarget() {
        return Codegen.optional(this.ecsTarget);
    }
    /**
     * The name or ARN of the event bus to associate with the rule.
     * If you omit this, the `default` event bus is used.
     * 
     */
    @Export(name="eventBusName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> eventBusName;

    /**
     * @return The name or ARN of the event bus to associate with the rule.
     * If you omit this, the `default` event bus is used.
     * 
     */
    public Output<Optional<String>> eventBusName() {
        return Codegen.optional(this.eventBusName);
    }
    /**
     * Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     * 
     */
    @Export(name="httpTarget", refs={EventTargetHttpTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetHttpTarget> httpTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an API Gateway REST endpoint. Documented below. A maximum of 1 is allowed.
     * 
     */
    public Output<Optional<EventTargetHttpTarget>> httpTarget() {
        return Codegen.optional(this.httpTarget);
    }
    /**
     * Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
     * 
     */
    @Export(name="input", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> input;

    /**
     * @return Valid JSON text passed to the target. Conflicts with `input_path` and `input_transformer`.
     * 
     */
    public Output<Optional<String>> input() {
        return Codegen.optional(this.input);
    }
    /**
     * The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
     * 
     */
    @Export(name="inputPath", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> inputPath;

    /**
     * @return The value of the [JSONPath](http://goessner.net/articles/JsonPath/) that is used for extracting part of the matched event when passing it to the target. Conflicts with `input` and `input_transformer`.
     * 
     */
    public Output<Optional<String>> inputPath() {
        return Codegen.optional(this.inputPath);
    }
    /**
     * Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     * 
     */
    @Export(name="inputTransformer", refs={EventTargetInputTransformer.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetInputTransformer> inputTransformer;

    /**
     * @return Parameters used when you are providing a custom input to a target based on certain event data. Conflicts with `input` and `input_path`.
     * 
     */
    public Output<Optional<EventTargetInputTransformer>> inputTransformer() {
        return Codegen.optional(this.inputTransformer);
    }
    /**
     * Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="kinesisTarget", refs={EventTargetKinesisTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetKinesisTarget> kinesisTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an Amazon Kinesis Stream. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetKinesisTarget>> kinesisTarget() {
        return Codegen.optional(this.kinesisTarget);
    }
    /**
     * Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="redshiftTarget", refs={EventTargetRedshiftTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetRedshiftTarget> redshiftTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an Amazon Redshift Statement. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetRedshiftTarget>> redshiftTarget() {
        return Codegen.optional(this.redshiftTarget);
    }
    /**
     * Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="retryPolicy", refs={EventTargetRetryPolicy.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetRetryPolicy> retryPolicy;

    /**
     * @return Parameters used when you are providing retry policies. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetRetryPolicy>> retryPolicy() {
        return Codegen.optional(this.retryPolicy);
    }
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> roleArn;

    /**
     * @return The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. Required if `ecs_target` is used or target in `arn` is EC2 instance, Kinesis data stream, Step Functions state machine, or Event Bus in different account or region.
     * 
     */
    public Output<Optional<String>> roleArn() {
        return Codegen.optional(this.roleArn);
    }
    /**
     * The name of the rule you want to add targets to.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="rule", refs={String.class}, tree="[0]")
    private Output<String> rule;

    /**
     * @return The name of the rule you want to add targets to.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> rule() {
        return this.rule;
    }
    /**
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     * 
     */
    @Export(name="runCommandTargets", refs={List.class,EventTargetRunCommandTarget.class}, tree="[0,1]")
    private Output</* @Nullable */ List<EventTargetRunCommandTarget>> runCommandTargets;

    /**
     * @return Parameters used when you are using the rule to invoke Amazon EC2 Run Command. Documented below. A maximum of 5 are allowed.
     * 
     */
    public Output<Optional<List<EventTargetRunCommandTarget>>> runCommandTargets() {
        return Codegen.optional(this.runCommandTargets);
    }
    /**
     * Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="sagemakerPipelineTarget", refs={EventTargetSagemakerPipelineTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetSagemakerPipelineTarget> sagemakerPipelineTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an Amazon SageMaker Pipeline. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetSagemakerPipelineTarget>> sagemakerPipelineTarget() {
        return Codegen.optional(this.sagemakerPipelineTarget);
    }
    /**
     * Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     * 
     */
    @Export(name="sqsTarget", refs={EventTargetSqsTarget.class}, tree="[0]")
    private Output</* @Nullable */ EventTargetSqsTarget> sqsTarget;

    /**
     * @return Parameters used when you are using the rule to invoke an Amazon SQS Queue. Documented below. A maximum of 1 are allowed.
     * 
     */
    public Output<Optional<EventTargetSqsTarget>> sqsTarget() {
        return Codegen.optional(this.sqsTarget);
    }
    /**
     * The unique target assignment ID. If missing, will generate a random, unique id.
     * 
     */
    @Export(name="targetId", refs={String.class}, tree="[0]")
    private Output<String> targetId;

    /**
     * @return The unique target assignment ID. If missing, will generate a random, unique id.
     * 
     */
    public Output<String> targetId() {
        return this.targetId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EventTarget(String name) {
        this(name, EventTargetArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EventTarget(String name, EventTargetArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EventTarget(String name, EventTargetArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/eventTarget:EventTarget", name, args == null ? EventTargetArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EventTarget(String name, Output<String> id, @Nullable EventTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/eventTarget:EventTarget", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EventTarget get(String name, Output<String> id, @Nullable EventTargetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EventTarget(name, id, state, options);
    }
}
