// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudwatch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.cloudwatch.DashboardArgs;
import com.pulumi.aws.cloudwatch.inputs.DashboardState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a CloudWatch Dashboard resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.Dashboard;
 * import com.pulumi.aws.cloudwatch.DashboardArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var main = new Dashboard(&#34;main&#34;, DashboardArgs.builder()        
 *             .dashboardName(&#34;my-dashboard&#34;)
 *             .dashboardBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;widgets&#34;, jsonArray(
 *                         jsonObject(
 *                             jsonProperty(&#34;type&#34;, &#34;metric&#34;),
 *                             jsonProperty(&#34;x&#34;, 0),
 *                             jsonProperty(&#34;y&#34;, 0),
 *                             jsonProperty(&#34;width&#34;, 12),
 *                             jsonProperty(&#34;height&#34;, 6),
 *                             jsonProperty(&#34;properties&#34;, jsonObject(
 *                                 jsonProperty(&#34;metrics&#34;, jsonArray(jsonArray(
 *                                     &#34;AWS/EC2&#34;, 
 *                                     &#34;CPUUtilization&#34;, 
 *                                     &#34;InstanceId&#34;, 
 *                                     &#34;i-012345&#34;
 *                                 ))),
 *                                 jsonProperty(&#34;period&#34;, 300),
 *                                 jsonProperty(&#34;stat&#34;, &#34;Average&#34;),
 *                                 jsonProperty(&#34;region&#34;, &#34;us-east-1&#34;),
 *                                 jsonProperty(&#34;title&#34;, &#34;EC2 Instance CPU&#34;)
 *                             ))
 *                         ), 
 *                         jsonObject(
 *                             jsonProperty(&#34;type&#34;, &#34;text&#34;),
 *                             jsonProperty(&#34;x&#34;, 0),
 *                             jsonProperty(&#34;y&#34;, 7),
 *                             jsonProperty(&#34;width&#34;, 3),
 *                             jsonProperty(&#34;height&#34;, 3),
 *                             jsonProperty(&#34;properties&#34;, jsonObject(
 *                                 jsonProperty(&#34;markdown&#34;, &#34;Hello world&#34;)
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import CloudWatch dashboards using the `dashboard_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:cloudwatch/dashboard:Dashboard sample dashboard_name
 * ```
 * 
 */
@ResourceType(type="aws:cloudwatch/dashboard:Dashboard")
public class Dashboard extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the dashboard.
     * 
     */
    @Export(name="dashboardArn", refs={String.class}, tree="[0]")
    private Output<String> dashboardArn;

    /**
     * @return The Amazon Resource Name (ARN) of the dashboard.
     * 
     */
    public Output<String> dashboardArn() {
        return this.dashboardArn;
    }
    /**
     * The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
     * 
     */
    @Export(name="dashboardBody", refs={String.class}, tree="[0]")
    private Output<String> dashboardBody;

    /**
     * @return The detailed information about the dashboard, including what widgets are included and their location on the dashboard. You can read more about the body structure in the [documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html).
     * 
     */
    public Output<String> dashboardBody() {
        return this.dashboardBody;
    }
    /**
     * The name of the dashboard.
     * 
     */
    @Export(name="dashboardName", refs={String.class}, tree="[0]")
    private Output<String> dashboardName;

    /**
     * @return The name of the dashboard.
     * 
     */
    public Output<String> dashboardName() {
        return this.dashboardName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Dashboard(String name) {
        this(name, DashboardArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Dashboard(String name, DashboardArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Dashboard(String name, DashboardArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/dashboard:Dashboard", name, args == null ? DashboardArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Dashboard(String name, Output<String> id, @Nullable DashboardState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:cloudwatch/dashboard:Dashboard", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Dashboard get(String name, Output<String> id, @Nullable DashboardState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Dashboard(name, id, state, options);
    }
}
