// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudhsmv2.inputs;

import com.pulumi.aws.cloudhsmv2.inputs.ClusterClusterCertificateArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterState Empty = new ClusterState();

    /**
     * The list of cluster certificates.
     * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
     * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
     * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
     * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
     * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
     * 
     */
    @Import(name="clusterCertificates")
    private @Nullable Output<List<ClusterClusterCertificateArgs>> clusterCertificates;

    /**
     * @return The list of cluster certificates.
     * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
     * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
     * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
     * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
     * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
     * 
     */
    public Optional<Output<List<ClusterClusterCertificateArgs>>> clusterCertificates() {
        return Optional.ofNullable(this.clusterCertificates);
    }

    /**
     * The id of the CloudHSM cluster.
     * 
     */
    @Import(name="clusterId")
    private @Nullable Output<String> clusterId;

    /**
     * @return The id of the CloudHSM cluster.
     * 
     */
    public Optional<Output<String>> clusterId() {
        return Optional.ofNullable(this.clusterId);
    }

    /**
     * The state of the CloudHSM cluster.
     * 
     */
    @Import(name="clusterState")
    private @Nullable Output<String> clusterState;

    /**
     * @return The state of the CloudHSM cluster.
     * 
     */
    public Optional<Output<String>> clusterState() {
        return Optional.ofNullable(this.clusterState);
    }

    /**
     * The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     * 
     */
    @Import(name="hsmType")
    private @Nullable Output<String> hsmType;

    /**
     * @return The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
     * 
     */
    public Optional<Output<String>> hsmType() {
        return Optional.ofNullable(this.hsmType);
    }

    /**
     * The ID of the security group associated with the CloudHSM cluster.
     * 
     */
    @Import(name="securityGroupId")
    private @Nullable Output<String> securityGroupId;

    /**
     * @return The ID of the security group associated with the CloudHSM cluster.
     * 
     */
    public Optional<Output<String>> securityGroupId() {
        return Optional.ofNullable(this.securityGroupId);
    }

    /**
     * ID of Cloud HSM v2 cluster backup to be restored.
     * 
     */
    @Import(name="sourceBackupIdentifier")
    private @Nullable Output<String> sourceBackupIdentifier;

    /**
     * @return ID of Cloud HSM v2 cluster backup to be restored.
     * 
     */
    public Optional<Output<String>> sourceBackupIdentifier() {
        return Optional.ofNullable(this.sourceBackupIdentifier);
    }

    /**
     * The IDs of subnets in which cluster will operate.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return The IDs of subnets in which cluster will operate.
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The id of the VPC that the CloudHSM cluster resides in.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return The id of the VPC that the CloudHSM cluster resides in.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    private ClusterState() {}

    private ClusterState(ClusterState $) {
        this.clusterCertificates = $.clusterCertificates;
        this.clusterId = $.clusterId;
        this.clusterState = $.clusterState;
        this.hsmType = $.hsmType;
        this.securityGroupId = $.securityGroupId;
        this.sourceBackupIdentifier = $.sourceBackupIdentifier;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterState $;

        public Builder() {
            $ = new ClusterState();
        }

        public Builder(ClusterState defaults) {
            $ = new ClusterState(Objects.requireNonNull(defaults));
        }

        /**
         * @param clusterCertificates The list of cluster certificates.
         * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
         * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
         * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
         * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
         * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
         * 
         * @return builder
         * 
         */
        public Builder clusterCertificates(@Nullable Output<List<ClusterClusterCertificateArgs>> clusterCertificates) {
            $.clusterCertificates = clusterCertificates;
            return this;
        }

        /**
         * @param clusterCertificates The list of cluster certificates.
         * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
         * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
         * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
         * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
         * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
         * 
         * @return builder
         * 
         */
        public Builder clusterCertificates(List<ClusterClusterCertificateArgs> clusterCertificates) {
            return clusterCertificates(Output.of(clusterCertificates));
        }

        /**
         * @param clusterCertificates The list of cluster certificates.
         * * `cluster_certificates.0.cluster_certificate` - The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster&#39;s owner.
         * * `cluster_certificates.0.cluster_csr` - The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
         * * `cluster_certificates.0.aws_hardware_certificate` - The HSM hardware certificate issued (signed) by AWS CloudHSM.
         * * `cluster_certificates.0.hsm_certificate` - The HSM certificate issued (signed) by the HSM hardware.
         * * `cluster_certificates.0.manufacturer_hardware_certificate` - The HSM hardware certificate issued (signed) by the hardware manufacturer.
         * 
         * @return builder
         * 
         */
        public Builder clusterCertificates(ClusterClusterCertificateArgs... clusterCertificates) {
            return clusterCertificates(List.of(clusterCertificates));
        }

        /**
         * @param clusterId The id of the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(@Nullable Output<String> clusterId) {
            $.clusterId = clusterId;
            return this;
        }

        /**
         * @param clusterId The id of the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(String clusterId) {
            return clusterId(Output.of(clusterId));
        }

        /**
         * @param clusterState The state of the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterState(@Nullable Output<String> clusterState) {
            $.clusterState = clusterState;
            return this;
        }

        /**
         * @param clusterState The state of the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterState(String clusterState) {
            return clusterState(Output.of(clusterState));
        }

        /**
         * @param hsmType The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
         * 
         * @return builder
         * 
         */
        public Builder hsmType(@Nullable Output<String> hsmType) {
            $.hsmType = hsmType;
            return this;
        }

        /**
         * @param hsmType The type of HSM module in the cluster. Currently, only `hsm1.medium` is supported.
         * 
         * @return builder
         * 
         */
        public Builder hsmType(String hsmType) {
            return hsmType(Output.of(hsmType));
        }

        /**
         * @param securityGroupId The ID of the security group associated with the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(@Nullable Output<String> securityGroupId) {
            $.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * @param securityGroupId The ID of the security group associated with the CloudHSM cluster.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupId(String securityGroupId) {
            return securityGroupId(Output.of(securityGroupId));
        }

        /**
         * @param sourceBackupIdentifier ID of Cloud HSM v2 cluster backup to be restored.
         * 
         * @return builder
         * 
         */
        public Builder sourceBackupIdentifier(@Nullable Output<String> sourceBackupIdentifier) {
            $.sourceBackupIdentifier = sourceBackupIdentifier;
            return this;
        }

        /**
         * @param sourceBackupIdentifier ID of Cloud HSM v2 cluster backup to be restored.
         * 
         * @return builder
         * 
         */
        public Builder sourceBackupIdentifier(String sourceBackupIdentifier) {
            return sourceBackupIdentifier(Output.of(sourceBackupIdentifier));
        }

        /**
         * @param subnetIds The IDs of subnets in which cluster will operate.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds The IDs of subnets in which cluster will operate.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds The IDs of subnets in which cluster will operate.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param vpcId The id of the VPC that the CloudHSM cluster resides in.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The id of the VPC that the CloudHSM cluster resides in.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        public ClusterState build() {
            return $;
        }
    }

}
