// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.cloudhsmv2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class HsmArgs extends com.pulumi.resources.ResourceArgs {

    public static final HsmArgs Empty = new HsmArgs();

    /**
     * The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * The ID of Cloud HSM v2 cluster to which HSM will be added.
     * 
     */
    @Import(name="clusterId", required=true)
    private Output<String> clusterId;

    /**
     * @return The ID of Cloud HSM v2 cluster to which HSM will be added.
     * 
     */
    public Output<String> clusterId() {
        return this.clusterId;
    }

    /**
     * The IP address of HSM module. Must be within the CIDR of selected subnet.
     * 
     */
    @Import(name="ipAddress")
    private @Nullable Output<String> ipAddress;

    /**
     * @return The IP address of HSM module. Must be within the CIDR of selected subnet.
     * 
     */
    public Optional<Output<String>> ipAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    /**
     * The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    private HsmArgs() {}

    private HsmArgs(HsmArgs $) {
        this.availabilityZone = $.availabilityZone;
        this.clusterId = $.clusterId;
        this.ipAddress = $.ipAddress;
        this.subnetId = $.subnetId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(HsmArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HsmArgs $;

        public Builder() {
            $ = new HsmArgs();
        }

        public Builder(HsmArgs defaults) {
            $ = new HsmArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param availabilityZone The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The IDs of AZ in which HSM module will be located. Conflicts with `subnet_id`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param clusterId The ID of Cloud HSM v2 cluster to which HSM will be added.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(Output<String> clusterId) {
            $.clusterId = clusterId;
            return this;
        }

        /**
         * @param clusterId The ID of Cloud HSM v2 cluster to which HSM will be added.
         * 
         * @return builder
         * 
         */
        public Builder clusterId(String clusterId) {
            return clusterId(Output.of(clusterId));
        }

        /**
         * @param ipAddress The IP address of HSM module. Must be within the CIDR of selected subnet.
         * 
         * @return builder
         * 
         */
        public Builder ipAddress(@Nullable Output<String> ipAddress) {
            $.ipAddress = ipAddress;
            return this;
        }

        /**
         * @param ipAddress The IP address of HSM module. Must be within the CIDR of selected subnet.
         * 
         * @return builder
         * 
         */
        public Builder ipAddress(String ipAddress) {
            return ipAddress(Output.of(ipAddress));
        }

        /**
         * @param subnetId The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The ID of subnet in which HSM module will be located. Conflicts with `availability_zone`.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        public HsmArgs build() {
            $.clusterId = Objects.requireNonNull($.clusterId, "expected parameter 'clusterId' to be non-null");
            return $;
        }
    }

}
